/*
 * Decompiled with CFR 0.152.
 */
package net.sandrohc.jikan.query.season;

import net.sandrohc.jikan.Jikan;
import net.sandrohc.jikan.model.DataListHolderWithPagination;
import net.sandrohc.jikan.model.anime.Anime;
import net.sandrohc.jikan.model.season.Season;
import net.sandrohc.jikan.query.PageableQuery;
import net.sandrohc.jikan.query.QueryUrlBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SeasonQuery
extends PageableQuery<DataListHolderWithPagination<Anime>, Flux<Anime>, SeasonQuery> {
    protected final int year;
    protected final Season season;

    public SeasonQuery(Jikan jikan, int year, Season season) {
        super(jikan);
        this.year = year;
        this.season = season;
    }

    @Override
    public QueryUrlBuilder getInnerUrl() {
        return QueryUrlBuilder.create().path("/seasons/" + this.year + '/' + this.season.getSearch());
    }

    @Override
    public Flux<Anime> process(Mono<DataListHolderWithPagination<Anime>> content) {
        return content.flatMapMany(holder -> Flux.fromIterable((Iterable)holder.data));
    }
}

