/*
 * Decompiled with CFR 0.152.
 */
package net.sandrohc.jikan.query.user;

import net.sandrohc.jikan.Jikan;
import net.sandrohc.jikan.model.DataListHolder;
import net.sandrohc.jikan.model.user.UserHistoryEntry;
import net.sandrohc.jikan.query.Query;
import net.sandrohc.jikan.query.QueryUrlBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UserHistoryQuery
extends Query<DataListHolder<UserHistoryEntry>, Flux<UserHistoryEntry>> {
    protected final String type;
    protected final String username;

    public UserHistoryQuery(Jikan jikan, String type, String username) {
        super(jikan);
        this.type = type;
        this.username = username;
    }

    @Override
    public QueryUrlBuilder getUrl() {
        return QueryUrlBuilder.create().path("/users/" + this.username + "/history").param("type", this.type);
    }

    @Override
    public Flux<UserHistoryEntry> process(Mono<DataListHolder<UserHistoryEntry>> content) {
        return content.flatMapMany(holder -> Flux.fromIterable(holder.data));
    }
}

