/*
 * Decompiled with CFR 0.152.
 */
package net.sandrohc.jikan.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.Duration;

public class DaysDeserializer
extends JsonDeserializer<Duration> {
    private static final int MINUTES_IN_DAY = 1440;

    public Duration deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        if (p.currentToken() != JsonToken.VALUE_NUMBER_FLOAT) {
            return null;
        }
        double days = p.getDoubleValue();
        long minutes = (long)(days * 1440.0);
        return Duration.ofMinutes(minutes);
    }
}

