/*
 * Decompiled with CFR 0.152.
 */
package net.sandrohc.jikan.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EpisodeDurationDeserializer
extends JsonDeserializer<Duration> {
    protected static final Pattern REGEX_DURATION = Pattern.compile("((?<minutes>\\d+) min)");

    public Duration deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        if (p.currentToken() == JsonToken.VALUE_STRING) {
            return this.parseString(p);
        }
        if (p.currentToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.parseNumber(p);
        }
        return null;
    }

    private Duration parseString(JsonParser p) throws IOException {
        String str = p.getText();
        if (str == null) {
            return null;
        }
        Matcher matcher = REGEX_DURATION.matcher(str);
        if (!matcher.find()) {
            return null;
        }
        String minutesStr = matcher.group("minutes");
        if (minutesStr == null) {
            return null;
        }
        int minutes = Integer.parseInt(minutesStr);
        return Duration.ofMinutes(minutes);
    }

    private Duration parseNumber(JsonParser p) throws IOException {
        int number = p.getIntValue();
        return Duration.ofSeconds(number);
    }
}

