/*
 * Decompiled with CFR 0.152.
 */
package net.sandrohc.jikan.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.sandrohc.jikan.model.anime.Song;

public class SongDeserializer
extends JsonDeserializer<Song> {
    protected static final Pattern REGEX_SONG = Pattern.compile("(?<number>\\d+):[ \u00a0]\"(?<name>.*?)\" by (?<author>.*?)[ \u00a0]\\(eps (?<episodes>\\d+(?:-\\d+)?)\\)");

    public Song deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        String str = p.getText();
        if (str == null) {
            return null;
        }
        Matcher matcher = REGEX_SONG.matcher(str);
        if (!matcher.find()) {
            return null;
        }
        String numberStr = matcher.group("number");
        String name = matcher.group("name");
        String author = matcher.group("author");
        String episodes = matcher.group("episodes");
        Song song = new Song();
        song.setNumber(this.getNumber(numberStr));
        song.setName(name);
        song.setArtist(author);
        song.setEpisodes(this.getEpisodeRange(episodes));
        return song;
    }

    private int getNumber(String value) {
        return value != null ? Integer.parseInt(value) : 0;
    }

    private Collection<Integer> getEpisodeRange(String value) {
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        int rangeSepIndex = value.indexOf(45);
        if (rangeSepIndex != -1) {
            int from = Integer.parseInt(value.substring(0, rangeSepIndex));
            int to = Integer.parseInt(value.substring(rangeSepIndex + 1));
            return IntStream.range(from, to + 1).boxed().collect(Collectors.toList());
        }
        int episode = Integer.parseInt(value);
        return Collections.singletonList(episode);
    }
}

