/*
 * Decompiled with CFR 0.152.
 */
package net.sandrohc.jikan.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import java.util.regex.Pattern;

public class StringDeserializer
extends com.fasterxml.jackson.databind.deser.std.StringDeserializer {
    protected static final Pattern REGEX_NON_PRINTABLE = Pattern.compile("[\\p{Cc}\\p{Cf}\\p{Co}\\p{Cn}]");
    protected static final Pattern REGEX_WHITESPACE = Pattern.compile("\\p{Zs}");

    public String deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        String text = super.deserialize(p, ctx);
        return StringDeserializer.cleanText(text);
    }

    private static String cleanText(String text) {
        if (text == null) {
            return null;
        }
        String clean = REGEX_NON_PRINTABLE.matcher(text).replaceAll("");
        clean = REGEX_WHITESPACE.matcher(clean).replaceAll(" ");
        clean = clean.trim();
        return clean;
    }
}

