/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.graph.jena.expression;

import java.math.BigInteger;
import javax.xml.datatype.XMLGregorianCalendar;
import net.sansa_stack.query.spark.graph.jena.expression.Filter;
import net.sansa_stack.query.spark.graph.jena.util.Result;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.E_Add;
import org.apache.jena.sparql.expr.E_Subtract;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.NodeValue;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e4Aa\u0004\t\u0001?!A!\u0006\u0001B\u0001B\u0003%1\u0006C\u00039\u0001\u0011\u0005\u0011\bC\u0004=\u0001\t\u0007I\u0011B\u001f\t\r\u0019\u0003\u0001\u0015!\u0003?\u0011\u001d9\u0005A1A\u0005\n!Ca\u0001\u0014\u0001!\u0002\u0013I\u0005bB'\u0001\u0005\u0004%I\u0001\u0013\u0005\u0007\u001d\u0002\u0001\u000b\u0011B%\t\u000b=\u0003A\u0011\t)\t\u000b=\u0003A\u0011\t4\t\u000b9\u0004A\u0011I8\t\u000bI\u0004A\u0011\u0001%\t\u000bM\u0004A\u0011\u0001%\t\u000bQ\u0004A\u0011B;\u0003\u000f\r{W\u000e]1sK*\u0011\u0011CE\u0001\u000bKb\u0004(/Z:tS>t'BA\n\u0015\u0003\u0011QWM\\1\u000b\u0005U1\u0012!B4sCBD'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$A\u0003rk\u0016\u0014\u0018P\u0003\u0002\u001c9\u0005Y1/\u00198tC~\u001bH/Y2l\u0015\u0005i\u0012a\u00018fi\u000e\u00011c\u0001\u0001!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\u0004\"a\n\u0015\u000e\u0003AI!!\u000b\t\u0003\r\u0019KG\u000e^3s\u0003\u0005)\u0007C\u0001\u00177\u001b\u0005i#B\u0001\u00180\u0003\u0011)\u0007\u0010\u001d:\u000b\u0005A\n\u0014AB:qCJ\fHN\u0003\u0002\u0014e)\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0013\t9TFA\u0007FqB\u0014h)\u001e8di&|gNM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005iZ\u0004CA\u0014\u0001\u0011\u0015Q#\u00011\u0001,\u0003\r!\u0018mZ\u000b\u0002}A\u0011q\bR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0005Y\u0006twMC\u0001D\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0003%AB*ue&tw-\u0001\u0003uC\u001e\u0004\u0013\u0001\u00027fMR,\u0012!\u0013\t\u0003Y)K!aS\u0017\u0003\t\u0015C\bO]\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\u0011\u00154\u0018\r\\;bi\u0016$\"!\u0015+\u0011\u0005\u0005\u0012\u0016BA*#\u0005\u001d\u0011un\u001c7fC:DQ!V\u0005A\u0002Y\u000b\u0001b]8mkRLwN\u001c\t\u0005/z\u000b\u0017M\u0004\u0002Y9B\u0011\u0011LI\u0007\u00025*\u00111LH\u0001\u0007yI|w\u000e\u001e \n\u0005u\u0013\u0013A\u0002)sK\u0012,g-\u0003\u0002`A\n\u0019Q*\u00199\u000b\u0005u\u0013\u0003C\u00012e\u001b\u0005\u0019'BA\u000b2\u0013\t)7M\u0001\u0003O_\u0012,GCA)h\u0011\u0015)&\u00021\u0001i!\rIG.Y\u0007\u0002U*\u00111NE\u0001\u0005kRLG.\u0003\u0002nU\n1!+Z:vYR\faaZ3u)\u0006<W#\u00019\u0011\u0005]\u000b\u0018BA#a\u0003\u001d9W\r\u001e'fMR\f\u0001bZ3u%&<\u0007\u000e^\u0001\bG>l\u0007/\u0019:f)\r\tf\u000f\u001f\u0005\u0006o:\u0001\r!Y\u0001\nY\u00164GOV1mk\u0016DQ!\u0014\bA\u0002%\u0003")
public class Compare
implements Filter {
    private final ExprFunction2 e;
    private final String tag;
    private final Expr left;
    private final Expr right;

    private String tag() {
        return this.tag;
    }

    private Expr left() {
        return this.left;
    }

    private Expr right() {
        return this.right;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean evaluate(Map<Node, Node> solution) {
        boolean bl;
        Node leftValue = (Node)solution.apply((Object)this.left().asVar().asNode());
        if (this.right().isConstant()) {
            bl = this.compare(leftValue, this.right());
            return bl;
        } else if (this.right().isFunction()) {
            Expr expr = this.right();
            if (expr instanceof E_Add) {
                E_Add e_Add = (E_Add)expr;
                bl = e_Add.getArg1().isVariable() ? this.compare(leftValue, (Expr)NodeValue.makeDouble((double)(new StringOps(Predef$.MODULE$.augmentString(((Node)solution.apply((Object)e_Add.getArg1().asVar().asNode())).getLiteralValue().toString())).toDouble() + new StringOps(Predef$.MODULE$.augmentString(e_Add.getArg2().getConstant().toString())).toDouble()))) : this.compare(leftValue, (Expr)NodeValue.makeDouble((double)(new StringOps(Predef$.MODULE$.augmentString(e_Add.getArg1().getConstant().toString())).toDouble() + new StringOps(Predef$.MODULE$.augmentString(((Node)solution.apply((Object)e_Add.getArg2().asVar().asNode())).getLiteralValue().toString())).toDouble())));
                return bl;
            } else {
                if (!(expr instanceof E_Subtract)) throw new MatchError((Object)expr);
                E_Subtract e_Subtract = (E_Subtract)expr;
                bl = e_Subtract.getArg1().isVariable() ? this.compare(leftValue, (Expr)NodeValue.makeDouble((double)(new StringOps(Predef$.MODULE$.augmentString(((Node)solution.apply((Object)e_Subtract.getArg1().asVar().asNode())).getLiteralValue().toString())).toDouble() - new StringOps(Predef$.MODULE$.augmentString(e_Subtract.getArg2().getConstant().toString())).toDouble()))) : this.compare(leftValue, (Expr)NodeValue.makeDouble((double)(new StringOps(Predef$.MODULE$.augmentString(e_Subtract.getArg1().getConstant().toString())).toDouble() - new StringOps(Predef$.MODULE$.augmentString(((Node)solution.apply((Object)e_Subtract.getArg2().asVar().asNode())).getLiteralValue().toString())).toDouble())));
            }
            return bl;
        } else {
            if (!this.right().isVariable()) return false;
            solution.apply((Object)this.right().asVar().asNode());
            return false;
        }
    }

    @Override
    public boolean evaluate(Result<Node> solution) {
        return true;
    }

    @Override
    public String getTag() {
        return this.tag();
    }

    public Expr getLeft() {
        return this.left();
    }

    public Expr getRight() {
        return this.right();
    }

    private boolean compare(Node leftValue, Expr right) {
        if (right.getConstant().isDate()) {
            return this.e.eval(NodeValue.makeDate((String)leftValue.getLiteralLexicalForm()), NodeValue.makeDate((XMLGregorianCalendar)right.getConstant().getDateTime())).toString().equals("true");
        }
        if (right.getConstant().isInteger()) {
            return this.e.eval(NodeValue.makeInteger((String)leftValue.getLiteralLexicalForm()), NodeValue.makeInteger((BigInteger)right.getConstant().getInteger())).toString().equals("true");
        }
        if (right.getConstant().isFloat()) {
            return this.e.eval(NodeValue.makeFloat((float)new StringOps(Predef$.MODULE$.augmentString(leftValue.getLiteralLexicalForm())).toFloat()), NodeValue.makeFloat((float)right.getConstant().getFloat())).toString().equals("true");
        }
        if (right.getConstant().isDouble()) {
            return this.e.eval(NodeValue.makeDouble((double)new StringOps(Predef$.MODULE$.augmentString(leftValue.getLiteralLexicalForm())).toDouble()), NodeValue.makeDouble((double)right.getConstant().getDouble())).toString().equals("true");
        }
        if (right.getConstant().isIRI()) {
            return this.e.eval(NodeValue.makeNode((Node)leftValue), NodeValue.makeNode((Node)right.getConstant().asNode())).toString().equals("true");
        }
        return false;
    }

    public Compare(ExprFunction2 e) {
        this.e = e;
        this.tag = "Filter Comparision";
        this.left = e.getArg1();
        this.right = e.getArg2();
    }
}

