/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.graph.jena.model;

import java.io.Serializable;
import net.sansa_stack.query.spark.graph.jena.expression.Expression;
import net.sansa_stack.query.spark.graph.jena.expression.Filter;
import net.sansa_stack.query.spark.graph.jena.expression.Pattern;
import net.sansa_stack.query.spark.graph.jena.model.Config$;
import net.sansa_stack.query.spark.graph.jena.resultOp.ResultGroup$;
import net.sansa_stack.query.spark.graph.jena.util.BasicGraphPattern;
import net.sansa_stack.query.spark.graph.jena.util.MatchCandidate;
import net.sansa_stack.query.spark.graph.jena.util.MatchSet$;
import net.sansa_stack.query.spark.graph.jena.util.Result;
import net.sansa_stack.query.spark.graph.jena.util.ResultFactory$;
import net.sansa_stack.query.spark.graph.jena.util.TriplePattern;
import net.sansa_stack.rdf.spark.model.package$;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.Lang;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.graphx.Graph;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

public final class SparkExecutionModel$ {
    public static SparkExecutionModel$ MODULE$;
    private SparkSession spark;
    private Graph<Node, Node> graph;

    static {
        new SparkExecutionModel$();
    }

    private SparkSession spark() {
        return this.spark;
    }

    private void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private Graph<Node, Node> graph() {
        return this.graph;
    }

    private void graph_$eq(Graph<Node, Node> x$1) {
        this.graph = x$1;
    }

    public void setSparkSession(SparkSession spark) {
        this.spark_$eq(spark);
    }

    public void createSparkSession() {
        String string = Config$.MODULE$.getMaster();
        String string2 = "";
        Object object = !(string != null ? !string.equals(string2) : string2 != null) ? Config$.MODULE$.setMaster("local[*]") : BoxedUnit.UNIT;
        String string3 = Config$.MODULE$.getInputGraphFile();
        String string4 = "";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            throw new ExceptionInInitializerError("Input graph file path is not initialized");
        }
        String string5 = Config$.MODULE$.getInputQueryFile();
        String string6 = "";
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            throw new ExceptionInInitializerError("Input query file path is not initialized");
        }
        if (Config$.MODULE$.getLang() == null) {
            throw new ExceptionInInitializerError("The language of input graph file is not initialized");
        }
        this.spark_$eq(SparkSession$.MODULE$.builder().master(Config$.MODULE$.getMaster()).appName(Config$.MODULE$.getAppName()).getOrCreate());
        this.loadGraph();
    }

    public void createSparkSession(SparkSession session) {
        if (this.spark() == null) {
            this.spark_$eq(session);
            return;
        }
        throw new IllegalArgumentException("spark session has been set already");
    }

    public void loadGraph() {
        this.loadGraph(Config$.MODULE$.getInputGraphFile(), Config$.MODULE$.getLang());
    }

    public void loadGraph(String path, Lang lang) {
        if (this.spark() == null) {
            this.createSparkSession();
        }
        this.graph_$eq((Graph<Node, Node>)package$.MODULE$.GraphLoader((RDD)net.sansa_stack.rdf.spark.io.package$.MODULE$.RDFReader(this.spark()).rdf(lang).apply((Object)path)).asGraph().cache());
    }

    public void loadGraph(Graph<Node, Node> graph) {
        this.graph_$eq(graph);
    }

    public RDD<Result<Node>> basicGraphPatternMatch(BasicGraphPattern bgp) {
        if (this.spark() == null) {
            this.setSession();
        }
        Broadcast patterns = this.spark().sparkContext().broadcast(bgp.triplePatterns(), ClassTag$.MODULE$.apply(List.class));
        Graph candidateGraph = MatchSet$.MODULE$.createCandidateGraph(this.graph(), (Broadcast<List<TriplePattern>>)patterns).cache();
        Graph<Node, Node> qual$1 = this.graph();
        boolean x$1 = qual$1.unpersist$default$1();
        qual$1.unpersist(x$1);
        Graph localGraph = MatchSet$.MODULE$.localMatch((Graph<Iterable<MatchCandidate>, Node>)candidateGraph, (Broadcast<List<TriplePattern>>)patterns).cache();
        candidateGraph.unpersist(candidateGraph.unpersist$default$1());
        Graph mergedGraph = MatchSet$.MODULE$.joinNeighbourCandidate((Graph<Iterable<MatchCandidate>, Node>)localGraph).cache();
        localGraph.unpersist(localGraph.unpersist$default$1());
        Graph remoteGraph = MatchSet$.MODULE$.remoteMatch((Graph<Tuple2<Iterable<MatchCandidate>, Iterable<MatchCandidate>>, Node>)mergedGraph).cache();
        mergedGraph.unpersist(mergedGraph.unpersist$default$1());
        RDD results = MatchSet$.MODULE$.generateResultRDD((Graph<Iterable<MatchCandidate>, Node>)remoteGraph, (Broadcast<List<TriplePattern>>)patterns, this.spark()).cache();
        remoteGraph.unpersist(remoteGraph.unpersist$default$1());
        return results;
    }

    public RDD<Result<Node>> project(RDD<Result<Node>> result2, Set<Node> varSet) {
        Broadcast varBroadcast = this.spark().sparkContext().broadcast(varSet, ClassTag$.MODULE$.apply(Set.class));
        RDD newResult = result2.map((Function1 & Serializable & scala.Serializable)result -> result.project((Set)varBroadcast.value()), ClassTag$.MODULE$.apply(Result.class)).cache();
        result2.unpersist(result2.unpersist$default$1());
        varBroadcast.unpersist();
        return newResult;
    }

    public RDD<Result<Node>> distinct(RDD<Result<Node>> result) {
        SparkContext qual$1 = this.spark().sparkContext();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).distinct());
        int x$2 = qual$1.parallelize$default$2();
        RDD newResult = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Result.class)).cache();
        return newResult;
    }

    public RDD<Result<Node>> slice(RDD<Result<Node>> result, int limit, int offset) {
        Result[] newArray = (Result[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).slice(offset, limit + offset);
        result.unpersist(result.unpersist$default$1());
        SparkContext qual$1 = this.spark().sparkContext();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])newArray);
        int x$2 = qual$1.parallelize$default$2();
        RDD newResult = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Result.class)).cache();
        return newResult;
    }

    public RDD<Result<Node>> group(RDD<Result<Node>> result, List<Node> vars, List<ExprAggregator> aggregates) {
        RDD group = result.groupBy((Function1 & Serializable & scala.Serializable)r -> r.projectNewResult(vars.toSet()), ClassTag$.MODULE$.apply(Result.class)).cache();
        ObjectRef newResult = ObjectRef.create((Object)group.map((Function1 & Serializable & scala.Serializable)x$1 -> (Result)x$1._1(), ClassTag$.MODULE$.apply(Result.class)));
        result.unpersist(result.unpersist$default$1());
        aggregates.foreach((Function1 & Serializable & scala.Serializable)aggr -> {
            SparkExecutionModel$.$anonfun$group$3(newResult, group, aggr);
            return BoxedUnit.UNIT;
        });
        group.unpersist(group.unpersist$default$1());
        return (RDD)newResult.elem;
    }

    public RDD<Result<Node>> extend(RDD<Result<Node>> result, Node sub, Node expr) {
        RDD newResult = result.map((Function1 & Serializable & scala.Serializable)r -> r.addMapping(sub, r.getValue(expr)), ClassTag$.MODULE$.apply(Result.class)).cache();
        result.unpersist(result.unpersist$default$1());
        return newResult;
    }

    public RDD<Result<Node>> filter(RDD<Result<Node>> result, List<Expression> filters) {
        Broadcast broadcast = this.spark().sparkContext().broadcast(filters, ClassTag$.MODULE$.apply(List.class));
        ObjectRef intermediate = ObjectRef.create((Object)result.cache());
        ((List)broadcast.value()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SparkExecutionModel$.$anonfun$filter$1(intermediate, x0$1);
            return BoxedUnit.UNIT;
        });
        return (RDD)intermediate.elem;
    }

    public RDD<Result<Node>> leftJoin(RDD<Result<Node>> left, RDD<Result<Node>> right) {
        RDD rDD;
        Set<Node> leftVars = this.getVars(left);
        Set<Node> rightVars = this.getVars(right);
        Broadcast intersection = this.spark().sparkContext().broadcast(leftVars.intersect(rightVars), ClassTag$.MODULE$.apply(Set.class));
        RDD newResult = null;
        if (((SetLike)intersection.value()).isEmpty()) {
            newResult = left.cartesian(right, ClassTag$.MODULE$.apply(Result.class)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Result r1 = (Result)tuple2._1();
                    Result r2 = (Result)tuple2._2();
                    return r1.merge(r2);
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Result.class)).cache();
            left.unpersist(left.unpersist$default$1());
            rDD = right.unpersist(right.unpersist$default$1());
        } else {
            RDD leftPair = left.map((Function1 & Serializable & scala.Serializable)r -> new Tuple2(r.getValueSet((Set)intersection.value()), r), ClassTag$.MODULE$.apply(Tuple2.class));
            left.unpersist(left.unpersist$default$1());
            RDD rightPair = right.map((Function1 & Serializable & scala.Serializable)r -> new Tuple2(r.getValueSet((Set)intersection.value()), r), ClassTag$.MODULE$.apply(Tuple2.class));
            right.unpersist(right.unpersist$default$1());
            intersection.unpersist();
            RDD x$1 = leftPair;
            ClassTag x$2 = ClassTag$.MODULE$.apply(Set.class);
            ClassTag x$3 = ClassTag$.MODULE$.apply(Result.class);
            Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
            newResult = RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).leftOuterJoin(rightPair).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple2 pair = (Tuple2)tuple2._2();
                    Option option = (Option)pair._2();
                    if (option instanceof Some) {
                        return ((Result)pair._1()).merge((Result)((Option)pair._2()).get());
                    }
                    if (None$.MODULE$.equals(option)) {
                        return (Result)pair._1();
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Result.class)).cache();
            rDD = BoxedUnit.UNIT;
        }
        return newResult;
    }

    public RDD<Result<Node>> union(RDD<Result<Node>> left, RDD<Result<Node>> right) {
        RDD newResult = left.union(right).cache();
        left.unpersist(left.unpersist$default$1());
        right.unpersist(right.unpersist$default$1());
        return newResult;
    }

    public RDD<Result<Node>> minus(RDD<Result<Node>> left, RDD<Result<Node>> right) {
        Set<Node> leftVars = this.getVars(left);
        Set<Node> rightVars = this.getVars(right);
        Broadcast intersection = this.spark().sparkContext().broadcast(leftVars.intersect(rightVars), ClassTag$.MODULE$.apply(Set.class));
        RDD newResult = null;
        if (((SetLike)intersection.value()).isEmpty()) {
            newResult = left;
        } else {
            RDD leftPair = left.map((Function1 & Serializable & scala.Serializable)result -> new Tuple2(result.projectNewResult((Set)intersection.value()), result), ClassTag$.MODULE$.apply(Tuple2.class));
            RDD rightPair = right.map((Function1 & Serializable & scala.Serializable)result -> new Tuple2(result, null), ClassTag$.MODULE$.apply(Tuple2.class));
            RDD x$1 = leftPair;
            ClassTag x$2 = ClassTag$.MODULE$.apply(Result.class);
            ClassTag x$3 = ClassTag$.MODULE$.apply(Result.class);
            Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
            newResult = RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).subtractByKey(rightPair, ClassTag$.MODULE$.Null()).map((Function1 & Serializable & scala.Serializable)pair -> (Result)pair._2(), ClassTag$.MODULE$.apply(Result.class)).cache();
        }
        left.unpersist(left.unpersist$default$1());
        right.unpersist(right.unpersist$default$1());
        return newResult;
    }

    public SparkSession getSession() {
        return this.spark();
    }

    public Graph<Node, Node> getGraph() {
        return this.graph();
    }

    private void setSession() {
        if (this.spark() == null) {
            this.createSparkSession();
            return;
        }
    }

    private Set<Node> getVars(RDD<Result<Node>> results) {
        return (Set)results.map((Function1 & Serializable & scala.Serializable)result -> result.getField(), ClassTag$.MODULE$.apply(Set.class)).reduce((Function2 & Serializable & scala.Serializable)(s1, s2) -> (Set)s1.$plus$plus((GenTraversableOnce)s2));
    }

    public static final /* synthetic */ void $anonfun$group$3(ObjectRef newResult$1, RDD group$1, ExprAggregator aggr) {
        Node variable = aggr.getVar().asNode();
        String aggrOp = aggr.getAggregator().getName();
        Node key = aggr.getAggregator().getExprList().get(0).asVar().asNode();
        newResult$1.elem = MODULE$.leftJoin((RDD<Result<Node>>)((RDD)newResult$1.elem), (RDD<Result<Node>>)group$1.map((Function1 & Serializable & scala.Serializable)pair -> ResultFactory$.MODULE$.merge((Result)pair._1(), ResultGroup$.MODULE$.aggregateOp((Iterable<Result<Node>>)((Iterable)pair._2()), variable, aggrOp, key), ClassTag$.MODULE$.apply(Node.class)), ClassTag$.MODULE$.apply(Result.class)));
    }

    public static final /* synthetic */ void $anonfun$filter$1(ObjectRef intermediate$1, Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof Filter) {
            Filter filter = (Filter)expression;
            intermediate$1.elem = ((RDD)intermediate$1.elem).filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)filter.evaluate(r)));
            return;
        }
        if (expression instanceof Pattern) {
            Pattern pattern = (Pattern)expression;
            intermediate$1.elem = pattern.evaluate((RDD<Result<Node>>)((RDD)intermediate$1.elem));
            return;
        }
        throw new MatchError((Object)expression);
    }

    private SparkExecutionModel$() {
        MODULE$ = this;
    }
}

