/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.hdt;

import java.util.List;
import net.sansa_stack.query.spark.hdt.SparqlOpVisitor$;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.OpWalker;
import org.apache.jena.sparql.expr.Expr;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Sparql2SQL$ {
    public static Sparql2SQL$ MODULE$;

    static {
        new Sparql2SQL$();
    }

    public String filterHDT(Expr cond) {
        return this.createFilterString(cond);
    }

    public String getColumnName(String value) {
        if (value.trim().equalsIgnoreCase("?S")) {
            return "subjects_hdt.name";
        }
        if (value.trim().equalsIgnoreCase("?P")) {
            return "predicates_hdt.name";
        }
        if (value.trim().equalsIgnoreCase("?O")) {
            return "objects_hdt.name";
        }
        return "";
    }

    public String createFilterString(Expr cond) {
        String fName = cond.getFunction().getFunctionName(null);
        List argsList = cond.getFunction().getArgs();
        if (fName.trim().equals("strstarts")) {
            return new StringBuilder(9).append(this.getColumnName(argsList.get(0).toString())).append(" like '").append(argsList.get(1).toString().replace("\"", "")).append("%'").toString();
        }
        if (fName.toUpperCase().trim().equals("STRLEN")) {
            return new StringBuilder(8).append("length(").append(this.getColumnName(argsList.get(0).toString())).append(")").toString();
        }
        if (fName.toUpperCase().trim().equals("SUBSTR")) {
            if (argsList.size() == 2) {
                return new StringBuilder(10).append(" substr(").append(this.getColumnName(argsList.get(0).toString())).append(",").append(argsList.get(1).toString()).append(")").toString();
            }
            if (argsList.size() == 3) {
                return new StringBuilder(11).append(" substr(").append(this.getColumnName(argsList.get(0).toString())).append(",").append(argsList.get(1).toString()).append(",").append(argsList.get(2).toString()).append(")").toString();
            }
            return "";
        }
        if (fName.toUpperCase().trim().equals("STRENDS")) {
            new StringBuilder(9).append(this.getColumnName(argsList.get(0).toString())).append(" like '%").append(argsList.get(1).toString().replace("\"", "")).append("'").toString();
            return "";
        }
        if (fName.toUpperCase().trim().equals("CONTAINS")) {
            return new StringBuilder(10).append(this.getColumnName(argsList.get(0).toString())).append(" like '%").append(argsList.get(1).toString().replace("\"", "")).append("%'").toString();
        }
        if (fName.toUpperCase().trim().equals("RAND")) {
            return " rand() ";
        }
        if (fName.toUpperCase().trim().equals("IN")) {
            return "";
        }
        if (fName.toUpperCase().trim().equals("NOT IN")) {
            return "";
        }
        if (fName.toUpperCase().trim().equals("STRBEFORE")) {
            return new StringBuilder(26).append(" substr(").append(this.getColumnName(argsList.get(0).toString())).append(",0, instr(").append(this.getColumnName(argsList.get(0).toString())).append(",'").append(argsList.get(1).toString().replace("\"", "")).append("')-1) ").toString();
        }
        if (fName.toUpperCase().trim().equals("STRAFTER")) {
            return new StringBuilder(34).append(" substr(").append(this.getColumnName(argsList.get(0).toString())).append(",instr(").append(this.getColumnName(argsList.get(0).toString())).append(",'").append(argsList.get(1).toString().replace("\"", "")).append("') + length('").append(argsList.get(1).toString().replace("\"", "")).append("')) ").toString();
        }
        if (fName.toUpperCase().trim().equals("REPLACE")) {
            return new StringBuilder(16).append(" replace(").append(this.getColumnName(argsList.get(0).toString())).append(",'").append(argsList.get(1).toString().replace("\"", "")).append("','").append(argsList.get(2).toString().replace("\"", "")).append("')").toString();
        }
        if (fName.toUpperCase().trim().equals("GE")) {
            if (((Expr)argsList.get(0)).isFunction()) {
                return new StringBuilder(4).append(this.createFilterString((Expr)argsList.get(0))).append(" >= ").append(argsList.get(1).toString()).toString();
            }
            return new StringBuilder(4).append(this.getColumnName(argsList.get(0).toString())).append(" >= ").append(argsList.get(1).toString()).toString();
        }
        if (fName.toUpperCase().trim().equals("GT")) {
            if (((Expr)argsList.get(0)).isFunction()) {
                return new StringBuilder(4).append(this.createFilterString((Expr)argsList.get(0))).append(" >= ").append(argsList.get(1).toString()).toString();
            }
            return new StringBuilder(4).append(this.getColumnName(argsList.get(0).toString())).append(" >= ").append(argsList.get(1).toString()).toString();
        }
        if (fName.toUpperCase().trim().equals("LT")) {
            if (((Expr)argsList.get(0)).isFunction()) {
                return new StringBuilder(4).append(this.createFilterString((Expr)argsList.get(0))).append(" <= ").append(argsList.get(1).toString()).toString();
            }
            return new StringBuilder(4).append(this.getColumnName(argsList.get(0).toString())).append(" <= ").append(argsList.get(1).toString()).toString();
        }
        if (fName.toUpperCase().trim().equals("EQ")) {
            if (((Expr)argsList.get(0)).isFunction()) {
                return new StringBuilder(4).append(this.createFilterString((Expr)argsList.get(0))).append(" =  ").append(argsList.get(1).toString()).toString();
            }
            return new StringBuilder(3).append(this.getColumnName(argsList.get(0).toString())).append(" = ").append(argsList.get(1).toString()).toString();
        }
        if (fName.trim().toUpperCase().equals("AND")) {
            return new StringBuilder(5).append(this.createFilterString((Expr)argsList.get(0))).append(" and ").append(this.createFilterString((Expr)argsList.get(1))).toString();
        }
        if (fName.trim().toLowerCase().equals("OR")) {
            return new StringBuilder(4).append(this.createFilterString((Expr)argsList.get(0))).append(" or ").append(this.createFilterString((Expr)argsList.get(1))).toString();
        }
        throw new UnsupportedOperationException(new StringBuilder(25).append("Function not implemented ").append(fName).toString());
    }

    public boolean isCountEnabled() {
        BooleanRef found = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), SparqlOpVisitor$.MODULE$.aggregatorList().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            if (SparqlOpVisitor$.MODULE$.aggregatorList().get(i).getAggregator().getName().equalsIgnoreCase("COUNT")) {
                found$1.elem = true;
                return;
            }
        });
        return found.elem;
    }

    public String getProjectionFields() {
        ObjectRef result = ObjectRef.create((Object)"");
        if (this.isCountEnabled()) {
            result.elem = " count(*) ";
        } else {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), SparqlOpVisitor$.MODULE$.varList().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
                String name = SparqlOpVisitor$.MODULE$.varList().get(i).getVarName();
                if (name.equalsIgnoreCase("S")) {
                    result$1.elem = new StringBuilder(30).append((String)result$1.elem).append("subjects_hdt.name as subject, ").toString();
                    return;
                }
                if (name.equalsIgnoreCase("O")) {
                    result$1.elem = new StringBuilder(28).append((String)result$1.elem).append("objects_hdt.name as object, ").toString();
                    return;
                }
                if (name.equalsIgnoreCase("P")) {
                    result$1.elem = new StringBuilder(34).append((String)result$1.elem).append("predicates_hdt.name as predicate, ").toString();
                    return;
                }
            });
        }
        return (String)new StringOps(Predef$.MODULE$.augmentString(((String)new StringOps(Predef$.MODULE$.augmentString((String)result.elem)).reverse()).replaceFirst(",", ""))).reverse();
    }

    public String getWhereCondition() {
        ObjectRef tempStr = ObjectRef.create((Object)"");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), SparqlOpVisitor$.MODULE$.whereCondition().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            if (!BoxesRunTime.unboxToBoolean((Object)SparqlOpVisitor$.MODULE$.optional().get(i))) {
                if (!SparqlOpVisitor$.MODULE$.subjects().get(i).toString().toLowerCase().contains("?s")) {
                    tempStr$1.elem = new StringBuilder(25).append((String)tempStr$1.elem).append(" subjects_hdt.name='").append(SparqlOpVisitor$.MODULE$.subjects().get(i)).append("' and").toString();
                }
                if (!SparqlOpVisitor$.MODULE$.objects().get(i).toString().toLowerCase().contains("?o")) {
                    tempStr$1.elem = new StringBuilder(24).append((String)tempStr$1.elem).append(" objects_hdt.name='").append(SparqlOpVisitor$.MODULE$.objects().get(i)).append("' and").toString();
                }
                if (!SparqlOpVisitor$.MODULE$.predicates().get(i).toString().toLowerCase().contains("?p")) {
                    tempStr$1.elem = new StringBuilder(27).append((String)tempStr$1.elem).append(" predicates_hdt.name='").append(SparqlOpVisitor$.MODULE$.predicates().get(i)).append("' and").toString();
                    return;
                }
                return;
            }
        });
        tempStr.elem = (String)new StringOps(Predef$.MODULE$.augmentString(((String)new StringOps(Predef$.MODULE$.augmentString((String)tempStr.elem)).reverse()).replaceFirst("dna", ""))).reverse();
        if (SparqlOpVisitor$.MODULE$.optional().contains(BoxesRunTime.boxToBoolean((boolean)true))) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), SparqlOpVisitor$.MODULE$.whereCondition().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
                if (BoxesRunTime.unboxToBoolean((Object)SparqlOpVisitor$.MODULE$.optional().get(i))) {
                    tempStr$1.elem = new StringBuilder(6).append((String)tempStr$1.elem).append(" or ( ").toString();
                    if (!SparqlOpVisitor$.MODULE$.subjects().get(i).toString().toLowerCase().contains("?s")) {
                        tempStr$1.elem = new StringBuilder(25).append((String)tempStr$1.elem).append(" subjects_hdt.name='").append(SparqlOpVisitor$.MODULE$.subjects().get(i)).append("' and").toString();
                    }
                    if (!SparqlOpVisitor$.MODULE$.objects().get(i).toString().toLowerCase().contains("?o")) {
                        tempStr$1.elem = new StringBuilder(24).append((String)tempStr$1.elem).append(" objects_hdt.name='").append(SparqlOpVisitor$.MODULE$.objects().get(i)).append("' and").toString();
                    }
                    if (!SparqlOpVisitor$.MODULE$.predicates().get(i).toString().toLowerCase().contains("?p")) {
                        tempStr$1.elem = new StringBuilder(27).append((String)tempStr$1.elem).append(" predicates_hdt.name='").append(SparqlOpVisitor$.MODULE$.predicates().get(i)).append("' and").toString();
                    }
                    tempStr$1.elem = (String)new StringOps(Predef$.MODULE$.augmentString(((String)new StringOps(Predef$.MODULE$.augmentString((String)tempStr$1.elem)).reverse()).replaceFirst("dna", ""))).reverse();
                    tempStr$1.elem = new StringBuilder(2).append((String)tempStr$1.elem).append(" )").toString();
                    return;
                }
            });
        }
        if (((String)tempStr.elem).length() > 5) {
            return new StringBuilder(9).append(" where (").append((String)tempStr.elem).append(")").toString();
        }
        return " where 1=1 ";
    }

    public String getDistinct() {
        if (SparqlOpVisitor$.MODULE$.isDistinctEnabled()) {
            ObjectRef groupBy = ObjectRef.create((Object)"");
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), SparqlOpVisitor$.MODULE$.varList().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
                if (SparqlOpVisitor$.MODULE$.subjects().contains(SparqlOpVisitor$.MODULE$.varList().get(i))) {
                    groupBy$1.elem = new StringBuilder(19).append((String)groupBy$1.elem).append("subjects_hdt.name, ").toString();
                    return;
                }
                if (SparqlOpVisitor$.MODULE$.objects().contains(SparqlOpVisitor$.MODULE$.varList().get(i))) {
                    groupBy$1.elem = new StringBuilder(18).append((String)groupBy$1.elem).append("objects_hdt.name, ").toString();
                    return;
                }
                if (SparqlOpVisitor$.MODULE$.predicates().contains(SparqlOpVisitor$.MODULE$.varList().get(i))) {
                    groupBy$1.elem = new StringBuilder(21).append((String)groupBy$1.elem).append("predicates_hdt.name, ").toString();
                    return;
                }
            });
            return new StringBuilder(9).append("group by ").append(new StringOps(Predef$.MODULE$.augmentString(((String)new StringOps(Predef$.MODULE$.augmentString((String)groupBy.elem)).reverse()).replaceFirst(",", ""))).reverse()).toString();
        }
        return "";
    }

    public String getFilterCondition() {
        ObjectRef strCondition = ObjectRef.create((Object)"");
        String logicalOp = "";
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), SparqlOpVisitor$.MODULE$.filters().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            String cond = MODULE$.filterHDT(SparqlOpVisitor$.MODULE$.filters().get(i));
            if (cond.length() > 2) {
                strCondition$1.elem = new StringBuilder(5).append((String)strCondition$1.elem).append(cond).append(" and ").toString();
                return;
            }
        });
        strCondition.elem = (String)new StringOps(Predef$.MODULE$.augmentString(((String)new StringOps(Predef$.MODULE$.augmentString((String)strCondition.elem)).reverse()).replaceFirst("dna", ""))).reverse();
        if (((String)strCondition.elem).length() > 5) {
            return new StringBuilder(1).append(" ").append((String)strCondition.elem).toString();
        }
        return " 1=1";
    }

    public String getQuery(String queryStr) {
        SparqlOpVisitor$.MODULE$.reset();
        Query query = QueryFactory.create((String)queryStr);
        Op op = Algebra.compile((Query)query);
        OpWalker.walk((Op)op, (OpVisitor)SparqlOpVisitor$.MODULE$);
        String sql = new StringBuilder(180).append("select ").append(this.getProjectionFields()).append("from hdt inner join subjects_hdt on hdt.s=subjects_hdt.index").append(" inner join objects_hdt on hdt.o=objects_hdt.index").append(" inner join predicates_hdt on hdt.p=predicates_hdt.index").append(" ").append(this.getWhereCondition()).append(" and ").append(this.getFilterCondition()).append(" ").append(this.getDistinct()).toString();
        return sql;
    }

    private Sparql2SQL$() {
        MODULE$ = this;
    }
}

