/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.ontop;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import net.sansa_stack.query.spark.ontop.JDBCDatabaseGenerator$;
import net.sansa_stack.rdf.common.partition.core.RdfPartitionStateDefault;
import net.sansa_stack.rdf.common.partition.core.RdfPartitioner;
import net.sansa_stack.rdf.common.partition.utils.SQLUtils$;
import net.sansa_stack.rdf.spark.partition.core.BlankNodeStrategy$;
import org.aksw.sparqlify.core.sql.common.serialization.SqlEscaperDoubleQuote;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class JDBCDatabaseGenerator$ {
    public static JDBCDatabaseGenerator$ MODULE$;
    private final Logger logger;
    private final SqlEscaperDoubleQuote sqlEscaper;
    private final Map<Types.TypeApi, String> partitionType2DatabaseType;
    private final Map<String, String> spark2H2DatatypeMapping;

    static {
        new JDBCDatabaseGenerator$();
    }

    public Logger logger() {
        return this.logger;
    }

    public SqlEscaperDoubleQuote sqlEscaper() {
        return this.sqlEscaper;
    }

    private Map<Types.TypeApi, String> partitionType2DatabaseType() {
        return this.partitionType2DatabaseType;
    }

    private Map<String, String> spark2H2DatatypeMapping() {
        return this.spark2H2DatatypeMapping;
    }

    public String generateJdbcCommand(Map<String, String> jdbcMetaData) {
        return ((TraversableOnce)jdbcMetaData.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String tableName = (String)tuple2._1();
                String ddl = (String)tuple2._2();
                ObjectRef ddlH2 = ObjectRef.create((Object)ddl);
                MODULE$.spark2H2DatatypeMapping().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    JDBCDatabaseGenerator$.$anonfun$generateJdbcCommand$2(ddlH2, x0$2);
                    return BoxedUnit.UNIT;
                });
                ddlH2.elem = ((String)ddlH2.elem).replace("`", "\"");
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(62).append("\n         |CREATE TABLE IF NOT EXISTS ").append(MODULE$.sqlEscaper().escapeColumnName(tableName)).append("\n         |(").append((String)ddlH2.elem).append(")\n         |").toString())).stripMargin();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).mkString(";");
    }

    public void generateTables(Connection connection, Map<String, String> jdbcMetaData) {
        block3: {
            String s = this.generateJdbcCommand(jdbcMetaData);
            try {
                Statement stmt = connection.createStatement();
                stmt.executeUpdate(s);
                connection.commit();
            }
            catch (SQLException e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Error occurred when creating in-memory H2 database", (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void generateTables(Connection connection, RdfPartitioner<RdfPartitionStateDefault> partitioner, Set<RdfPartitionStateDefault> partitions, Enumeration.Value blankNodeStrategy) {
        BoxedUnit boxedUnit;
        try {
            Statement stmt = connection.createStatement();
            stmt.executeUpdate("DROP ALL OBJECTS");
            partitions.foreach((Function1 & Serializable & scala.Serializable)p -> {
                JDBCDatabaseGenerator$.$anonfun$generateTables$1(partitioner, stmt, p);
                return BoxedUnit.UNIT;
            });
            int numTables = stmt.executeBatch().length;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("created {} tables", new Object[]{BoxesRunTime.boxToInteger((int)numTables)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        catch (SQLException e) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Error occurred when creating in-memory H2 database", (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        connection.commit();
    }

    public Enumeration.Value generateTables$default$4() {
        return BlankNodeStrategy$.MODULE$.Table();
    }

    public static final /* synthetic */ void $anonfun$generateJdbcCommand$2(ObjectRef ddlH2$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String from = (String)tuple2._1();
            String to = (String)tuple2._2();
            ddlH2$1.elem = ((String)ddlH2$1.elem).replace(from, to);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$generateTables$1(RdfPartitioner partitioner$1, Statement stmt$1, RdfPartitionStateDefault p) {
        BoxedUnit boxedUnit;
        String name = SQLUtils$.MODULE$.createDefaultTableName(p);
        Types.TypeApi schema = partitioner$1.determineLayout((Object)p).schema();
        StructType sparkSchema = (StructType)ScalaReflection$.MODULE$.schemaFor(schema).dataType();
        if (MODULE$.logger().underlying().isTraceEnabled()) {
            MODULE$.logger().underlying().trace("creating table for property {} with Spark schema {} and layout {}", new Object[]{p.predicate(), sparkSchema, schema});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RdfPartitionStateDefault rdfPartitionStateDefault = p;
        if (rdfPartitionStateDefault != null) {
            BoxedUnit boxedUnit2;
            String string;
            byte objectType;
            String predicate = rdfPartitionStateDefault.predicate();
            byte by = objectType = rdfPartitionStateDefault.objectType();
            switch (by) {
                case 0: 
                case 1: {
                    string = new StringBuilder(77).append("CREATE TABLE IF NOT EXISTS ").append(MODULE$.sqlEscaper().escapeTableName(name)).append(" (").append("s varchar(255) NOT NULL,").append("o varchar(255) NOT NULL").append(")").toString();
                    break;
                }
                case 2: {
                    BoxedUnit boxedUnit3;
                    Types.TypeApi typeApi = schema;
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
                    public final class Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator1$2
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("net.sansa_stack.rdf.common.partition.schema.SchemaStringStringLang").asType().toTypeConstructor();
                        }

                        public Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator1$2() {
                        }
                    }
                    Types.TypeApi typeApi2 = ((TypeTags)package$.MODULE$.universe()).typeOf(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator1$2()));
                    if (!(typeApi != null ? !typeApi.equals(typeApi2) : typeApi2 != null)) {
                        string = new StringBuilder(91).append("CREATE TABLE IF NOT EXISTS ").append(MODULE$.sqlEscaper().escapeTableName(name)).append(" (").append("s varchar(255) NOT NULL,").append("o varchar(255) NOT NULL,").append("l varchar(10)").append(")").toString();
                        break;
                    }
                    Types.TypeApi typeApi3 = schema;
                    JavaUniverse $u2 = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
                    public final class Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator2$2
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("net.sansa_stack.rdf.common.partition.schema.SchemaStringStringType").asType().toTypeConstructor();
                        }

                        public Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator2$2() {
                        }
                    }
                    Types.TypeApi typeApi4 = ((TypeTags)package$.MODULE$.universe()).typeOf(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator2$2()));
                    if (!(typeApi3 != null ? !typeApi3.equals(typeApi4) : typeApi4 != null)) {
                        string = new StringBuilder(101).append("CREATE TABLE IF NOT EXISTS ").append(MODULE$.sqlEscaper().escapeTableName(name)).append(" (").append("s varchar(255) NOT NULL,").append("o varchar(255) NOT NULL,").append("t varchar(255) NOT NULL").append(")").toString();
                        break;
                    }
                    Option colType = MODULE$.partitionType2DatabaseType().get((Object)schema);
                    if (colType.isDefined()) {
                        string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(165).append("\n                       |CREATE TABLE IF NOT EXISTS ").append(MODULE$.sqlEscaper().escapeTableName(name)).append(" (\n                       |s varchar(255) NOT NULL,\n                       |o ").append(colType.get()).append(" NOT NULL)\n                       |").toString())).stripMargin();
                        break;
                    }
                    if (MODULE$.logger().underlying().isErrorEnabled()) {
                        MODULE$.logger().underlying().error("Error: couldn't create H2 table for property {} with schema {}", new Object[]{predicate, schema});
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    string = "";
                    break;
                }
                default: {
                    BoxedUnit boxedUnit4;
                    if (MODULE$.logger().underlying().isErrorEnabled()) {
                        MODULE$.logger().underlying().error("TODO: bnode H2 SQL table for Ontop mappings");
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    string = "";
                    break;
                }
            }
            String s = string;
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug(s);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            stmt$1.addBatch(s);
            return;
        }
        if (MODULE$.logger().underlying().isErrorEnabled()) {
            MODULE$.logger().underlying().error("wrong partition type: {}", new Object[]{p});
            return;
        }
    }

    private JDBCDatabaseGenerator$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(this.getClass());
        this.sqlEscaper = new SqlEscaperDoubleQuote();
        Tuple2[] tuple2Array = new Tuple2[8];
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("net.sansa_stack.rdf.common.partition.schema.SchemaStringLong").asType().toTypeConstructor();
            }

            public Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator1$1() {
            }
        }
        tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((TypeTags)package$.MODULE$.universe()).typeOf(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator1$1()))), (Object)"LONG");
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("net.sansa_stack.rdf.common.partition.schema.SchemaStringDouble").asType().toTypeConstructor();
            }

            public Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator2$1() {
            }
        }
        tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((TypeTags)package$.MODULE$.universe()).typeOf(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator2$1()))), (Object)"DOUBLE");
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("net.sansa_stack.rdf.common.partition.schema.SchemaStringFloat").asType().toTypeConstructor();
            }

            public Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator3$1() {
            }
        }
        tuple2Array[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((TypeTags)package$.MODULE$.universe()).typeOf(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator3$1()))), (Object)"FLOAT");
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("net.sansa_stack.rdf.common.partition.schema.SchemaStringDecimal").asType().toTypeConstructor();
            }

            public Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator4$1() {
            }
        }
        tuple2Array[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((TypeTags)package$.MODULE$.universe()).typeOf(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator4$1()))), (Object)"DECIMAL");
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("net.sansa_stack.rdf.common.partition.schema.SchemaStringBoolean").asType().toTypeConstructor();
            }

            public Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator5$1() {
            }
        }
        tuple2Array[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((TypeTags)package$.MODULE$.universe()).typeOf(((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator5$1()))), (Object)"BOOLEAN");
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("net.sansa_stack.rdf.common.partition.schema.SchemaStringString").asType().toTypeConstructor();
            }

            public Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator6$1() {
            }
        }
        tuple2Array[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((TypeTags)package$.MODULE$.universe()).typeOf(((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator6$1()))), (Object)"VARCHAR(255)");
        JavaUniverse $u7 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m7 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator7$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("net.sansa_stack.rdf.common.partition.schema.SchemaStringDate").asType().toTypeConstructor();
            }

            public Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator7$1() {
            }
        }
        tuple2Array[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((TypeTags)package$.MODULE$.universe()).typeOf(((TypeTags)$u7).TypeTag().apply((Mirror)$m7, (TypeCreator)new Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator7$1()))), (Object)"DATE");
        JavaUniverse $u8 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m8 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator8$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("net.sansa_stack.rdf.common.partition.schema.SchemaStringTimestamp").asType().toTypeConstructor();
            }

            public Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator8$1() {
            }
        }
        tuple2Array[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((TypeTags)package$.MODULE$.universe()).typeOf(((TypeTags)$u8).TypeTag().apply((Mirror)$m8, (TypeCreator)new Net_sansa_stack_query_spark_ontop_JDBCDatabaseGenerator$$typecreator8$1()))), (Object)"TIMESTAMP");
        this.partitionType2DatabaseType = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.spark2H2DatatypeMapping = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"STRING"), (Object)"VARCHAR")}));
    }
}

