/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.ontop;

import com.github.owlcs.ontapi.OntManagers;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import net.sansa_stack.rdf.common.partition.r2rml.R2rmlUtils$;
import net.sansa_stack.rdf.common.partition.utils.SQLUtils$;
import net.sansa_stack.rdf.common.partition.utils.TableIdentifier;
import net.sansa_stack.rdf.spark.utils.ScalaUtils$;
import org.aksw.r2rml.jena.domain.api.ObjectMapType;
import org.aksw.r2rml.jena.domain.api.PredicateObjectMap;
import org.aksw.r2rml.jena.domain.api.TriplesMap;
import org.aksw.r2rml.jena.vocab.RR;
import org.aksw.sparqlify.core.sql.common.serialization.SqlEscaperBacktick;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class OntologyExtractor$ {
    public static OntologyExtractor$ MODULE$;
    private final Logger logger;
    private final SqlEscaperBacktick sqlEscaper;

    static {
        new OntologyExtractor$();
    }

    public Logger logger() {
        return this.logger;
    }

    public SqlEscaperBacktick sqlEscaper() {
        return this.sqlEscaper;
    }

    public Option<OWLOntology> extract(SparkSession spark, Model mappingsModel) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("extracting ontology from dataset");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Iterator tms = R2rmlUtils$.MODULE$.triplesMapsForPredicate(RDF.type, mappingsModel).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)OntologyExtractor$.$anonfun$extract$1(mappingsModel, x$1)));
        String clsCol = this.sqlEscaper().escapeAliasName("cls");
        String sql = tms.map((Function1 & Serializable & scala.Serializable)tm -> {
            String tableName = tm.getLogicalTable().asBaseTableOrView().getTableName();
            String o = ((ObjectMapType)((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(((PredicateObjectMap)((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(tm.getPredicateObjectMaps()).asScala()).head()).getObjectMaps()).asScala()).head()).asTermMap().getColumn();
            TableIdentifier tn = SQLUtils$.MODULE$.parseTableIdentifier(tableName);
            String to = MODULE$.sqlEscaper().escapeColumnName(ScalaUtils$.MODULE$.unQuote(o, ScalaUtils$.MODULE$.unQuote$default$2()));
            return new StringBuilder(26).append("SELECT DISTINCT ").append(to).append(" AS ").append(clsCol).append(" FROM ").append(tn).toString();
        }).mkString(" UNION ");
        if (new StringOps(Predef$.MODULE$.augmentString(sql)).nonEmpty()) {
            BoxedUnit boxedUnit2;
            Predef$.MODULE$.println((Object)new StringBuilder(23).append("class retrieval query:\n").append(sql).toString());
            Dataset df = spark.sql(sql);
            String[] classes = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            OWLDataFactory dataFactory = OWLManager.getOWLDataFactory();
            Set axioms = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classes)).map((Function1 & Serializable & scala.Serializable)cls -> dataFactory.getOWLDeclarationAxiom((OWLEntity)dataFactory.getOWLClass(IRI.create((String)cls))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OWLDeclarationAxiom.class))))).toSet();
            OWLOntology ontology = this.createOntology((Set<OWLAxiom>)axioms);
            ontology.saveOntology((OWLDocumentFormat)new RDFXMLDocumentFormat(), (OutputStream)new FileOutputStream(new File("/tmp/ontop-ontology.rdf")));
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("ontology contains {} classes and {} logical axioms.", new Object[]{BoxesRunTime.boxToInteger((int)classes.length), BoxesRunTime.boxToInteger((int)ontology.getLogicalAxiomCount())});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return new Some((Object)ontology);
        }
        return None$.MODULE$;
    }

    private OWLOntology createOntology(Set<OWLAxiom> axioms) {
        OWLOntologyManager man = new OntManagers.OWLAPIImplProfile().createManager(false);
        return man.createOntology((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter(axioms).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$extract$3(Model mappingsModel$1, ObjectMapType x$3) {
        Resource resource = x$3.asTermMap().getTermType();
        Resource resource2 = RR.IRI.inModel(mappingsModel$1);
        return !(resource != null ? !resource.equals(resource2) : resource2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$extract$2(Model mappingsModel$1, PredicateObjectMap x$2) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(x$2.getObjectMaps()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)OntologyExtractor$.$anonfun$extract$3(mappingsModel$1, x$3)));
    }

    public static final /* synthetic */ boolean $anonfun$extract$1(Model mappingsModel$1, TriplesMap x$1) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(x$1.getPredicateObjectMaps()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)OntologyExtractor$.$anonfun$extract$2(mappingsModel$1, x$2)));
    }

    private OntologyExtractor$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(this.getClass());
        this.sqlEscaper = new SqlEscaperBacktick();
    }
}

