/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.ontop;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import it.unibz.inf.ontop.answering.connection.OntopConnection;
import it.unibz.inf.ontop.injection.OntopReformulationSQLConfiguration;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import net.sansa_stack.query.spark.ontop.Cache;
import net.sansa_stack.query.spark.ontop.Cache$;
import net.sansa_stack.query.spark.ontop.JDBCDatabaseGenerator$;
import net.sansa_stack.query.spark.ontop.OntopUtils$;
import net.sansa_stack.rdf.spark.utils.ScalaUtils$;
import org.apache.jena.rdf.model.Model;
import org.semanticweb.owlapi.model.OWLOntology;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

public final class OntopConnection$ {
    public static OntopConnection$ MODULE$;
    private final Logger logger;
    private final String DEFAULT_DATABASE;
    private final String JDBC_USER;
    private final String JDBC_PASSWORD;
    private Map<String, Connection> connections;
    private final Cache<String, OntopReformulationSQLConfiguration> configs;

    static {
        new OntopConnection$();
    }

    public Logger logger() {
        return this.logger;
    }

    public String DEFAULT_DATABASE() {
        return this.DEFAULT_DATABASE;
    }

    public String JDBC_USER() {
        return this.JDBC_USER;
    }

    public String JDBC_PASSWORD() {
        return this.JDBC_PASSWORD;
    }

    public Map<String, Connection> connections() {
        return this.connections;
    }

    public void connections_$eq(Map<String, Connection> x$1) {
        this.connections = x$1;
    }

    public Connection getOrCreateConnection(Option<String> database) {
        String db = (String)database.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_DATABASE());
        return (Connection)this.connections().getOrElse((Object)db, (Function0 & Serializable & scala.Serializable)() -> {
            Connection connection = (Connection)ScalaUtils$.MODULE$.time("creating DB connection ...", "Created DB connection", MODULE$.logger(), (Function0 & Serializable & scala.Serializable)() -> {
                Connection conn = DriverManager.getConnection(MODULE$.getConnectionURL(database), MODULE$.JDBC_USER(), MODULE$.JDBC_PASSWORD());
                MODULE$.connections_$eq((Map<String, Connection>)MODULE$.connections().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)db), (Object)conn)));
                package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> conn.close());
                return conn;
            });
            return connection;
        });
    }

    public String getConnectionURL(Option<String> database) {
        String url;
        block0: {
            url = "jdbc:h2:mem:ontop_sansa_db;DATABASE_TO_UPPER=FALSE;";
            if (!database.isDefined()) break block0;
            url = new StringBuilder(46).append(url).append("INIT=CREATE SCHEMA IF NOT EXISTS ").append(database.get()).append("\\;SET SCHEMA ").append(database.get()).toString();
        }
        return url;
    }

    public Option<String> getConnectionURL$default$1() {
        return None$.MODULE$;
    }

    public Cache<String, OntopReformulationSQLConfiguration> configs() {
        return this.configs;
    }

    public OntopReformulationSQLConfiguration apply(String id, Option<String> database, Model obdaMappings, Properties properties, Map<String, String> jdbcMetaData, Option<OWLOntology> ontology) {
        OntopReformulationSQLConfiguration conf = this.configs().getOrElseUpdate(id, (Function0<OntopReformulationSQLConfiguration>)(Function0 & Serializable & scala.Serializable)() -> {
            OntopReformulationSQLConfiguration reformulationConfiguration = (OntopReformulationSQLConfiguration)ScalaUtils$.MODULE$.time(new StringBuilder(45).append("creating reformulation config for session ").append(id).append("...").toString(), new StringBuilder(41).append("created reformulation config for session ").append(id).toString(), MODULE$.logger(), (Function0 & Serializable & scala.Serializable)() -> {
                Connection conn = MODULE$.getOrCreateConnection(database);
                JDBCDatabaseGenerator$.MODULE$.generateTables(conn, jdbcMetaData);
                return OntopUtils$.MODULE$.createReformulationConfig(database, obdaMappings, properties, ontology);
            });
            return reformulationConfiguration;
        });
        return conf;
    }

    public OntopReformulationSQLConfiguration apply(String id, String dbMetadata, Model obdaMappings, Properties properties, Option<OWLOntology> ontology) {
        OntopReformulationSQLConfiguration conf = this.configs().getOrElseUpdate(id, (Function0<OntopReformulationSQLConfiguration>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("creating reformulation config for session {}...", new Object[]{id});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            OntopReformulationSQLConfiguration reformulationConfiguration = (OntopReformulationSQLConfiguration)ScalaUtils$.MODULE$.time(new StringBuilder(45).append("creating reformulation config for session ").append(id).append("...").toString(), "created reformulation config for session $id", (Function0 & Serializable & scala.Serializable)() -> OntopUtils$.MODULE$.createReformulationConfig(dbMetadata, obdaMappings, properties, ontology));
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("...done");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return reformulationConfiguration;
        });
        return conf;
    }

    public void clear() {
        this.configs().clear();
        this.connections().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            OntopConnection$.$anonfun$clear$1(x0$1);
            return BoxedUnit.UNIT;
        });
        this.connections_$eq((Map<String, Connection>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
    }

    public static final /* synthetic */ void $anonfun$clear$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Connection conn = (Connection)tuple2._2();
            conn.close();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private OntopConnection$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(OntopConnection.class);
        this.DEFAULT_DATABASE = "default";
        this.JDBC_USER = "sa";
        this.JDBC_PASSWORD = "";
        Class.forName("org.h2.Driver");
        this.connections = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.configs = new Cache(Cache$.MODULE$.$lessinit$greater$default$1(), Cache$.MODULE$.$lessinit$greater$default$2());
    }
}

