/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.ontop;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import net.sansa_stack.rdf.common.partition.core.RdfPartitionStateDefault;
import net.sansa_stack.rdf.common.partition.utils.SQLUtils$;
import net.sansa_stack.rdf.spark.partition.core.BlankNodeStrategy$;
import org.aksw.sparqlify.core.sql.common.serialization.SqlEscaperDoubleQuote;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSignature;
import org.semanticweb.owlapi.model.parameters.Imports;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;

public final class OntopMappingGenerator$ {
    public static OntopMappingGenerator$ MODULE$;
    private final Logger logger;
    private final SqlEscaperDoubleQuote sqlEscaper;
    private final Enumeration.Value blankNodeStrategy;
    private final boolean distinguishStringLiterals;

    static {
        new OntopMappingGenerator$();
    }

    public Logger logger() {
        return this.logger;
    }

    public SqlEscaperDoubleQuote sqlEscaper() {
        return this.sqlEscaper;
    }

    public Enumeration.Value blankNodeStrategy() {
        return this.blankNodeStrategy;
    }

    public boolean distinguishStringLiterals() {
        return this.distinguishStringLiterals;
    }

    public String createOBDAMappingsForPartitions(Set<RdfPartitionStateDefault> partitions, Option<OWLOntology> ontology) {
        String triplesMapping = new StringOps(Predef$.MODULE$.augmentString("\n         |mappingId     triples\n         |source        SELECT `s`, `p`, `o` FROM `triples`\n         |target        <{s}> <http://sansa.net/ontology/triples> \"{o}\" .\n         |")).stripMargin();
        return new StringBuilder(38).append("[MappingDeclaration] @collection [[").append(((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            RdfPartitionStateDefault rdfPartitionStateDefault = x0$1;
            if (rdfPartitionStateDefault == null) throw new MatchError((Object)rdfPartitionStateDefault);
            String predicate = rdfPartitionStateDefault.predicate();
            byte objectType = rdfPartitionStateDefault.objectType();
            String datatype = rdfPartitionStateDefault.datatype();
            boolean langTagPresent = rdfPartitionStateDefault.langTagPresent();
            String tableName = SQLUtils$.MODULE$.createDefaultTableName(rdfPartitionStateDefault);
            String id = MODULE$.sqlEscaper().escapeTableName(tableName);
            String string = predicate;
            String string2 = RDF.type.getURI();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (!ontology.nonEmpty()) return "";
                return ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(((OWLSignature)ontology.get()).getClassesInSignature(Imports.EXCLUDED)).asScala()).map((Function1 & Serializable & scala.Serializable)cls -> this.createClassMapping$1(id, tableName, rdfPartitionStateDefault, cls.toStringID()), Set$.MODULE$.canBuildFrom())).mkString("\n");
            }
            byte by = objectType;
            switch (by) {
                case 0: 
                case 1: {
                    return this.createMapping$1(id, tableName, rdfPartitionStateDefault);
                }
                case 2: {
                    if (MODULE$.distinguishStringLiterals()) {
                        if (!langTagPresent) return this.createMappingLit$1(id, tableName, rdfPartitionStateDefault);
                        return this.createMappingStringLit$1(id, tableName, rdfPartitionStateDefault);
                    }
                    if (langTagPresent) return this.createMappingStringLit$1(id, tableName, rdfPartitionStateDefault);
                    String string3 = datatype;
                    String string4 = XSD.xstring.getURI();
                    if (string3 != null ? !string3.equals(string4) : string4 != null) return this.createMappingLit$1(id, tableName, rdfPartitionStateDefault);
                    return this.createMappingStringLit$1(id, tableName, rdfPartitionStateDefault);
                }
            }
            if (MODULE$.logger().underlying().isErrorEnabled()) {
                MODULE$.logger().underlying().error("TODO: bnode Ontop mapping creation");
                boxedUnit = BoxedUnit.UNIT;
                return "";
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return "";
        }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())).mkString("\n\n")).append("\n]]").toString();
    }

    public Option<OWLOntology> createOBDAMappingsForPartitions$default$2() {
        return None$.MODULE$;
    }

    private final String createMapping$1(String id, String tableName, RdfPartitionStateDefault partition) {
        String targetSubject = partition.subjectType() == 0 ? "_:{s}" : "<{s}>";
        String targetObject = partition.objectType() == 0 ? "_:{o}" : "<{o}>";
        Enumeration.Value value = this.blankNodeStrategy();
        Enumeration.Value value2 = BlankNodeStrategy$.MODULE$.Table();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(121).append("\n           |mappingId     ").append(id).append("\n           |source        SELECT \"s\", \"o\" FROM ").append(this.sqlEscaper().escapeTableName(tableName)).append("\n           |target        ").append(targetSubject).append(" <").append(partition.predicate()).append("> ").append(targetObject).append(" .\n           |").toString())).stripMargin();
        }
        Enumeration.Value value3 = this.blankNodeStrategy();
        Enumeration.Value value4 = BlankNodeStrategy$.MODULE$.Column();
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            String whereCondition = new StringBuilder(21).append((Object)(partition.subjectType() == 1 ? "NOT" : "")).append(" s_blank AND").append(" ").append((Object)(partition.objectType() == 1 ? "NOT" : "")).append(" o_blank").toString();
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(128).append("\n           |mappingId     ").append(id).append("\n           |source        SELECT \"s\", \"o\" FROM ").append(this.sqlEscaper().escapeTableName(tableName)).append(" WHERE ").append(whereCondition).append("\n           |target        ").append(targetSubject).append(" <").append(partition.predicate()).append("> ").append(targetObject).append(" .\n           |").toString())).stripMargin();
        }
        throw new RuntimeException(new StringBuilder(32).append("Unsupported Blank Node Strategy:").append(this.blankNodeStrategy()).toString());
    }

    private final String createMappingStringLit$1(String id, String tableName, RdfPartitionStateDefault partition) {
        String targetSubject;
        Set languages = partition.languages();
        String string = targetSubject = partition.subjectType() == 0 ? "_:{s}" : "<{s}>";
        if (languages.isEmpty()) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(141).append("\n           |mappingId     ").append(id).append("\n           |source        SELECT \"s\", \"o\" FROM ").append(this.sqlEscaper().escapeTableName(tableName)).append(" WHERE \"l\" = ''\n           |target        ").append(targetSubject).append(" <").append(partition.predicate()).append("> \"{o}\" .\n           |").toString())).stripMargin();
        }
        return ((TraversableOnce)languages.map((Function1 & Serializable & scala.Serializable)lang -> {
            String id = new StringBuilder(5).append(tableName).append("_lang").toString();
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("\n             |mappingId     ").append(id).append("\n             |source        SELECT \"s\", \"o\" FROM ").append(MODULE$.sqlEscaper().escapeTableName(tableName)).append(" WHERE \"l\" = '").append((String)lang).append("'\n             |target        ").append(targetSubject).append(" <").append(partition.predicate()).append("> \"{o}\"@").append((String)lang).append(" .\n             |").toString())).stripMargin();
        }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private final String createMappingLit$1(String id, String tableName, RdfPartitionStateDefault partition) {
        String targetSubject = partition.subjectType() == 0 ? "_:{s}" : "<{s}>";
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(122).append("\n         |mappingId     ").append(id).append("\n         |source        SELECT \"s\", \"o\" FROM ").append(this.sqlEscaper().escapeTableName(tableName)).append("\n         |target        ").append(targetSubject).append(" <").append(partition.predicate()).append("> \"{o}\"^^<").append(partition.datatype()).append("> .\n         |").toString())).stripMargin();
    }

    private final String createClassMapping$1(String id, String tableName, RdfPartitionStateDefault partition, String cls) {
        String targetSubject = partition.subjectType() == 0 ? "_:{s}" : "<{s}>";
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(130).append("\n         |mappingId     ").append(id).append("\n         |source        SELECT \"s\", \"o\" FROM ").append(this.sqlEscaper().escapeTableName(tableName)).append(" WHERE \"o\" = '").append(cls).append("'\n         |target        ").append(targetSubject).append(" <").append(RDF.type.getURI()).append("> <").append(cls).append("> .\n         |").toString())).stripMargin();
    }

    private final String createMappingLiteralWithType$1(String id, String tableName, String property) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("\n         |mappingId     ").append(id).append("\n         |source        SELECT \"s\", \"o\", \"t\" FROM ").append(this.sqlEscaper().escapeTableName(tableName)).append("\n         |target        <{s}> <").append(property).append("> \"{o}\"^^<{t}> .\n         |").toString())).stripMargin();
    }

    private OntopMappingGenerator$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(this.getClass());
        this.sqlEscaper = new SqlEscaperDoubleQuote();
        this.blankNodeStrategy = BlankNodeStrategy$.MODULE$.Table();
        this.distinguishStringLiterals = false;
    }
}

