/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.ontop;

import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllConfiguration;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopMappingSQLConfiguration;
import it.unibz.inf.ontop.injection.OntopOBDAConfiguration;
import it.unibz.inf.ontop.injection.OntopReformulationSQLConfiguration;
import it.unibz.inf.ontop.injection.OntopSQLCoreConfiguration;
import it.unibz.inf.ontop.injection.OntopSQLCredentialConfiguration;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.NativeNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.model.term.BNode;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.RDFLiteralConstant;
import it.unibz.inf.ontop.model.type.LanguageTag;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.spec.OBDASpecification;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.text.NumberFormat;
import java.util.Properties;
import net.sansa_stack.query.spark.ontop.InvalidConstantTypeInResultException;
import net.sansa_stack.query.spark.ontop.InvalidTermAsResultException;
import net.sansa_stack.query.spark.ontop.OntopConnection$;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.jena.JenaRDF;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.semanticweb.owlapi.model.OWLOntology;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class OntopUtils$
implements scala.Serializable {
    public static OntopUtils$ MODULE$;
    private final boolean fixScientificNotation;
    private final NumberFormat formatter;

    static {
        new OntopUtils$();
    }

    public boolean fixScientificNotation() {
        return this.fixScientificNotation;
    }

    public NumberFormat formatter() {
        return this.formatter;
    }

    public Node toNode(RDFConstant constant, TypeFactory typeFactory) {
        RDFTermType termType = constant.getType();
        if (termType.isA((TermType)typeFactory.getIRITermType())) {
            return NodeFactory.createURI((String)((IRIConstant)constant).getIRI().getIRIString());
        }
        if (termType.isA((TermType)typeFactory.getAbstractRDFSLiteral())) {
            RDFLiteralConstant lit = (RDFLiteralConstant)constant;
            it.unibz.inf.ontop.model.type.RDFDatatype litType = lit.getType();
            RDFDatatype dt = TypeMapper.getInstance().getTypeByName(litType.getIRI().getIRIString());
            String lexicalForm = lit.getValue();
            if (this.fixScientificNotation()) {
                RDFDatatype rDFDatatype = dt;
                XSDDatatype xSDDatatype = XSDDatatype.XSDdecimal;
                if (!(rDFDatatype != null ? !rDFDatatype.equals(xSDDatatype) : xSDDatatype != null)) {
                    double d = Double.parseDouble(lexicalForm);
                    lexicalForm = this.formatter().format(d);
                }
            }
            String lang = litType.getLanguageTag().isPresent() ? ((LanguageTag)litType.getLanguageTag().get()).getFullString() : null;
            return NodeFactory.createLiteral((String)lexicalForm, (String)lang, (RDFDatatype)dt);
        }
        if (termType.isA((TermType)typeFactory.getBlankNodeType())) {
            return NodeFactory.createBlankNode((String)((BNode)constant).getInternalLabel());
        }
        return null;
    }

    public Option<RDFConstant> evaluate(ImmutableTerm term) {
        ImmutableTerm simplifiedTerm = term.simplify();
        ImmutableTerm immutableTerm = simplifiedTerm;
        if (immutableTerm instanceof Constant) {
            Constant constant = (Constant)immutableTerm;
            if (constant instanceof RDFConstant) {
                return new Some((Object)((RDFConstant)constant));
            }
            if (constant.isNull()) {
                return None$.MODULE$;
            }
            if (constant instanceof DBConstant) {
                throw new InvalidConstantTypeInResultException(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)constant), "is a DB constant. But a binding cannot have a DB constant as value"));
            }
            throw new InvalidConstantTypeInResultException(new StringBuilder(29).append("Unexpected constant type for ").append(constant).toString());
        }
        throw new InvalidTermAsResultException(simplifiedTerm);
    }

    public String extractSQLQuery(IQ executableQuery) throws EmptyQueryException, OntopInternalBugException {
        String queryString;
        IQTree tree = executableQuery.getTree();
        if (tree.isDeclaredAsEmpty()) {
            throw new EmptyQueryException();
        }
        String string = queryString = (String)Option$.MODULE$.apply((Object)tree).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)OntopUtils$.$anonfun$extractSQLQuery$1(t))).map((Function1 & Serializable & scala.Serializable)t -> ((UnaryIQTree)t).getChild().getRootNode()).filter((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)OntopUtils$.$anonfun$extractSQLQuery$3(n))).map((Function1 & Serializable & scala.Serializable)n -> (NativeNode)n).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getNativeQueryString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new MinorOntopInternalBugException(new StringBuilder(70).append("The query does not have the expected structure of an executable query\n").append(executableQuery).toString());
        });
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new EmptyQueryException();
        }
        return queryString;
    }

    public NativeNode extractNativeNode(IQ executableQuery) throws EmptyQueryException {
        IQTree tree = executableQuery.getTree();
        if (tree.isDeclaredAsEmpty()) {
            throw new EmptyQueryException();
        }
        return (NativeNode)Option$.MODULE$.apply((Object)tree).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)OntopUtils$.$anonfun$extractNativeNode$1(t))).map((Function1 & Serializable & scala.Serializable)t -> ((UnaryIQTree)t).getChild().getRootNode()).filter((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)OntopUtils$.$anonfun$extractNativeNode$3(n))).map((Function1 & Serializable & scala.Serializable)n -> (NativeNode)n).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new MinorOntopInternalBugException(new StringBuilder(71).append("The query does not have the expected structure for an executable query\n").append(executableQuery).toString());
        });
    }

    public ConstructionNode extractRootConstructionNode(IQ executableQuery) throws EmptyQueryException, OntopInternalBugException {
        IQTree tree = executableQuery.getTree();
        if (tree.isDeclaredAsEmpty()) {
            throw new EmptyQueryException();
        }
        return (ConstructionNode)Option$.MODULE$.apply((Object)tree.getRootNode()).filter((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)OntopUtils$.$anonfun$extractRootConstructionNode$1(n))).map((Function1 & Serializable & scala.Serializable)n -> (ConstructionNode)n).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new MinorOntopInternalBugException(new StringBuilder(64).append("The \"executable\" query is not starting with a construction node\n").append(executableQuery).toString());
        });
    }

    private <C extends OntopMappingSQLAllConfiguration.Builder<C>> OBDASpecification loadOBDASpecification(Option<String> database, Model obdaMappings, Properties properties, Option<OWLOntology> ontology) throws OBDASpecificationException {
        OntopMappingSQLAllConfiguration.Builder builder = ontology.nonEmpty() ? OntopMappingSQLAllOWLAPIConfiguration.defaultBuilder().ontology((OWLOntology)ontology.get()) : OntopMappingSQLAllConfiguration.defaultBuilder();
        OntopMappingSQLAllConfiguration mappingConfiguration = ((OntopMappingSQLAllConfiguration.Builder)((OntopSQLCredentialConfiguration.OntopSQLCredentialBuilderFragment)builder.r2rmlMappingGraph((Graph)new JenaRDF().asGraph(obdaMappings)).jdbcUrl(OntopConnection$.MODULE$.getConnectionURL(database))).jdbcUser(OntopConnection$.MODULE$.JDBC_USER()).jdbcPassword(OntopConnection$.MODULE$.JDBC_PASSWORD()).properties(properties).enableTestMode()).build();
        return mappingConfiguration.loadSpecification();
    }

    private <C extends OntopMappingSQLAllConfiguration.Builder<C>> OBDASpecification loadOBDASpecification(String dbMetadata, Model obdaMappings, Properties properties, Option<OWLOntology> ontology) throws OBDASpecificationException {
        OntopMappingSQLAllConfiguration.Builder builder = ontology.nonEmpty() ? OntopMappingSQLAllOWLAPIConfiguration.defaultBuilder().ontology((OWLOntology)ontology.get()) : OntopMappingSQLAllConfiguration.defaultBuilder();
        OntopMappingSQLAllConfiguration mappingConfiguration = ((OntopMappingSQLAllConfiguration.Builder)builder.r2rmlMappingGraph((Graph)new JenaRDF().asGraph(obdaMappings)).dbMetadataReader((Reader)new StringReader(dbMetadata)).properties(properties).enableTestMode()).build();
        return mappingConfiguration.loadSpecification();
    }

    public <B extends OntopSQLOWLAPIConfiguration.Builder<B>, C extends OntopReformulationSQLConfiguration.Builder<C>> OntopReformulationSQLConfiguration createReformulationConfig(Option<String> database, Model obdaMappings, Properties properties, Option<OWLOntology> ontology) throws OBDASpecificationException {
        OBDASpecification obdaSpecification = this.loadOBDASpecification(database, obdaMappings, properties, ontology);
        OntopReformulationSQLConfiguration.Builder builder = ontology.nonEmpty() ? ((OntopSQLCredentialConfiguration.OntopSQLCredentialBuilderFragment)OntopSQLOWLAPIConfiguration.defaultBuilder().ontology((OWLOntology)ontology.get()).properties(properties)).jdbcUser(OntopConnection$.MODULE$.JDBC_USER()).jdbcPassword(OntopConnection$.MODULE$.JDBC_PASSWORD()) : OntopReformulationSQLConfiguration.defaultBuilder();
        return ((OntopReformulationSQLConfiguration.Builder)((OntopSQLCoreConfiguration.OntopSQLCoreBuilderFragment)builder.obdaSpecification(obdaSpecification).properties(properties)).jdbcUrl(OntopConnection$.MODULE$.getConnectionURL(database)).enableTestMode()).build();
    }

    public <B extends OntopSQLOWLAPIConfiguration.Builder<B>, C extends OntopReformulationSQLConfiguration.Builder<C>> OntopReformulationSQLConfiguration createReformulationConfig(String dbMetadata, Model obdaMappings, Properties properties, Option<OWLOntology> ontology) throws OBDASpecificationException {
        OBDASpecification obdaSpecification = this.loadOBDASpecification(dbMetadata, obdaMappings, properties, ontology);
        OntopSQLOWLAPIConfiguration.Builder builder = (OntopSQLOWLAPIConfiguration.Builder)((OntopOBDAConfiguration.OntopOBDABuilderFragment)OntopSQLOWLAPIConfiguration.defaultBuilder().properties(properties)).obdaSpecification(obdaSpecification).enableTestMode();
        Object object = ontology.isDefined() ? builder.ontology((OWLOntology)ontology.get()) : BoxedUnit.UNIT;
        return builder.build();
    }

    public <B extends OntopMappingSQLConfiguration.Builder<B>> OntopMappingSQLConfiguration createMappingConfig(Properties properties, Option<String> database) {
        return ((OntopMappingSQLConfiguration.Builder)((OntopSQLCredentialConfiguration.OntopSQLCredentialBuilderFragment)((OntopSQLCoreConfiguration.OntopSQLCoreBuilderFragment)OntopMappingSQLConfiguration.defaultBuilder().properties(properties)).jdbcUrl(OntopConnection$.MODULE$.getConnectionURL(database))).jdbcUser(OntopConnection$.MODULE$.JDBC_USER()).jdbcPassword(OntopConnection$.MODULE$.JDBC_PASSWORD())).build();
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$extractSQLQuery$1(IQTree t) {
        return t instanceof UnaryIQTree;
    }

    public static final /* synthetic */ boolean $anonfun$extractSQLQuery$3(QueryNode n) {
        return n instanceof NativeNode;
    }

    public static final /* synthetic */ boolean $anonfun$extractNativeNode$1(IQTree t) {
        return t instanceof UnaryIQTree;
    }

    public static final /* synthetic */ boolean $anonfun$extractNativeNode$3(QueryNode n) {
        return n instanceof NativeNode;
    }

    public static final /* synthetic */ boolean $anonfun$extractRootConstructionNode$1(QueryNode n) {
        return n instanceof ConstructionNode;
    }

    private OntopUtils$() {
        MODULE$ = this;
        this.fixScientificNotation = true;
        this.formatter = NumberFormat.getInstance();
        this.formatter().setMaximumIntegerDigits(Integer.MAX_VALUE);
        this.formatter().setMaximumFractionDigits(Integer.MAX_VALUE);
    }
}

