/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.ontop;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import net.sansa_stack.query.spark.ontop.PropertyTablePartitioner;
import net.sansa_stack.query.spark.ontop.PropertyTablePartitioner$;
import net.sansa_stack.query.spark.ontop.PropertyTablePartitioner$Config$;
import net.sansa_stack.rdf.spark.io.package;
import net.sansa_stack.rdf.spark.io.package$;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.vocabulary.RDF;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Null$;
import scopt.OptionParser;
import scopt.Read$;

public final class PropertyTablePartitioner$ {
    public static PropertyTablePartitioner$ MODULE$;
    private final OptionParser<PropertyTablePartitioner.Config> parser;

    static {
        new PropertyTablePartitioner$();
    }

    public OptionParser<PropertyTablePartitioner.Config> parser() {
        return this.parser;
    }

    public void main(String[] args) {
        Option option = this.parser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new PropertyTablePartitioner.Config(PropertyTablePartitioner$Config$.MODULE$.apply$default$1(), PropertyTablePartitioner$Config$.MODULE$.apply$default$2(), PropertyTablePartitioner$Config$.MODULE$.apply$default$3(), PropertyTablePartitioner$Config$.MODULE$.apply$default$4(), PropertyTablePartitioner$Config$.MODULE$.apply$default$5(), PropertyTablePartitioner$Config$.MODULE$.apply$default$6()));
        if (option instanceof Some) {
            Some some = (Some)option;
            PropertyTablePartitioner.Config config = (PropertyTablePartitioner.Config)some.value();
            this.run(config);
            return;
        }
    }

    private void run(PropertyTablePartitioner.Config config) {
        SparkSession spark = SparkSession$.MODULE$.builder().master("local").appName("property table partitioner").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.kryo.registrator", String.join((CharSequence)", ", "net.sansa_stack.rdf.spark.io.JenaKryoRegistrator")).config("spark.sql.warehouse.dir", config.outputPath().getPath()).config("spark.sql.cbo.enabled", true).config("spark.sql.statistics.histogram.enabled", true).enableHiveSupport().getOrCreate();
        if (!spark.catalog().tableExists("triples") || config.overwrite()) {
            BoxedUnit boxedUnit;
            if (config.overwrite()) {
                Predef$.MODULE$.println((Object)"overwriting ...");
                boxedUnit = spark.sql(new StringBuilder(23).append("DROP TABLE IF EXISTS `").append(config.tableName()).append("`").toString());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            package.RDFReader qual$1 = package$.MODULE$.RDFReader(spark);
            boolean x$12 = qual$1.ntriples$default$1();
            RDD triplesRDD = (RDD)qual$1.ntriples(x$12).apply((Object)config.inputPath().getPath());
            if (config.schemaPath() != null) {
                OWLOntology ont = OWLManager.createOWLOntologyManager().loadOntologyFromOntologyDocument(IRI.create((URI)config.schemaPath()));
                scala.collection.immutable.Set objectProperties = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(ont.getObjectPropertiesInSignature().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toStringID()).toSet();
                scala.collection.immutable.Set dataProperties = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(ont.getDataPropertiesInSignature().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toStringID()).toSet();
                scala.collection.immutable.Set schemaProperties = (scala.collection.immutable.Set)objectProperties.$plus$plus((GenTraversableOnce)dataProperties).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{RDF.type.getURI()})));
                triplesRDD = triplesRDD.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)schemaProperties.contains((Object)t.getPredicate().getURI())));
            }
            triplesRDD.cache();
            List properties = (List)((List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])triplesRDD.map((Function1 & Serializable & scala.Serializable)t -> t.getPredicate().getURI(), ClassTag$.MODULE$.apply(String.class)).distinct().collect())).toList().sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$1 -> NodeFactory.createURI((String)x$1), List$.MODULE$.canBuildFrom());
            HashMap zero = new HashMap();
            RDD x$22 = triplesRDD.map((Function1 & Serializable & scala.Serializable)t -> new Tuple2((Object)t.getSubject(), (Object)new Tuple2((Object)t.getPredicate(), (Object)t.getObject())), ClassTag$.MODULE$.apply(Tuple2.class));
            ClassTag x$32 = ClassTag$.MODULE$.apply(Node.class);
            ClassTag x$4 = ClassTag$.MODULE$.apply(Tuple2.class);
            Null$ x$52 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$22);
            RDD rows = RDD$.MODULE$.rddToPairRDDFunctions(x$22, x$32, x$4, null).aggregateByKey((Object)zero, (Function2 & Serializable & scala.Serializable)(accumulator, element) -> this.seqOp$1((HashMap)accumulator, (Tuple2)element), (Function2 & Serializable & scala.Serializable)(accumulator1, accumulator2) -> PropertyTablePartitioner$.combOp$1(accumulator1, accumulator2), ClassTag$.MODULE$.apply(HashMap.class)).map((Function1 & Serializable & scala.Serializable)e -> {
                Node s = (Node)e._1();
                HashMap prop2Values = (HashMap)e._2();
                List cols = (List)new .colon.colon((Object)s.getURI(), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)properties.map((Function1 & Serializable & scala.Serializable)p -> {
                    Option option = prop2Values.get(p);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Set vals = (Set)some.value();
                        return (String[])((TraversableOnce)vals.map((Function1 & Serializable & scala.Serializable)v -> v.toString(), Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                    }
                    if (None$.MODULE$.equals(option)) {
                        return null;
                    }
                    throw new MatchError((Object)option);
                }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
                return Row$.MODULE$.apply((Seq)cols);
            }, ClassTag$.MODULE$.apply(Row.class));
            Map prop2ColumnName = (Map)((TraversableLike)properties.map((Function1 & Serializable & scala.Serializable)p -> new Tuple2((Object)p.getLocalName(), p), List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._1()).flatMap((Function1 & Serializable & scala.Serializable)e -> {
                if (((SeqLike)e._2()).size() > 1) {
                    return (List)((List)e._2()).map((Function1 & Serializable & scala.Serializable)el -> new Tuple2(el._2(), (Object)FmtUtils.stringForNode((Node)((Node)el._2()))), List$.MODULE$.canBuildFrom());
                }
                return (List)e._2();
            }, Map$.MODULE$.canBuildFrom());
            PrefixMappingImpl pm = new PrefixMappingImpl();
            pm.setNsPrefix("dbo", "http://dbpedia.org/ontology/");
            SerializationContext ctx = new SerializationContext();
            ctx.setPrefixMapping((PrefixMapping)pm);
            StructType schema = (StructType)((LinearSeqOptimized)new .colon.colon((Object)new StructField("s", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)properties.map((Function1 & Serializable & scala.Serializable)p -> new StructField(FmtUtils.stringForNode((Node)p, (PrefixMapping)pm), (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).foldLeft((Object)new StructType(), (Function2 & Serializable & scala.Serializable)(x$6, x$7) -> x$6.add(x$7));
            Dataset df = spark.createDataFrame(rows, schema);
            df.createOrReplaceTempView("triples");
            df.show(false);
            df.printSchema();
            df.repartition(10).write().format("parquet").bucketBy(10, "s", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).sortBy("s", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).saveAsTable(config.tableName());
        }
        spark.sql("select * FROM triples WHERE s='http://dbpedia.org/resource/Aaron_Dennis'").show(false);
        spark.sql("select * FROM triples WHERE s='http://dbpedia.org/resource/Aaron_King'").show(false);
    }

    public <A, B> PropertyTablePartitioner.ListMultiMap<A, B> ListMultiMap(scala.collection.mutable.Map<A, Set<B>> map) {
        return new PropertyTablePartitioner.ListMultiMap<A, B>(map);
    }

    private final HashMap seqOp$1(HashMap accumulator, Tuple2 element) {
        this.ListMultiMap((scala.collection.mutable.Map)accumulator).addBinding(element._1(), element._2());
        return accumulator;
    }

    public static final /* synthetic */ boolean $anonfun$run$6(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$run$7(HashMap accumulator2$1, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 != null) {
            Node k = (Node)tuple2._1();
            Set vs = (Set)tuple2._2();
            vs.foreach((Function1 & Serializable & scala.Serializable)v -> MODULE$.ListMultiMap((scala.collection.mutable.Map)accumulator2$1).addBinding(k, (Node)v));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final HashMap combOp$1(HashMap accumulator1, HashMap accumulator2) {
        accumulator1.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)PropertyTablePartitioner$.$anonfun$run$6(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            PropertyTablePartitioner$.$anonfun$run$7(accumulator2, x$4);
            return BoxedUnit.UNIT;
        });
        return accumulator2;
    }

    private PropertyTablePartitioner$() {
        MODULE$ = this;
        this.parser = new OptionParser<PropertyTablePartitioner.Config>(){

            public static final /* synthetic */ PropertyTablePartitioner.Config $anonfun$new$5(boolean x, PropertyTablePartitioner.Config c) {
                boolean x$19 = x;
                URI x$20 = c.copy$default$1();
                URI x$21 = c.copy$default$2();
                URI x$22 = c.copy$default$3();
                String x$23 = c.copy$default$4();
                boolean x$24 = c.copy$default$6();
                return c.copy(x$20, x$21, x$22, x$23, x$19, x$24);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"property table partitioner", "0.1"}));
                this.opt('i', "input", Read$.MODULE$.uriRead()).required().action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((URI)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6())).text("path to input data");
                this.opt('o', "output", Read$.MODULE$.uriRead()).required().action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    URI x$1 = x;
                    URI x$2 = c.copy$default$1();
                    URI x$3 = c.copy$default$3();
                    String x$4 = c.copy$default$4();
                    boolean x$5 = c.copy$default$5();
                    boolean x$6 = c.copy$default$6();
                    return c.copy(x$2, x$1, x$3, x$4, x$5, x$6);
                }).text("path to output directory");
                this.opt('s', "schema", Read$.MODULE$.uriRead()).optional().action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    URI x$7 = x;
                    URI x$8 = c.copy$default$1();
                    URI x$9 = c.copy$default$2();
                    String x$10 = c.copy$default$4();
                    boolean x$11 = c.copy$default$5();
                    boolean x$12 = c.copy$default$6();
                    return c.copy(x$8, x$9, x$7, x$10, x$11, x$12);
                }).text("an optional file containing the OWL schema to process only object and data properties");
                this.opt('t', "tableName", Read$.MODULE$.stringRead()).optional().action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$13 = x;
                    URI x$14 = c.copy$default$1();
                    URI x$15 = c.copy$default$2();
                    URI x$16 = c.copy$default$3();
                    boolean x$17 = c.copy$default$5();
                    boolean x$18 = c.copy$default$6();
                    return c.copy(x$14, x$15, x$16, x$13, x$17, x$18);
                }).text("the table name");
                this.opt('s', "stats", Read$.MODULE$.booleanRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$5(BoxesRunTime.unboxToBoolean((Object)x), c)).text("compute statistics");
                this.opt("overwrite", Read$.MODULE$.unitRead()).action((Function2 & Serializable & scala.Serializable)(x$1, c) -> {
                    boolean x$25 = true;
                    URI x$26 = c.copy$default$1();
                    URI x$27 = c.copy$default$2();
                    URI x$28 = c.copy$default$3();
                    String x$29 = c.copy$default$4();
                    boolean x$30 = c.copy$default$5();
                    return c.copy(x$26, x$27, x$28, x$29, x$30, x$25);
                }).text("overwrite table if exists");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.net.URI net.sansa_stack.query.spark.ontop.PropertyTablePartitioner$Config ), $anonfun$new$2(java.net.URI net.sansa_stack.query.spark.ontop.PropertyTablePartitioner$Config ), $anonfun$new$3(java.net.URI net.sansa_stack.query.spark.ontop.PropertyTablePartitioner$Config ), $anonfun$new$4(java.lang.String net.sansa_stack.query.spark.ontop.PropertyTablePartitioner$Config ), $anonfun$new$5$adapted(java.lang.Object net.sansa_stack.query.spark.ontop.PropertyTablePartitioner$Config ), $anonfun$new$6(scala.runtime.BoxedUnit net.sansa_stack.query.spark.ontop.PropertyTablePartitioner$Config )}, serializedLambda);
            }
        };
    }
}

