/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.ontop;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import it.unibz.inf.ontop.com.google.common.base.Charsets;
import it.unibz.inf.ontop.com.google.common.hash.Hashing;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import java.io.Serializable;
import java.util.Properties;
import net.sansa_stack.query.spark.ontop.OntopConnection$;
import net.sansa_stack.query.spark.ontop.OntopQueryRewrite;
import net.sansa_stack.query.spark.ontop.OntopRowMapper;
import net.sansa_stack.query.spark.ontop.OntopRowMapper$;
import net.sansa_stack.query.spark.ontop.OntopSPARQL2SQLRewriter;
import net.sansa_stack.query.spark.ontop.OntopSettings;
import net.sansa_stack.query.spark.ontop.OntopSettings$;
import net.sansa_stack.query.spark.ontop.QueryEngineOntop$;
import net.sansa_stack.query.spark.ontop.RewriteInstruction;
import net.sansa_stack.rdf.common.partition.r2rml.R2rmlUtils$;
import net.sansa_stack.rdf.common.partition.utils.SQLUtils$;
import net.sansa_stack.rdf.common.partition.utils.TableIdentifier;
import net.sansa_stack.rdf.spark.utils.ScalaUtils$;
import net.sansa_stack.rdf.spark.utils.SparkSessionUtils$;
import org.aksw.r2rml.jena.domain.api.ObjectMapType;
import org.aksw.r2rml.jena.domain.api.PredicateObjectMap;
import org.aksw.r2rml.jena.domain.api.SubjectMap;
import org.aksw.r2rml.jena.domain.api.TriplesMap;
import org.aksw.r2rml.jena.vocab.RR;
import org.aksw.sparqlify.core.sql.common.serialization.SqlEscaperBacktick;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.vocabulary.RDF;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.semanticweb.owlapi.model.OWLOntology;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tUb\u0001B\u0014)\u0001MB\u0001b\u000b\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\r\u0002\u0011\t\u0011)A\u0005w!Aq\t\u0001BC\u0002\u0013\u0005\u0001\n\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003J\u0011!A\u0006A!b\u0001\n\u0003I\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011\u0015\u0004!\u00111A\u0005\u0002\u0019D\u0001\"\u001d\u0001\u0003\u0002\u0004%\tA\u001d\u0005\tq\u0002\u0011\t\u0011)Q\u0005O\")\u0011\u0010\u0001C\u0001u\"I\u00111\u0001\u0001C\u0002\u0013%\u0011Q\u0001\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\b!I\u0011Q\u0004\u0001C\u0002\u0013\u0005\u0011q\u0004\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002\"!I\u00111\u0007\u0001C\u0002\u0013\u0005\u0011Q\u0007\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u00028!I\u0011q\b\u0001C\u0002\u0013%\u0011\u0011\t\u0005\t\u0003C\u0002\u0001\u0015!\u0003\u0002D!I\u00111\r\u0001C\u0002\u0013\u0005\u0011Q\r\u0005\t\u0003[\u0002\u0001\u0015!\u0003\u0002h!I\u0011q\u000e\u0001C\u0002\u0013%\u0011\u0011\u000f\u0005\b\u0003g\u0002\u0001\u0015!\u0003M\u0011%\t)\b\u0001b\u0001\n\u0013\t9\b\u0003\u0005\u0002\u0000\u0001\u0001\u000b\u0011BA=\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007Cq!!\"\u0001\t\u0013\t9\tC\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u000e\"9\u0011\u0011\u0013\u0001\u0005\u0002\u00055\u0005bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003\u000b\u0004A\u0011AAd\u0011\u001d\tY\u000f\u0001C\u0001\u0003[DqA!\u0001\u0001\t\u0013\u0011\u0019\u0001C\u0004\u0003\u0016\u0001!IAa\u0006\b\u000f\t}\u0001\u0006#\u0001\u0003\"\u00191q\u0005\u000bE\u0001\u0005GAa!\u001f\u0013\u0005\u0002\t\u0015\u0002b\u0002B\u0014I\u0011\u0005!\u0011\u0006\u0002\u0011#V,'/_#oO&tWm\u00148u_BT!!\u000b\u0016\u0002\u000b=tGo\u001c9\u000b\u0005-b\u0013!B:qCJ\\'BA\u0017/\u0003\u0015\tX/\u001a:z\u0015\ty\u0003'A\u0006tC:\u001c\u0018mX:uC\u000e\\'\"A\u0019\u0002\u00079,Go\u0001\u0001\u0014\u0005\u0001!\u0004CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$AB!osJ+g-F\u0001<!\taD)D\u0001>\u0015\tqt(A\u0002tc2T!a\u000b!\u000b\u0005\u0005\u0013\u0015AB1qC\u000eDWMC\u0001D\u0003\ry'oZ\u0005\u0003\u000bv\u0012Ab\u00159be.\u001cVm]:j_:\faa\u001d9be.\u0004\u0013\u0001\u00033bi\u0006\u0014\u0017m]3\u0016\u0003%\u00032!\u000e&M\u0013\tYeG\u0001\u0004PaRLwN\u001c\t\u0003\u001bRs!A\u0014*\u0011\u0005=3T\"\u0001)\u000b\u0005E\u0013\u0014A\u0002\u001fs_>$h(\u0003\u0002Tm\u00051\u0001K]3eK\u001aL!!\u0016,\u0003\rM#(/\u001b8h\u0015\t\u0019f'A\u0005eCR\f'-Y:fA\u0005iQ.\u00199qS:<7/T8eK2,\u0012A\u0017\t\u00037\nl\u0011\u0001\u0018\u0006\u0003;z\u000bQ!\\8eK2T!a\u00181\u0002\u0007I$gM\u0003\u0002b\u0001\u0006!!.\u001a8b\u0013\t\u0019GLA\u0003N_\u0012,G.\u0001\bnCB\u0004\u0018N\\4t\u001b>$W\r\u001c\u0011\u0002\u0011=tGo\u001c7pOf,\u0012a\u001a\t\u0004k)C\u0007CA5p\u001b\u0005Q'BA/l\u0015\taW.\u0001\u0004po2\f\u0007/\u001b\u0006\u0003]\n\u000b1b]3nC:$\u0018nY<fE&\u0011\u0001O\u001b\u0002\f\u001f^cuJ\u001c;pY><\u00170\u0001\u0007p]R|Gn\\4z?\u0012*\u0017\u000f\u0006\u0002tmB\u0011Q\u0007^\u0005\u0003kZ\u0012A!\u00168ji\"9q\u000fCA\u0001\u0002\u00049\u0017a\u0001=%c\u0005IqN\u001c;pY><\u0017\u0010I\u0001\u0007y%t\u0017\u000e\u001e \u0015\rmlhp`A\u0001!\ta\b!D\u0001)\u0011\u0015Y#\u00021\u0001<\u0011\u00159%\u00021\u0001J\u0011\u0015A&\u00021\u0001[\u0011\u0015)'\u00021\u0001h\u0003\u0019awnZ4feV\u0011\u0011q\u0001\t\u0005\u0003\u0013\t9\"\u0004\u0002\u0002\f)!\u0011QBA\b\u00031\u00198-\u00197bY><w-\u001b8h\u0015\u0011\t\t\"a\u0005\u0002\u0011QL\b/Z:bM\u0016T!!!\u0006\u0002\u0007\r|W.\u0003\u0003\u0002\u001a\u0005-!A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u001f=tGo\u001c9Qe>\u0004XM\u001d;jKN,\"!!\t\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005!Q\u000f^5m\u0015\t\tY#\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u0003K\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003Ayg\u000e^8q!J|\u0007/\u001a:uS\u0016\u001c\b%\u0001\u0005tKR$\u0018N\\4t+\t\t9\u0004E\u0002}\u0003sI1!a\u000f)\u00055ye\u000e^8q'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\u000bgFdWi]2ba\u0016\u0014XCAA\"!\u0011\t)%!\u0018\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\nQb]3sS\u0006d\u0017N_1uS>t'\u0002BA'\u0003\u001f\naaY8n[>t'b\u0001 \u0002R)!\u00111KA+\u0003\u0011\u0019wN]3\u000b\t\u0005]\u0013\u0011L\u0001\ngB\f'/\u001d7jMfT1!a\u0017C\u0003\u0011\t7n]<\n\t\u0005}\u0013q\t\u0002\u0013'FdWi]2ba\u0016\u0014()Y2li&\u001c7.A\u0006tc2,5oY1qKJ\u0004\u0013\u0001\u00046eE\u000elU\r^1ECR\fWCAA4!\u0015i\u0015\u0011\u000e'M\u0013\r\tYG\u0016\u0002\u0004\u001b\u0006\u0004\u0018!\u00046eE\u000elU\r^1ECR\f\u0007%A\u0005tKN\u001c\u0018n\u001c8JIV\tA*\u0001\u0006tKN\u001c\u0018n\u001c8JI\u0002\n!b\u001d9beFd'g]9m+\t\tI\bE\u0002}\u0003wJ1!! )\u0005]ye\u000e^8q'B\u000b%+\u0015'3'Fc%+Z<sSR,'/A\u0006ta\u0006\u0014\u0018\u000f\u001c\u001atc2\u0004\u0013!E4f]\u0016\u0014\u0018\r^3TKN\u001c\u0018n\u001c8JIR\tA*A\ffqB\fg\u000eZ'baBLgnZ:XSRDG+\u001f9fgR\u00191/!#\t\u000buS\u0002\u0019\u0001.\u0002\u000fA\u0014X\r]1sKR\t1/\u0001\u0003ti>\u0004\u0018!B2mK\u0006\u0014\u0018\u0001D3yK\u000e,H/\u001a#fEV<G\u0003BAL\u0003\u0007\u0004r!NAM\u0003;\u000bY,C\u0002\u0002\u001cZ\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BAP\u0003ksA!!)\u00022:!\u00111UAX\u001d\u0011\t)+!,\u000f\t\u0005\u001d\u00161\u0016\b\u0004\u001f\u0006%\u0016\"A\"\n\u0005\u0005\u0013\u0015BA\u0016A\u0013\tqt(C\u0002\u00024v\nq\u0001]1dW\u0006<W-\u0003\u0003\u00028\u0006e&!\u0003#bi\u00064%/Y7f\u0015\r\t\u0019,\u0010\t\u0005k)\u000bi\fE\u0002}\u0003\u007fK1!!1)\u0005Eye\u000e^8q#V,'/\u001f*foJLG/\u001a\u0005\u0006[y\u0001\r\u0001T\u0001\u0010G>l\u0007/\u001e;f\u0005&tG-\u001b8hgR!\u0011\u0011ZAu!\u0019\tY-!5\u0002V6\u0011\u0011Q\u001a\u0006\u0004\u0003\u001f|\u0014a\u0001:eI&!\u00111[Ag\u0005\r\u0011F\t\u0012\t\u0005\u0003/\f)/\u0004\u0002\u0002Z*!\u00111\\Ao\u0003\u001d\u0011\u0017N\u001c3j]\u001eTA!a8\u0002b\u00061QM\\4j]\u0016T1!a9a\u0003\u0019\u0019\b/\u0019:rY&!\u0011q]Am\u0005\u001d\u0011\u0015N\u001c3j]\u001eDQ!L\u0010A\u00021\u000bAcY8naV$XMQ5oI&twm\u001d'pG\u0006dG\u0003BAx\u0003\u007f\u0004b!!=\u0002z\u0006Ug\u0002BAz\u0003ot1aTA{\u0013\u00059\u0014bAAZm%!\u00111`A\u007f\u0005\r\u0019V-\u001d\u0006\u0004\u0003g3\u0004\"B\u0017!\u0001\u0004a\u0015AF3wC2,\u0018\r^3CS:$\u0017N\\4t%\u0016lw\u000e^3\u0015\u0011\u0005%'Q\u0001B\u0005\u0005\u0017AqAa\u0002\"\u0001\u0004\ti*\u0001\u0003s_^\u001c\b\"B\u0017\"\u0001\u0004a\u0005b\u0002B\u0007C\u0001\u0007!qB\u0001\u0013e\u0016<(/\u001b;f\u0013:\u001cHO];di&|g\u000eE\u0002}\u0005#I1Aa\u0005)\u0005I\u0011Vm\u001e:ji\u0016Len\u001d;sk\u000e$\u0018n\u001c8\u0002+\u00154\u0018\r\\;bi\u0016\u0014\u0015N\u001c3j]\u001e\u001cHj\\2bYRA\u0011q\u001eB\r\u00057\u0011i\u0002C\u0004\u0003\b\t\u0002\r!!(\t\u000b5\u0012\u0003\u0019\u0001'\t\u000f\t5!\u00051\u0001\u0003\u0010\u0005\u0001\u0012+^3ss\u0016sw-\u001b8f\u001f:$x\u000e\u001d\t\u0003y\u0012\u001a\"\u0001\n\u001b\u0015\u0005\t\u0005\u0012!B1qa2LH#C>\u0003,\t5\"\u0011\u0007B\u001a\u0011\u0015Yc\u00051\u0001<\u0011\u0019\u0011yC\na\u0001\u0013\u0006aA-\u0019;bE\u0006\u001cXMT1nK\")\u0001L\na\u00015\")QM\na\u0001O\u0002")
public class QueryEngineOntop {
    private final SparkSession spark;
    private final Option<String> database;
    private final Model mappingsModel;
    private Option<OWLOntology> ontology;
    private final Logger logger;
    private final Properties ontopProperties;
    private final OntopSettings settings;
    private final SqlEscaperBacktick sqlEscaper;
    private final Map<String, String> jdbcMetaData;
    private final String sessionId;
    private final OntopSPARQL2SQLRewriter sparql2sql;

    public static QueryEngineOntop apply(SparkSession sparkSession, Option<String> option, Model model, Option<OWLOntology> option2) {
        return QueryEngineOntop$.MODULE$.apply(sparkSession, option, model, option2);
    }

    public SparkSession spark() {
        return this.spark;
    }

    public Option<String> database() {
        return this.database;
    }

    public Model mappingsModel() {
        return this.mappingsModel;
    }

    public Option<OWLOntology> ontology() {
        return this.ontology;
    }

    public void ontology_$eq(Option<OWLOntology> x$1) {
        this.ontology = x$1;
    }

    private Logger logger() {
        return this.logger;
    }

    public Properties ontopProperties() {
        return this.ontopProperties;
    }

    public OntopSettings settings() {
        return this.settings;
    }

    private SqlEscaperBacktick sqlEscaper() {
        return this.sqlEscaper;
    }

    public Map<String, String> jdbcMetaData() {
        return this.jdbcMetaData;
    }

    private String sessionId() {
        return this.sessionId;
    }

    private OntopSPARQL2SQLRewriter sparql2sql() {
        return this.sparql2sql;
    }

    private String generateSessionId() {
        String s = new StringBuilder(0).append((String)this.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(((TraversableOnce)this.jdbcMetaData().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.productIterator().mkString(":"), Iterable$.MODULE$.canBuildFrom())).mkString("|")).append(this.mappingsModel().hashCode()).toString();
        return Hashing.sha256().hashString((CharSequence)s, Charsets.UTF_8).toString();
    }

    private void expandMappingsWithTypes(Model model) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("expanding mappings with rdf:type mappings ...");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Iterator tms = R2rmlUtils$.MODULE$.triplesMapsForPredicate(RDF.type, model).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)QueryEngineOntop.$anonfun$expandMappingsWithTypes$1(model, x$2)));
        tms.foreach((Function1 & Serializable & scala.Serializable)tm -> {
            BoxedUnit boxedUnit;
            String tableName = tm.getLogicalTable().asBaseTableOrView().getTableName();
            String s = tm.getSubjectMap().getColumn();
            String o = ((ObjectMapType)((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(((PredicateObjectMap)((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(tm.getPredicateObjectMaps()).asScala()).head()).getObjectMaps()).asScala()).head()).asTermMap().getColumn();
            TableIdentifier tn = SQLUtils$.MODULE$.parseTableIdentifier(tableName);
            String to = this.sqlEscaper().escapeColumnName(ScalaUtils$.MODULE$.unQuote(o, ScalaUtils$.MODULE$.unQuote$default$2()));
            Dataset df = this.spark().sql(new StringBuilder(22).append("SELECT DISTINCT ").append(to).append(" FROM ").append(tn).toString());
            String[] classes = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classes)).foreach((Function1 & Serializable & scala.Serializable)cls -> {
                TriplesMap tm = (TriplesMap)model.createResource().as(TriplesMap.class);
                tm.getOrSetLogicalTable().asR2rmlView().setSqlQuery(new StringBuilder(25).append("SELECT ").append(s).append(" FROM ").append(tableName).append(" WHERE ").append(o).append(" = '").append((String)cls).append("'").toString());
                SubjectMap sm = tm.getOrSetSubjectMap();
                sm.setColumn(s);
                sm.setTermType(RR.IRI.inModel(model));
                PredicateObjectMap pom = tm.addNewPredicateObjectMap();
                pom.addPredicate((Resource)RDF.type.inModel(model));
                return pom.addObject(model.createResource(cls));
            });
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("finished expanding mappings with rdf:type mappings (added {} class mappings)", new Object[]{BoxesRunTime.boxToInteger((int)classes.length)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return model.removeAll((Resource)tm, null, null);
        });
    }

    public void prepare() {
        if (!this.spark().sparkContext().isLocal()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("preparing Ontop setup on executors ...");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Broadcast mappingsBC = this.spark().sparkContext().broadcast((Object)this.mappingsModel(), ClassTag$.MODULE$.apply(Model.class));
            Broadcast propertiesBC = this.spark().sparkContext().broadcast((Object)this.ontopProperties(), ClassTag$.MODULE$.apply(Properties.class));
            Broadcast jdbcMetadataBC = this.spark().sparkContext().broadcast(this.jdbcMetaData(), ClassTag$.MODULE$.apply(Map.class));
            Broadcast ontologyBC = this.spark().sparkContext().broadcast(this.ontology(), ClassTag$.MODULE$.apply(Option.class));
            Broadcast idBC = this.spark().sparkContext().broadcast((Object)this.sessionId(), ClassTag$.MODULE$.apply(String.class));
            Broadcast databaseBC = this.spark().sparkContext().broadcast(this.database(), ClassTag$.MODULE$.apply(Option.class));
            int numExecutors = SparkSessionUtils$.MODULE$.currentActiveExecutors(this.spark()).size();
            if (numExecutors > 0) {
                BoxedUnit boxedUnit2;
                RDD data = this.spark().sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).toList(), this.spark().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.Int()).repartition(3 * numExecutors, (Ordering)Ordering.Int$.MODULE$);
                data.foreachPartition((Function1 & Serializable & scala.Serializable)x$6 -> {
                    QueryEngineOntop.$anonfun$prepare$1(idBC, databaseBC, mappingsBC, propertiesBC, jdbcMetadataBC, ontologyBC, x$6);
                    return BoxedUnit.UNIT;
                });
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("finished preparing Ontop setup on executors.");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                return;
            }
            return;
        }
    }

    public void stop() {
        this.sparql2sql().close();
    }

    public void clear() {
        this.spark().catalog().clearCache();
    }

    public Tuple2<Dataset<Row>, Option<OntopQueryRewrite>> executeDebug(String query) {
        Tuple2 tuple2;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("SPARQL query:\n{}", new Object[]{query});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            BoxedUnit boxedUnit2;
            OntopQueryRewrite queryRewrite = this.sparql2sql().createSQLQuery(query);
            String sql = queryRewrite.sqlQuery();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("SQL query:\n{}", new Object[]{sql});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Dataset resultRaw = this.spark().sql(sql);
            tuple2 = new Tuple2((Object)resultRaw, (Object)new Some((Object)queryRewrite));
        }
        catch (EmptyQueryException e) {
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Empty SQL query generated by Ontop. Returning empty DataFrame for SPARQL query\n{}", new Object[]{query});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            tuple2 = new Tuple2((Object)this.spark().emptyDataFrame(), (Object)None$.MODULE$);
        }
        catch (AnalysisException e) {
            BoxedUnit boxedUnit4;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(45).append("Spark failed to execute translated SQL query\n").append(query).toString(), (Throwable)e);
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return tuple2;
    }

    public RDD<Binding> computeBindings(String query) {
        Tuple2<Dataset<Row>, Option<OntopQueryRewrite>> df2Rewrite = this.executeDebug(query);
        Option rewriteOpt = (Option)df2Rewrite._2();
        Option option = rewriteOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            OntopQueryRewrite rewrite = (OntopQueryRewrite)some.value();
            Dataset df = (Dataset)df2Rewrite._1();
            RewriteInstruction rwi = rewrite.rewriteInstruction();
            if (this.settings().useLocalEvaluation()) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("computing the bindings locally, i.e. in the driver. This can be time consuming of the result is large.Please try the non-local evaluation in that case which keeps the data always distributed");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                Seq<Binding> bindings = this.evaluateBindingsLocal((Dataset<Row>)df, query, rwi);
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("got {} bindings. Re-distributing on the cluster into {} partitions (using 'spark.default.parallelism' value)", new Object[]{bindings, BoxesRunTime.boxToInteger((int)this.spark().sparkContext().defaultParallelism())});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.spark().sparkContext().parallelize(bindings, this.spark().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Binding.class));
            }
            return this.evaluateBindingsRemote((Dataset<Row>)df, query, rwi);
        }
        if (None$.MODULE$.equals(option)) {
            return this.spark().sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Binding.class));
        }
        throw new MatchError((Object)option);
    }

    public Seq<Binding> computeBindingsLocal(String query) {
        Tuple2<Dataset<Row>, Option<OntopQueryRewrite>> df2Rewrite = this.executeDebug(query);
        Option rewriteOpt = (Option)df2Rewrite._2();
        Option option = rewriteOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            OntopQueryRewrite rewrite = (OntopQueryRewrite)some.value();
            Dataset df = (Dataset)df2Rewrite._1();
            RewriteInstruction rwi = rewrite.rewriteInstruction();
            Seq<Binding> bindings = this.evaluateBindingsLocal((Dataset<Row>)df, query, rwi);
            return bindings;
        }
        if (None$.MODULE$.equals(option)) {
            return (Seq)Nil$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private RDD<Binding> evaluateBindingsRemote(Dataset<Row> rows, String query, RewriteInstruction rewriteInstruction) {
        Broadcast sparqlQueryBC = this.spark().sparkContext().broadcast((Object)query, ClassTag$.MODULE$.apply(String.class));
        Broadcast mappingsBC = this.spark().sparkContext().broadcast((Object)this.mappingsModel(), ClassTag$.MODULE$.apply(Model.class));
        Broadcast propertiesBC = this.spark().sparkContext().broadcast((Object)this.ontopProperties(), ClassTag$.MODULE$.apply(Properties.class));
        Broadcast jdbcMetadataBC = this.spark().sparkContext().broadcast(this.jdbcMetaData(), ClassTag$.MODULE$.apply(Map.class));
        Broadcast ontologyBC = this.spark().sparkContext().broadcast(this.ontology(), ClassTag$.MODULE$.apply(Option.class));
        Broadcast idBC = this.spark().sparkContext().broadcast((Object)this.sessionId(), ClassTag$.MODULE$.apply(String.class));
        Broadcast databaseBC = this.spark().sparkContext().broadcast(this.database(), ClassTag$.MODULE$.apply(Option.class));
        Broadcast rwiBC = this.spark().sparkContext().broadcast((Object)rewriteInstruction, ClassTag$.MODULE$.apply(RewriteInstruction.class));
        Broadcast dbMetadataBC = this.spark().sparkContext().broadcast((Object)this.sparql2sql().dbMetadata(), ClassTag$.MODULE$.apply(String.class));
        Encoder bindingEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Binding.class));
        Dataset df = rows;
        if (this.settings().maxRowMappers() > 0) {
            df = df.coalesce(this.settings().maxRowMappers());
        }
        RDD rdd = df.mapPartitions((Function1 & Serializable & scala.Serializable)iterator -> {
            String id = (String)idBC.value();
            Option db = (Option)databaseBC.value();
            Model mappings = (Model)mappingsBC.value();
            Properties properties = (Properties)propertiesBC.value();
            Map jdbcMetadata = (Map)jdbcMetadataBC.value();
            Option ontology = (Option)ontologyBC.value();
            String dbMetadata = (String)dbMetadataBC.value();
            OntopConnection$.MODULE$.apply(id, (Option<String>)db, mappings, properties, (Map<String, String>)jdbcMetadata, (Option<OWLOntology>)ontology);
            RewriteInstruction rwi = (RewriteInstruction)rwiBC.value();
            OntopRowMapper mapper = new OntopRowMapper(id, (Option<String>)db, mappings, properties, (Map<String, String>)jdbcMetadata, (String)sparqlQueryBC.value(), (Option<OWLOntology>)ontology, rwi, dbMetadata);
            Iterator it = iterator.map((Function1 & Serializable & scala.Serializable)row -> mapper.map((Row)row));
            return it;
        }, bindingEncoder).rdd();
        return rdd;
    }

    private Seq<Binding> evaluateBindingsLocal(Dataset<Row> rows, String query, RewriteInstruction rewriteInstruction) {
        OntopRowMapper mapper = new OntopRowMapper(this.sessionId(), this.database(), this.mappingsModel(), this.ontopProperties(), this.jdbcMetaData(), query, this.ontology(), rewriteInstruction, OntopRowMapper$.MODULE$.$lessinit$greater$default$9());
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows.collect())).map((Function1 & Serializable & scala.Serializable)row -> mapper.map((Row)row), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public static final /* synthetic */ boolean $anonfun$expandMappingsWithTypes$3(Model model$1, ObjectMapType x$4) {
        Resource resource = x$4.asTermMap().getTermType();
        Resource resource2 = RR.IRI.inModel(model$1);
        return !(resource != null ? !resource.equals(resource2) : resource2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$expandMappingsWithTypes$2(Model model$1, PredicateObjectMap x$3) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(x$3.getObjectMaps()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)QueryEngineOntop.$anonfun$expandMappingsWithTypes$3(model$1, x$4)));
    }

    public static final /* synthetic */ boolean $anonfun$expandMappingsWithTypes$1(Model model$1, TriplesMap x$2) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(x$2.getPredicateObjectMaps()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)QueryEngineOntop.$anonfun$expandMappingsWithTypes$2(model$1, x$3)));
    }

    public static final /* synthetic */ void $anonfun$prepare$1(Broadcast idBC$1, Broadcast databaseBC$1, Broadcast mappingsBC$1, Broadcast propertiesBC$1, Broadcast jdbcMetadataBC$1, Broadcast ontologyBC$1, Iterator x$6) {
        String id = (String)idBC$1.value();
        Option db = (Option)databaseBC$1.value();
        Model mappings = (Model)mappingsBC$1.value();
        Properties properties = (Properties)propertiesBC$1.value();
        Map jdbcMetadata = (Map)jdbcMetadataBC$1.value();
        Option ontology = (Option)ontologyBC$1.value();
        OntopConnection$.MODULE$.apply(id, (Option<String>)db, mappings, properties, (Map<String, String>)jdbcMetadata, (Option<OWLOntology>)ontology);
    }

    public QueryEngineOntop(SparkSession spark, Option<String> database, Model mappingsModel, Option<OWLOntology> ontology) {
        block5: {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            this.spark = spark;
            this.database = database;
            this.mappingsModel = mappingsModel;
            this.ontology = ontology;
            Predef$.MODULE$.require(spark != null, (Function0 & Serializable & scala.Serializable)() -> "Spark session must not be null.");
            Predef$.MODULE$.require(!mappingsModel.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Mappings model must not be empty.");
            this.logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(QueryEngineOntop.class));
            this.ontopProperties = new Properties();
            this.ontopProperties().load(this.getClass().getClassLoader().getResourceAsStream("ontop-spark.properties"));
            this.settings = OntopSettings$.MODULE$.apply(this.ontopProperties());
            this.sqlEscaper = new SqlEscaperBacktick();
            Object object = database.isDefined() ? spark.sql(new StringBuilder(4).append("USE ").append(this.sqlEscaper().escapeIdentifier((String)database.get())).toString()) : BoxedUnit.UNIT;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("computing Spark DB metadata ...");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.jdbcMetaData = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spark.catalog().listTables().collect())).map((Function1 & Serializable & scala.Serializable)t -> {
                String fields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().table(this.sqlEscaper().escapeTableName(t.name())).schema().fields())).map((Function1 & Serializable & scala.Serializable)f -> this.sqlEscaper().escapeColumnName(f.name()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
                String keyCondition = new StringBuilder(14).append("PRIMARY KEY (").append(fields).append(")").toString();
                return new Tuple2((Object)t.name(), (Object)new StringBuilder(2).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().table(this.sqlEscaper().escapeTableName(t.name())).schema().fields())).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(2).append(this.sqlEscaper().escapeColumnName(f.name())).append(" ").append(f.dataType().sql()).append(" ").append((Object)(!f.nullable() ? "NOT NULL" : "")).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")).append(", ").append(keyCondition).toString());
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("finished computing Spark DB metadata");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (this.ontology().isEmpty()) {
                this.ontology_$eq((Option<OWLOntology>)None$.MODULE$);
            }
            this.expandMappingsWithTypes(mappingsModel);
            this.sessionId = this.generateSessionId();
            this.sparql2sql = new OntopSPARQL2SQLRewriter(this.sessionId(), this.ontopProperties(), database, this.jdbcMetaData(), mappingsModel, this.ontology());
            if (!this.settings().preInitializeWorkers()) break block5;
            this.prepare();
        }
    }
}

