/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.ontop;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.DBTermTypeImpl;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.StringDBTermType;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.rdf.simple.SimpleRDF;
import org.apache.jena.datatypes.xsd.XSDDatatype;

class SparkDBTypeFactory
extends DefaultSQLDBTypeFactory {
    protected static final String TEXT_STR = "STRING";
    protected static final String BYTE_STR = "BYTE";
    protected static final String SHORT_STR = "SHORT";
    protected static final String LONG_STR = "LONG";
    protected static final String DEC_STR = "DEC";

    @AssistedInject
    private SparkDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(SparkDBTypeFactory.createSparkSQLTypeMap(rootTermType, typeFactory), SparkDBTypeFactory.createSparkSQLCodeMap());
    }

    private static Map<String, DBTermType> createSparkSQLTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        Map map = SparkDBTypeFactory.createDefaultSQLTypeMap((TermType)rootTermType, (TypeFactory)typeFactory);
        DBTermType rootDBType = (DBTermType)map.get("AbstractDBType");
        TermTypeAncestry rootAncestry = rootDBType.getAncestry();
        NumberDBTermType byteType = new NumberDBTermType(BYTE_STR, rootAncestry, typeFactory.getDatatype(XSD.BYTE), DBTermType.Category.INTEGER);
        NumberDBTermType shortType = new NumberDBTermType(SHORT_STR, rootAncestry, typeFactory.getDatatype(XSD.SHORT), DBTermType.Category.INTEGER);
        NumberDBTermType intType = new NumberDBTermType("INT", rootAncestry, typeFactory.getDatatype(XSD.INT), DBTermType.Category.INTEGER);
        NumberDBTermType longType = new NumberDBTermType(LONG_STR, rootAncestry, typeFactory.getDatatype(XSD.LONG), DBTermType.Category.INTEGER);
        NumberDBTermType floatType = new NumberDBTermType("FLOAT", rootAncestry, typeFactory.getDatatype(XSD.FLOAT), DBTermType.Category.FLOAT_DOUBLE);
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        map.put(TEXT_STR, new SparkStringDBTermType(TEXT_STR, "string", rootAncestry, xsdString));
        map.put(BYTE_STR, byteType);
        map.put("TINYINT", byteType);
        map.put(SHORT_STR, shortType);
        map.put("SMALLINT", shortType);
        map.put("INT", intType);
        map.put("INTEGER", intType);
        map.put(LONG_STR, longType);
        map.put("BIGINT", longType);
        map.put("FLOAT", floatType);
        map.put("REAL", floatType);
        map.put(DEC_STR, (DBTermType)map.get("DECIMAL"));
        SimpleRDF factory = new SimpleRDF();
        RDFDatatype xsdNonNegInt = typeFactory.getDatatype(factory.createIRI(XSDDatatype.XSDnonNegativeInteger.getURI()));
        return map;
    }

    public DBTermType getDBStringType() {
        return super.getDBStringType();
    }

    private static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createSparkSQLCodeMap() {
        Map map = SparkDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.STRING, TEXT_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.HEXBINARY, "BINARY");
        return ImmutableMap.copyOf((Map)map);
    }

    public Optional<String> getDBNaNLexicalValue() {
        return Optional.empty();
    }

    static class NumberDBTermType
    extends DBTermTypeImpl {
        private final String castName;
        @Nullable
        private final RDFDatatype rdfDatatype;
        private final DBTermType.Category category;

        protected NumberDBTermType(String name, TermTypeAncestry parentAncestry, RDFDatatype rdfDatatype, DBTermType.Category category) {
            super(name, parentAncestry, false, category);
            this.rdfDatatype = rdfDatatype;
            this.castName = name;
            this.category = category;
        }

        public Optional<RDFDatatype> getNaturalRDFDatatype() {
            return Optional.ofNullable(this.rdfDatatype);
        }

        public boolean isNeedingIRISafeEncoding() {
            return false;
        }

        public boolean areEqualitiesStrict() {
            return this.category == DBTermType.Category.INTEGER;
        }

        public Optional<Boolean> areEqualitiesStrict(DBTermType otherType) {
            return Optional.of(otherType.getCategory() == DBTermType.Category.INTEGER);
        }

        public boolean areEqualitiesBetweenTwoDBAttributesStrict() {
            return true;
        }

        public String getCastName() {
            return this.castName;
        }
    }

    static class SparkStringDBTermType
    extends StringDBTermType {
        protected SparkStringDBTermType(String name, String castName, TermTypeAncestry parentAncestry, RDFDatatype xsdStringDatatype) {
            super(name, castName, parentAncestry, xsdStringDatatype);
        }
    }
}

