/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.ontop;

import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.impl.QuotedIDImpl;
import it.unibz.inf.ontop.dbschema.impl.SQLStandardQuotedIDFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;

public class SparkQuotedIDFactory
extends SQLStandardQuotedIDFactory {
    Constructor<QuotedIDImpl> constructor;
    private boolean caseSensitiveTableNames;
    private static final String SQL_QUOTATION_STRING = "`";

    public SparkQuotedIDFactory() {
        try {
            this.constructor = QuotedIDImpl.class.getDeclaredConstructor(String.class, String.class, Boolean.TYPE);
            this.constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private QuotedIDImpl newQuotedID(@Nonnull String id, String quoteString, boolean caseSensitive) {
        try {
            return this.constructor.newInstance(id, quoteString, caseSensitive);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected QuotedID createFromString(@Nonnull String s) {
        if (s.startsWith(SQL_QUOTATION_STRING) && s.endsWith(SQL_QUOTATION_STRING)) {
            return this.newQuotedID(s.substring(1, s.length() - 1), SQL_QUOTATION_STRING, this.caseSensitiveTableNames);
        }
        return this.newQuotedID(s, SQL_QUOTATION_STRING, this.caseSensitiveTableNames);
    }

    public String getIDQuotationString() {
        return SQL_QUOTATION_STRING;
    }
}

