/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.ontop;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.HashBasedTable;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableTable;
import it.unibz.inf.ontop.com.google.common.collect.Table;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolSerializer;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractSQLDBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;
import net.sansa_stack.query.spark.ontop.DBBooleanFunctionSymbolWithSerializerImpl;
import net.sansa_stack.query.spark.ontop.ForcingFloatingDBAvgFunctionSymbolImpl;
import net.sansa_stack.query.spark.ontop.NullRejectingDBConcatFunctionSymbol;
import net.sansa_stack.query.spark.ontop.NullToleratingDBConcatFunctionSymbol;
import net.sansa_stack.query.spark.ontop.SparkEncodeURLorIRIFunctionSymbolImpl;
import net.sansa_stack.query.spark.ontop.SparkNullIgnoringDBGroupConcatFunctionSymbol;
import net.sansa_stack.query.spark.ontop.UnaryDBFunctionSymbolWithSerializerImpl;

public class SparkSQLDBFunctionSymbolFactory
extends AbstractSQLDBFunctionSymbolFactory {
    private static final String UUID_STR = "UUID";
    private static final String REGEXP_LIKE_STR = "RLIKE";
    private static final String UNSUPPORTED_MSG = "Not supported by Spark";

    @Inject
    private SparkSQLDBFunctionSymbolFactory(TypeFactory typeFactory) {
        super(SparkSQLDBFunctionSymbolFactory.createSparkRegularFunctionTable(typeFactory), typeFactory);
    }

    protected static ImmutableTable<String, Integer, DBFunctionSymbol> createSparkRegularFunctionTable(TypeFactory typeFactory) {
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        DBTermType dbBooleanType = dbTypeFactory.getDBBooleanType();
        DBTermType abstractRootDBType = dbTypeFactory.getAbstractRootDBType();
        HashBasedTable table = HashBasedTable.create((Table)SparkSQLDBFunctionSymbolFactory.createDefaultRegularFunctionTable((TypeFactory)typeFactory));
        return ImmutableTable.copyOf((Table)table);
    }

    protected String serializeContains(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(POSITION(%s,%s) > 0)", termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeStrBefore(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String before = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("LEFT(%s,LOCATE(%s,%s)-1)", str, before, str);
    }

    protected String serializeStrAfter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String after = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("SUBSTRING(%s,LOCATE(%s,%s) + LENGTH(%s), SIGN(LOCATE(%s,%s)) * LENGTH(%s))", str, after, str, after, after, str, str);
    }

    protected String serializeMD5(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("MD5(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA1(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("SHA1(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA256(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("SHA2(%s,256)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA512(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("SHA2(%s,512)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeTz(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    protected DBConcatFunctionSymbol createNullRejectingDBConcat(int arity) {
        return new NullRejectingDBConcatFunctionSymbol("||", arity, this.dbStringType, this.abstractRootDBType, true);
    }

    protected DBConcatFunctionSymbol createDBConcatOperator(int arity) {
        return this.getNullRejectingDBConcat(arity);
    }

    protected DBConcatFunctionSymbol createRegularDBConcat(int arity) {
        return new NullToleratingDBConcatFunctionSymbol("CONCAT", arity, this.dbStringType, this.abstractRootDBType, false);
    }

    protected Optional<DBFunctionSymbol> createCeilFunctionSymbol(DBTermType dbTermType) {
        return Optional.of(new UnaryDBFunctionSymbolWithSerializerImpl("CEIL", dbTermType, dbTermType, false, (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> String.format("CAST(CEIL(%s) AS %s)", termConverter.apply((ImmutableTerm)terms.get(0)), dbTermType.getCastName())));
    }

    protected Optional<DBFunctionSymbol> createFloorFunctionSymbol(DBTermType dbTermType) {
        return Optional.of(new UnaryDBFunctionSymbolWithSerializerImpl("FLOOR", dbTermType, dbTermType, false, (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> String.format("CAST(FLOOR(%s) AS %s)", termConverter.apply((ImmutableTerm)terms.get(0)), dbTermType.getCastName())));
    }

    protected Optional<DBFunctionSymbol> createRoundFunctionSymbol(DBTermType dbTermType) {
        return Optional.of(new UnaryDBFunctionSymbolWithSerializerImpl("ROUND", dbTermType, dbTermType, false, (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> String.format("CAST(ROUND(%s) AS %s)", termConverter.apply((ImmutableTerm)terms.get(0)), dbTermType.getCastName())));
    }

    protected String serializeDateTimeNorm(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("REPLACE(DATE_FORMAT(%s,'yyyy-MM-dd HH:mm:ss.SSSXXX'), ' ', 'T')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected DBFunctionSymbol createDBAvg(DBTermType inputType, boolean isDistinct) {
        if (inputType.equals(this.dbIntegerType)) {
            return new ForcingFloatingDBAvgFunctionSymbolImpl(inputType, this.dbDecimalType, isDistinct);
        }
        return super.createDBAvg(inputType, isDistinct);
    }

    protected String getUUIDNameInDialect() {
        return UUID_STR;
    }

    public DBBooleanFunctionSymbol getDBRegexpMatches2() {
        return new DBBooleanFunctionSymbolWithSerializerImpl("RLIKE2", (ImmutableList<TermType>)ImmutableList.of((Object)this.abstractRootDBType, (Object)this.abstractRootDBType), this.dbBooleanType, false, (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> String.format("(%s RLIKE %s)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1))));
    }

    public DBBooleanFunctionSymbol getDBRegexpMatches3() {
        return new DBBooleanFunctionSymbolWithSerializerImpl("RLIKE3", (ImmutableList<TermType>)ImmutableList.of((Object)this.abstractRootDBType, (Object)this.abstractRootDBType, (Object)this.abstractRootType), this.dbBooleanType, false, (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> {
            ImmutableFunctionalTerm flagTerm = termFactory.getDBReplace((ImmutableTerm)terms.get(2), (ImmutableTerm)termFactory.getDBStringConstant("s"), (ImmutableTerm)termFactory.getDBStringConstant("n"));
            ImmutableTerm extendedPatternTerm = termFactory.getNullRejectingDBConcatFunctionalTerm(ImmutableList.of((Object)termFactory.getDBStringConstant("(?"), (Object)flagTerm, (Object)termFactory.getDBStringConstant(")"), (Object)((ImmutableTerm)terms.get(1)))).simplify();
            return String.format("%s RLIKE %s", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply(extendedPatternTerm));
        });
    }

    protected DBFunctionSymbol createDBGroupConcat(DBTermType dbStringType, boolean isDistinct) {
        return new SparkNullIgnoringDBGroupConcatFunctionSymbol(dbStringType, isDistinct, (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> String.format("concat_ws(%s, %s(%s))", termConverter.apply((ImmutableTerm)terms.get(1)), isDistinct ? "collect_set" : "collect_list", termConverter.apply((ImmutableTerm)terms.get(0))));
    }

    protected DBFunctionSymbol createEncodeURLorIRI(boolean preserveInternationalChars) {
        return new SparkEncodeURLorIRIFunctionSymbolImpl(this.dbStringType, preserveInternationalChars);
    }
}

