/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.ontop;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSortedSet;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.generation.algebra.SQLExpression;
import it.unibz.inf.ontop.generation.algebra.SQLOrderComparator;
import it.unibz.inf.ontop.generation.algebra.SQLRelationVisitor;
import it.unibz.inf.ontop.generation.algebra.SQLTable;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SQLSerializationException;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.AttributeAliasFactory;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.SQLTermSerializer;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.StringUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sansa_stack.query.spark.ontop.SparkQuotedIDFactory;
import org.aksw.commons.sql.codec.api.SqlCodec;
import org.aksw.commons.sql.codec.util.SqlCodecUtils;
import org.aksw.r2rml.jena.sql.transform.SqlParseException;
import org.aksw.r2rml.sql.transform.SqlUtils;

public class SparkSelectFromWhereSerializer
extends DefaultSelectFromWhereSerializer {
    private final TermFactory termFactory;
    private static final String SELECT_FROM_WHERE_MODIFIERS_TEMPLATE = "SELECT %s%s\nFROM %s\n%s%s%s%s";
    public static boolean offsetEnabled = true;
    public static boolean orderByWorkaround = true;
    public static QuotedIDFactory quotedIdFactory = new SparkQuotedIDFactory();
    public static SqlCodec codecDoubleQuotes = SqlCodecUtils.createSqlCodecDoubleQuotes();
    public static SqlCodec codecBackTicks = SqlCodecUtils.createSqlCodecForApacheSpark();

    @Inject
    private SparkSelectFromWhereSerializer(TermFactory termFactory) {
        super((SQLTermSerializer)new SparkSQLTermSerializer(termFactory));
        this.termFactory = termFactory;
    }

    public static String reEncodeSpark(String rendering) {
        try {
            return SqlUtils.reencodeColumnName((String)rendering, (SqlCodec)codecDoubleQuotes, (SqlCodec)codecBackTicks);
        }
        catch (SqlParseException e) {
            e.printStackTrace();
            return rendering;
        }
    }

    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return (SelectFromWhereSerializer.QuerySerialization)selectFromWhere.acceptVisitor((SQLRelationVisitor)new DefaultSelectFromWhereSerializer.DefaultRelationVisitingSerializer(quotedIdFactory){
            final Deque<Boolean> handleOffsetStack;
            String rowNumCol;
            final Deque<Boolean> distinctStack;
            final Deque<ImmutableSortedSet<Variable>> projectionVariableStack;
            final Deque<ImmutableMap<Variable, QuotedID>> variableAliasesStack;
            {
                this.handleOffsetStack = new ArrayDeque<Boolean>();
                this.rowNumCol = "row_num";
                this.distinctStack = new ArrayDeque<Boolean>();
                this.projectionVariableStack = new ArrayDeque<ImmutableSortedSet<Variable>>();
                this.variableAliasesStack = new ArrayDeque<ImmutableMap<Variable, QuotedID>>();
            }

            private boolean needOffsetProcessed() {
                return Optional.ofNullable(this.handleOffsetStack.peek()).orElse(false);
            }

            public SelectFromWhereSerializer.QuerySerialization visit(SelectFromWhereWithModifiers selectFromWhere) {
                long offset = selectFromWhere.getOffset().orElse(0L);
                this.handleOffsetStack.push(offsetEnabled && offset > 0L);
                this.distinctStack.push(selectFromWhere.isDistinct());
                this.projectionVariableStack.push((ImmutableSortedSet<Variable>)selectFromWhere.getProjectedVariables());
                SelectFromWhereSerializer.QuerySerialization querySerialization = super.visit(selectFromWhere);
                if (this.needOffsetProcessed()) {
                    String query = querySerialization.getString();
                    Object offsetExpression = String.format("%s > %d", this.rowNumCol, offset);
                    long limit = selectFromWhere.getLimit().orElse(0L);
                    if (limit > 0L) {
                        offsetExpression = (String)offsetExpression + String.format(" AND %s < %d", this.rowNumCol, offset + limit);
                    }
                    String newQuery = String.format("WITH result AS (%s) SELECT * FROM result WHERE %s", query, offsetExpression);
                    querySerialization = new DefaultSelectFromWhereSerializer.QuerySerializationImpl(newQuery, querySerialization.getColumnIDs());
                }
                SelectFromWhereSerializer.QuerySerialization fromQuerySerialization = this.getSQLSerializationForChild(selectFromWhere.getFromSQLExpression());
                ImmutableMap<Variable, QuotedID> variableAliases = this.createVariableAliases((ImmutableSet<Variable>)selectFromWhere.getProjectedVariables());
                String distinctString = selectFromWhere.isDistinct() ? "DISTINCT " : "";
                ImmutableMap columnIDs = fromQuerySerialization.getColumnIDs();
                String projectionString = this.serializeProjection((ImmutableSortedSet<Variable>)selectFromWhere.getProjectedVariables(), variableAliases, (ImmutableSubstitution<? extends ImmutableTerm>)selectFromWhere.getSubstitution(), (ImmutableMap<Variable, QualifiedAttributeID>)columnIDs);
                String fromString = fromQuerySerialization.getString();
                String whereString = selectFromWhere.getWhereExpression().map(e -> SparkSelectFromWhereSerializer.this.sqlTermSerializer.serialize((ImmutableTerm)e, columnIDs)).map(s -> String.format("WHERE %s\n", s)).orElse("");
                String groupByString = this.serializeGroupBy(selectFromWhere.getGroupByVariables(), columnIDs);
                String orderByString = this.serializeOrderBy((ImmutableList<SQLOrderComparator>)selectFromWhere.getSortConditions(), (ImmutableMap<Variable, QualifiedAttributeID>)columnIDs, variableAliases, (ImmutableSubstitution<? extends ImmutableTerm>)selectFromWhere.getSubstitution());
                String sliceString = this.serializeSlice(selectFromWhere.getLimit(), selectFromWhere.getOffset());
                String sql = String.format(SparkSelectFromWhereSerializer.SELECT_FROM_WHERE_MODIFIERS_TEMPLATE, distinctString, projectionString, fromString, whereString, groupByString, orderByString, sliceString);
                RelationID alias = this.generateFreshViewAlias();
                return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(sql, this.attachRelationAlias(alias, variableAliases));
            }

            protected String serializeProjection(ImmutableSortedSet<Variable> projectedVariables, ImmutableMap<Variable, QuotedID> variableAliases, ImmutableSubstitution<? extends ImmutableTerm> substitution, ImmutableMap<Variable, QualifiedAttributeID> columnIDs) {
                this.variableAliasesStack.push(variableAliases);
                Object projection = super.serializeProjection(projectedVariables, variableAliases, substitution, columnIDs);
                if (this.needOffsetProcessed()) {
                    String sortExprStr = projectedVariables.stream().map(v -> SparkSelectFromWhereSerializer.this.sqlTermSerializer.serialize(Optional.ofNullable(substitution.get(v)).orElse((ImmutableTerm)v), columnIDs)).collect(Collectors.joining(", "));
                    projection = (String)projection + String.format(", row_number() over (order by %s) as %s", sortExprStr, this.rowNumCol);
                }
                return projection;
            }

            protected String serializeLimit(long limit, boolean noSortCondition) {
                if (limit < 0L) {
                    return "";
                }
                return String.format("LIMIT %d", limit);
            }

            protected String serializeLimitOffset(long limit, long offset, boolean noSortCondition) {
                if (limit == 0L) {
                    return "LIMIT 0";
                }
                if (limit < 0L) {
                    if (offset <= 0L) {
                        return "";
                    }
                    if (!offsetEnabled) {
                        throw new SQLSerializationException("OFFSET is not supported in Spark");
                    }
                    return "";
                }
                if (offset < 0L) {
                    return String.format("LIMIT %d", limit);
                }
                if (!offsetEnabled) {
                    throw new SQLSerializationException("OFFSET is not supported in Spark");
                }
                return "";
            }

            protected String serializeOffset(long offset, boolean noSortCondition) {
                if (offset < 0L) {
                    return "";
                }
                if (!offsetEnabled) {
                    throw new SQLSerializationException("OFFSET is not supported in Spark");
                }
                return "";
            }

            private String serializeSlice(Optional<Long> limit, Optional<Long> offset) {
                if (!limit.isPresent() && !offset.isPresent()) {
                    return "";
                }
                if (limit.isPresent() && offset.isPresent()) {
                    return this.serializeLimitOffset(limit.get(), offset.get(), true);
                }
                if (limit.isPresent()) {
                    return this.serializeLimit(limit.get(), true);
                }
                return this.serializeOffset(offset.get(), true);
            }

            protected String formatBinaryJoin(String operatorString, SelectFromWhereSerializer.QuerySerialization left, SelectFromWhereSerializer.QuerySerialization right, String onString) {
                return String.format("(%s\n %s \n%s %s)", left.getString(), operatorString, right.getString(), onString);
            }

            private ImmutableMap<Variable, QualifiedAttributeID> replaceRelationAlias(RelationID alias, ImmutableMap<Variable, QualifiedAttributeID> columnIDs) {
                return (ImmutableMap)columnIDs.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> new QualifiedAttributeID(alias, ((QualifiedAttributeID)e.getValue()).getAttribute())));
            }

            public SelectFromWhereSerializer.QuerySerialization visit(SQLTable sqlTable) {
                RelationID alias = this.generateFreshViewAlias();
                RelationDefinition relation = sqlTable.getRelationDefinition();
                String relationRendering = relation.getAtomPredicate().getName();
                relationRendering = SparkSelectFromWhereSerializer.reEncodeSpark(relationRendering);
                String sql = String.format("%s %s", relationRendering, alias.getSQLRendering());
                return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(sql, this.attachRelationAlias(alias, (ImmutableMap<Variable, QuotedID>)((ImmutableMap)sqlTable.getArgumentMap().entrySet().stream().collect(ImmutableCollectors.toMap(e -> (Variable)e.getValue(), e -> relation.getAttribute((Integer)e.getKey() + 1).getID())))));
            }

            ImmutableMap<Variable, QualifiedAttributeID> attachRelationAlias(RelationID alias, ImmutableMap<Variable, QuotedID> variableAliases) {
                return (ImmutableMap)variableAliases.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> new QualifiedAttributeID(alias, (QuotedID)e.getValue())));
            }

            private ImmutableMap<Variable, QuotedID> createVariableAliases(ImmutableSet<Variable> variables) {
                AttributeAliasFactory aliasFactory = this.createAttributeAliasFactory();
                return (ImmutableMap)variables.stream().collect(ImmutableCollectors.toMap(Function.identity(), v -> aliasFactory.createAttributeAlias(v.getName())));
            }

            private SelectFromWhereSerializer.QuerySerialization getSQLSerializationForChild(SQLExpression expression) {
                if (expression instanceof SelectFromWhereWithModifiers) {
                    SelectFromWhereSerializer.QuerySerialization serialization = (SelectFromWhereSerializer.QuerySerialization)expression.acceptVisitor((SQLRelationVisitor)this);
                    RelationID alias = this.generateFreshViewAlias();
                    String sql = String.format("(%s) %s", serialization.getString(), alias.getSQLRendering());
                    return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(sql, this.replaceRelationAlias(alias, (ImmutableMap<Variable, QualifiedAttributeID>)serialization.getColumnIDs()));
                }
                return (SelectFromWhereSerializer.QuerySerialization)expression.acceptVisitor((SQLRelationVisitor)this);
            }

            protected String serializeOrderBy(ImmutableList<SQLOrderComparator> sortConditions, ImmutableMap<Variable, QualifiedAttributeID> columnIDs, ImmutableMap<Variable, QuotedID> variableAliases, ImmutableSubstitution<? extends ImmutableTerm> substitution) {
                if (sortConditions.isEmpty()) {
                    return "";
                }
                String conditionString = sortConditions.stream().map(c -> this.serializeOrderByTerm((ImmutableTerm)c.getTerm(), columnIDs, substitution) + (c.isAscending() ? " NULLS FIRST" : " DESC NULLS LAST")).collect(Collectors.joining(", "));
                return String.format("ORDER BY %s\n", conditionString);
            }

            private String serializeOrderByTerm(ImmutableTerm term, ImmutableMap<Variable, QualifiedAttributeID> columnIDs, ImmutableSubstitution<? extends ImmutableTerm> substitution) throws SQLSerializationException {
                String result = this.checkSubstitutionMap(term, substitution);
                if (result == "") {
                    result = this.checkColumnID(term, columnIDs);
                    return result;
                }
                return result;
            }

            private String checkSubstitutionMap(ImmutableTerm term, ImmutableSubstitution<? extends ImmutableTerm> substitution) {
                for (Map.Entry entry : substitution.getImmutableMap().entrySet()) {
                    if (!((ImmutableTerm)entry.getValue()).equals(term)) continue;
                    return "`" + ((Variable)entry.getKey()).getName() + "`";
                }
                return "";
            }

            private String checkColumnID(ImmutableTerm term, ImmutableMap<Variable, QualifiedAttributeID> columnIDs) throws SQLSerializationException {
                if (term instanceof Constant) {
                    return this.serializeConstant((Constant)term);
                }
                if (term instanceof Variable) {
                    for (Map.Entry entry : columnIDs.entrySet()) {
                        if (!((QualifiedAttributeID)entry.getValue()).equals(columnIDs.get((Object)term))) continue;
                        return "`" + ((Variable)entry.getKey()).getName() + "`";
                    }
                    throw new SQLSerializationException(String.format("The variable %s does not appear in the columnIDs", term));
                }
                return Optional.of(term).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof DBFunctionSymbol).map(t -> ((DBFunctionSymbol)t.getFunctionSymbol()).getNativeDBString(t.getTerms(), t2 -> this.checkColumnID((ImmutableTerm)t2, columnIDs), SparkSelectFromWhereSerializer.this.termFactory)).orElseThrow(() -> new SQLSerializationException("Only DBFunctionSymbols must be provided to a SQLTermSerializer"));
            }

            private String serializeConstant(Constant constant) {
                if (constant.isNull()) {
                    return constant.getValue();
                }
                if (!(constant instanceof DBConstant)) {
                    throw new SQLSerializationException("Only DBConstants or NULLs are expected in sub-tree to be translated into SQL");
                }
                return this.serializeDBConstant((DBConstant)constant);
            }

            protected String serializeDBConstant(DBConstant constant) {
                DBTermType dbType = constant.getType();
                switch (dbType.getCategory()) {
                    case DECIMAL: 
                    case FLOAT_DOUBLE: {
                        return this.castFloatingConstant(constant.getValue(), dbType);
                    }
                    case INTEGER: 
                    case BOOLEAN: {
                        return constant.getValue();
                    }
                }
                return this.serializeStringConstant(constant.getValue());
            }

            protected String castFloatingConstant(String value, DBTermType dbType) {
                return String.format("CAST(%s AS %s)", value, dbType.getCastName());
            }

            protected String serializeStringConstant(String constant) {
                return "'" + constant.replace("'", "''") + "'";
            }
        });
    }

    protected static class SparkSQLTermSerializer
    extends DefaultSelectFromWhereSerializer.DefaultSQLTermSerializer {
        private static final ImmutableMap<Character, String> BACKSLASH = ImmutableMap.of((Object)Character.valueOf('\\'), (Object)"\\\\");

        protected SparkSQLTermSerializer(TermFactory termFactory) {
            super(termFactory);
        }

        public String serialize(ImmutableTerm term, ImmutableMap<Variable, QualifiedAttributeID> columnIDs) throws SQLSerializationException {
            if (term instanceof Variable) {
                return Optional.ofNullable((QualifiedAttributeID)columnIDs.get((Object)term)).map(a -> {
                    String rendering = a.getSQLRendering();
                    rendering = SparkSelectFromWhereSerializer.reEncodeSpark(rendering);
                    return rendering;
                }).orElseThrow(() -> new SQLSerializationException(String.format("The variable %s does not appear in the columnIDs", term)));
            }
            return super.serialize(term, columnIDs);
        }

        private String serializeConstant(Constant constant) {
            if (constant.isNull()) {
                return constant.getValue();
            }
            if (!(constant instanceof DBConstant)) {
                throw new SQLSerializationException("Only DBConstants or NULLs are expected in sub-tree to be translated into SQL");
            }
            return this.serializeDBConstant((DBConstant)constant);
        }

        protected String serializeDBConstant(DBConstant constant) {
            DBTermType dbType = constant.getType();
            switch (dbType.getCategory()) {
                case DECIMAL: 
                case FLOAT_DOUBLE: {
                    return this.castFloatingConstant(constant.getValue(), dbType);
                }
                case INTEGER: 
                case BOOLEAN: {
                    return constant.getValue();
                }
            }
            return this.serializeStringConstant(constant.getValue());
        }

        protected String castFloatingConstant(String value, DBTermType dbType) {
            return String.format("CAST(%s AS %s)", value, dbType.getCastName());
        }

        protected String serializeStringConstant(String constant) {
            return StringUtils.encode((String)super.serializeStringConstant(constant), BACKSLASH);
        }
    }
}

