/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.ontop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.nio.file.Paths;
import net.sansa_stack.query.spark.ontop.VerticalPartitioner;
import net.sansa_stack.query.spark.ontop.VerticalPartitioner$;
import net.sansa_stack.query.spark.ontop.VerticalPartitioner$Config$;
import net.sansa_stack.rdf.common.partition.core.RdfPartitionStateDefault;
import net.sansa_stack.rdf.common.partition.core.RdfPartitioner;
import net.sansa_stack.rdf.common.partition.core.RdfPartitionerComplex;
import net.sansa_stack.rdf.common.partition.core.RdfPartitionerComplex$;
import net.sansa_stack.rdf.common.partition.core.TermType$;
import net.sansa_stack.rdf.common.partition.r2rml.R2rmlUtils$;
import net.sansa_stack.rdf.common.partition.utils.SQLUtils$;
import net.sansa_stack.rdf.spark.io.package;
import net.sansa_stack.rdf.spark.io.package$;
import net.sansa_stack.rdf.spark.partition.core.BlankNodeStrategy$;
import net.sansa_stack.rdf.spark.partition.core.RdfPartitionUtilsSpark$;
import net.sansa_stack.rdf.spark.partition.core.SparkTableGenerator;
import net.sansa_stack.rdf.spark.partition.core.SparkTableGenerator$;
import org.aksw.commons.sql.codec.api.SqlCodec;
import org.aksw.commons.sql.codec.util.SqlCodecUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.Types;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scopt.OptionParser;
import scopt.Read;
import scopt.Read$;

public final class VerticalPartitioner$ {
    public static VerticalPartitioner$ MODULE$;
    private final String warehouseLocation;
    private final Read<Enumeration.Value> bNodeRead;
    private final OptionParser<VerticalPartitioner.Config> parser;
    private final SqlCodec sqlCodec;

    static {
        new VerticalPartitioner$();
    }

    public String warehouseLocation() {
        return this.warehouseLocation;
    }

    public Read<Enumeration.Value> bNodeRead() {
        return this.bNodeRead;
    }

    public OptionParser<VerticalPartitioner.Config> parser() {
        return this.parser;
    }

    public void main(String[] args) {
        Option option = this.parser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new VerticalPartitioner.Config(VerticalPartitioner$Config$.MODULE$.apply$default$1(), VerticalPartitioner$Config$.MODULE$.apply$default$2(), VerticalPartitioner$Config$.MODULE$.apply$default$3(), VerticalPartitioner$Config$.MODULE$.apply$default$4(), VerticalPartitioner$Config$.MODULE$.apply$default$5(), VerticalPartitioner$Config$.MODULE$.apply$default$6(), VerticalPartitioner$Config$.MODULE$.apply$default$7(), VerticalPartitioner$Config$.MODULE$.apply$default$8(), VerticalPartitioner$Config$.MODULE$.apply$default$9(), VerticalPartitioner$Config$.MODULE$.apply$default$10(), VerticalPartitioner$Config$.MODULE$.apply$default$11(), VerticalPartitioner$Config$.MODULE$.apply$default$12(), VerticalPartitioner$Config$.MODULE$.apply$default$13(), VerticalPartitioner$Config$.MODULE$.apply$default$14()));
        if (option instanceof Some) {
            Some some = (Some)option;
            VerticalPartitioner.Config config = (VerticalPartitioner.Config)some.value();
            String string = config.mode();
            String string2 = "partitioner";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.run(config);
                return;
            }
            String string3 = config.mode();
            String string4 = "show-tables";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                this.showTables(config.databaseName());
                return;
            }
            return;
        }
    }

    public SqlCodec sqlCodec() {
        return this.sqlCodec;
    }

    private void showTables(String databaseName) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("vpartitioner").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.kryo.registrator", String.join((CharSequence)", ", "net.sansa_stack.rdf.spark.io.JenaKryoRegistrator")).config("spark.sql.cbo.enabled", true).config("spark.sql.statistics.histogram.enabled", true).enableHiveSupport().getOrCreate();
        spark.sql(new StringBuilder(4).append("use ").append(this.sqlCodec().forSchemaName().encode((Object)databaseName)).toString());
        spark.sql("show tables").show(1000, false);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spark.sql("show tables").select("tableName", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).foreach((Function1 & Serializable & scala.Serializable)row -> {
            VerticalPartitioner$.$anonfun$showTables$1(spark, row);
            return BoxedUnit.UNIT;
        });
        spark.stop();
    }

    private void run(VerticalPartitioner.Config config) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("vpartitioner").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.kryo.registrator", String.join((CharSequence)", ", "net.sansa_stack.rdf.spark.io.JenaKryoRegistrator")).config("spark.sql.warehouse.dir", config.outputPath().toString()).config("spark.sql.cbo.enabled", true).config("spark.sql.statistics.histogram.enabled", true).config("spark.sql.legacy.parquet.datetimeRebaseModeInWrite", SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED().toString()).enableHiveSupport().getOrCreate();
        boolean dbExists = spark.catalog().databaseExists(config.databaseName());
        if (!(!dbExists || config.saveAppend() || config.saveOverwrite() || config.saveAppend() || config.dropDatabase())) {
            System.err.println("Error: database already exists. Please use CLI flags --drop-db or --overwrite-db to continue");
            return;
        }
        package.RDFReader qual$1 = package$.MODULE$.RDFReader(spark);
        boolean x$1 = qual$1.ntriples$default$1();
        ObjectRef triplesRDD = ObjectRef.create((Object)((RDD)qual$1.ntriples(x$1).apply((Object)config.inputPath().toString())));
        if (config.schemaPath() != null) {
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            OWLOntology ont = man.loadOntologyFromOntologyDocument(IRI.create((URI)config.schemaPath()));
            Set objectProperties = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(ont.getObjectPropertiesInSignature().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toStringID()).toSet();
            Set dataProperties = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(ont.getDataPropertiesInSignature().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toStringID()).toSet();
            Set schemaProperties = (Set)objectProperties.$plus$plus((GenTraversableOnce)dataProperties).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{RDF.type.getURI()})));
            triplesRDD.elem = ((RDD)triplesRDD.elem).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)schemaProperties.contains((Object)t.getPredicate().getURI())));
        }
        ((RDD)triplesRDD.elem).cache();
        Predef$.MODULE$.println((Object)"computing partitions ...");
        RdfPartitionerComplex partitioner = RdfPartitionerComplex$.MODULE$.apply();
        Map partitions = (Map)this.time((Function0 & Serializable & scala.Serializable)() -> RdfPartitionUtilsSpark$.MODULE$.partitionGraph((RDD)triplesRDD$1.elem, (RdfPartitioner)partitioner, RdfPartitionUtilsSpark$.MODULE$.partitionGraph$default$3(), ClassTag$.MODULE$.apply(RdfPartitionStateDefault.class)));
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("#partitions: ").append(partitions.size()).toString());
        Predef$.MODULE$.println((Object)partitions.mkString("\n"));
        String dbName = (String)this.sqlCodec().forSchemaName().encode((Object)config.databaseName());
        Object object = config.dropDatabase() ? spark.sql(new StringBuilder(32).append("DROP DATABASE IF EXISTS ").append(dbName).append(" CASCADE").toString()) : BoxedUnit.UNIT;
        spark.sql(new StringBuilder(30).append("create database if not exists ").append(dbName).toString());
        spark.sql(new StringBuilder(4).append("use ").append(dbName).toString());
        SaveMode saveMode = config.saveIgnore() ? SaveMode.Ignore : (config.saveAppend() ? SaveMode.Append : (config.saveOverwrite() ? SaveMode.Overwrite : SaveMode.ErrorIfExists));
        Predef$.MODULE$.println((Object)"creating Spark tables ...");
        Function1 & Serializable & scala.Serializable tableNameFn = (Function1 & Serializable & scala.Serializable)p -> SQLUtils$.MODULE$.encodeTablename(SQLUtils$.MODULE$.createDefaultTableName(p));
        SparkTableGenerator qual$2 = SparkTableGenerator$.MODULE$.apply(spark, Option$.MODULE$.apply((Object)config.databaseName()), config.blankNodeStrategy(), false, config.computeStatistics());
        RdfPartitionerComplex x$2 = partitioner;
        Map x$3 = partitions;
        Function1 & Serializable & scala.Serializable x$4 = tableNameFn;
        boolean x$5 = qual$2.createAndRegisterSparkTables$default$4();
        Seq partitionToTableName = qual$2.createAndRegisterSparkTables((RdfPartitioner)x$2, x$3, (Function1)x$4, x$5);
        Option typeTableName = partitionToTableName.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)VerticalPartitioner$.$anonfun$run$6(x0$1))).map((Function1 & Serializable & scala.Serializable)x$9 -> (String)x$9._2());
        Seq dateDatatypes = (Seq)((TraversableLike)new .colon.colon((Object)XSD.date, (List)new .colon.colon((Object)XSD.gYear, (List)new .colon.colon((Object)XSD.gMonthDay, (List)new .colon.colon((Object)XSD.gDay, (List)new .colon.colon((Object)XSD.gMonth, (List)new .colon.colon((Object)XSD.gYearMonth, (List)Nil$.MODULE$))))))).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getURI(), Seq$.MODULE$.canBuildFrom());
        partitionToTableName.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            VerticalPartitioner$.$anonfun$run$9(spark, typeTableName, dateDatatypes, saveMode, x0$2);
            return BoxedUnit.UNIT;
        });
        String path = (String)config.mappingsFile().getOrElse((Function0 & Serializable & scala.Serializable)() -> ((Object)Paths.get(config.outputPath().toString(), new StringBuilder(19).append(config.databaseName()).append("-r2rml-mappings.ttl").toString()).toAbsolutePath()).toString());
        Model model = ModelFactory.createDefaultModel();
        R2rmlUtils$.MODULE$.createR2rmlMappings((RdfPartitioner)partitioner, partitions.keySet().toSeq(), (Function1)tableNameFn, Option$.MODULE$.apply((Object)config.databaseName()), SqlCodecUtils.createSqlCodecDefault(), model, true);
        model.write((OutputStream)new FileOutputStream(new File(path)), "TURTLE", "http://www.w3.org/ns/r2rml#");
        Predef$.MODULE$.println((Object)new StringBuilder(31).append("R2RML mapping model written to ").append(path).toString());
        spark.stop();
    }

    private Tuple2<Object, Object> estimatePartitioningColumns(Dataset<Row> df) {
        long sCnt = df.select("s", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count();
        long oCnt = df.select("o", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count();
        return new Tuple2.mcJJ.sp(sCnt, oCnt);
    }

    private void createSparkTable(SparkSession session, RdfPartitioner<RdfPartitionStateDefault> partitioner, RdfPartitionStateDefault p, RDD<Row> rdd, SaveMode saveMode, Enumeration.Value blankNodeStrategy, boolean computeStatistics, String path, boolean usePartitioning, int partitioningThreshold) {
        block7: {
            Dataset df;
            String tableName;
            block6: {
                tableName = (String)this.sqlCodec().forTableName().encode((Object)SQLUtils$.MODULE$.createDefaultTableName(p));
                Types.TypeApi scalaSchema = partitioner.determineLayout((Object)p).schema();
                StructType sparkSchema = (StructType)ScalaReflection$.MODULE$.schemaFor(scalaSchema).dataType();
                df = session.createDataFrame(rdd, sparkSchema);
                if (session.catalog().tableExists(tableName)) {
                    SaveMode saveMode2 = saveMode;
                    SaveMode saveMode3 = SaveMode.ErrorIfExists;
                    if (!(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null)) {
                        throw new RuntimeException(new StringBuilder(76).append("ERROR: table ").append(tableName).append(" already exists. Please enable a save mode to handle this case.").toString());
                    }
                }
                if (!session.catalog().tableExists(tableName)) break block6;
                SaveMode saveMode4 = saveMode;
                SaveMode saveMode5 = SaveMode.Ignore;
                if (!(saveMode4 == null ? saveMode5 != null : !saveMode4.equals(saveMode5))) break block7;
            }
            Predef$.MODULE$.println((Object)new StringBuilder(21).append("creating Spark table ").append(tableName).toString());
            this.time((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                DataFrameWriter writer = df.write().mode(saveMode).format("parquet");
                if (usePartitioning) {
                    Tuple2<Object, Object> tuple2 = MODULE$.estimatePartitioningColumns((Dataset<Row>)df);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    long sCnt = tuple2._1$mcJ$sp();
                    long oCnt = tuple2._2$mcJ$sp();
                    Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(sCnt, oCnt);
                    long sCnt2 = sp2._1$mcJ$sp();
                    long oCnt2 = sp2._2$mcJ$sp();
                    double ratio = (double)oCnt2 / (double)sCnt2;
                    Predef$.MODULE$.println((Object)new StringBuilder(41).append("partition estimates: |s|=").append(sCnt2).append(" |o|=").append(oCnt2).append(" ratio o/s=").append(ratio).toString());
                    if (sCnt2 <= (long)partitioningThreshold) {
                        writer = writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"}));
                    } else if (oCnt2 <= (long)partitioningThreshold && ratio < 0.01) {
                        writer = writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o"}));
                    }
                }
                writer.saveAsTable(tableName);
            });
            if (computeStatistics) {
                Predef$.MODULE$.println((Object)new StringBuilder(31).append("computing statistics for table ").append(tableName).toString());
                session.sql(new StringBuilder(52).append("ANALYZE TABLE `").append(tableName).append("` COMPUTE STATISTICS FOR COLUMNS s, o").toString());
                return;
            }
            return;
        }
    }

    public <R> R time(Function0<R> block) {
        long t0 = System.currentTimeMillis();
        Object result = block.apply();
        long t1 = System.currentTimeMillis();
        Predef$.MODULE$.println((Object)new StringBuilder(16).append("Elapsed time: ").append(t1 - t0).append("ms").toString());
        return (R)result;
    }

    public static final /* synthetic */ void $anonfun$showTables$1(SparkSession spark$1, Row row) {
        spark$1.sql(new StringBuilder(18).append("describe extended ").append(row.getString(0)).toString()).show(21, false);
        spark$1.sql(new StringBuilder(15).append("DESC FORMATTED ").append(row.getString(0)).toString()).show(false);
        spark$1.sql(new StringBuilder(14).append("select * from ").append(row.getString(0)).toString()).show(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$run$6(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        RdfPartitionStateDefault p = (RdfPartitionStateDefault)tuple2._1();
        String string = p.predicate();
        String string2 = RDF.type.getURI();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (p.subjectType() != TermType$.MODULE$.IRI()) return false;
        if (p.objectType() != TermType$.MODULE$.IRI()) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$run$9(SparkSession spark$2, Option typeTableName$1, Seq dateDatatypes$1, SaveMode saveMode$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            RdfPartitionStateDefault p = (RdfPartitionStateDefault)tuple2._1();
            String tableName = (String)tuple2._2();
            try {
                Dataset df = spark$2.table((String)MODULE$.sqlCodec().forTableName().encode((Object)tableName));
                DataFrameWriter writer = df.write();
                if (typeTableName$1.contains((Object)tableName)) {
                    writer = df.repartition((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("o")})).sortWithinPartitions((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("o"), functions$.MODULE$.col("s")})).write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o"}));
                }
                if (p.objectType() == TermType$.MODULE$.LITERAL()) {
                    if (p.languages().size() >= 2) {
                        writer = df.repartition((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("l")})).sortWithinPartitions((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("l"), functions$.MODULE$.col("o"), functions$.MODULE$.col("s")})).write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l"}));
                    }
                    if (dateDatatypes$1.contains((Object)p.datatype())) {
                        writer = df.repartition((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("o")})).sortWithinPartitions((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("o"), functions$.MODULE$.col("s")})).write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o"}));
                    }
                }
                writer.mode(saveMode$1).format("parquet").saveAsTable(SQLUtils$.MODULE$.encodeTablename(tableName));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                System.err.println(new StringBuilder(50).append("failed to write table ").append(tableName).append(" as Parquet to disk. Reason:").toString());
                e.printStackTrace();
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private VerticalPartitioner$() {
        MODULE$ = this;
        this.warehouseLocation = new File("spark-warehouse").getAbsolutePath();
        this.bNodeRead = Read$.MODULE$.reads((Function1 & Serializable & scala.Serializable)s -> BlankNodeStrategy$.MODULE$.withName(s));
        this.parser = new OptionParser<VerticalPartitioner.Config>(){

            public static final /* synthetic */ VerticalPartitioner.Config $anonfun$new$5(boolean x, VerticalPartitioner.Config c) {
                boolean x$43 = x;
                URI x$44 = c.copy$default$1();
                URI x$45 = c.copy$default$2();
                URI x$46 = c.copy$default$3();
                Enumeration.Value x$47 = c.copy$default$4();
                String x$48 = c.copy$default$6();
                boolean x$49 = c.copy$default$7();
                Option<String> x$50 = c.copy$default$8();
                boolean x$51 = c.copy$default$9();
                boolean x$52 = c.copy$default$10();
                boolean x$53 = c.copy$default$11();
                boolean x$54 = c.copy$default$12();
                int x$55 = c.copy$default$13();
                String x$56 = c.copy$default$14();
                return c.copy(x$44, x$45, x$46, x$47, x$43, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56);
            }

            public static final /* synthetic */ VerticalPartitioner.Config $anonfun$new$13(int x, VerticalPartitioner.Config c) {
                int x$155 = x;
                URI x$156 = c.copy$default$1();
                URI x$157 = c.copy$default$2();
                URI x$158 = c.copy$default$3();
                Enumeration.Value x$159 = c.copy$default$4();
                boolean x$160 = c.copy$default$5();
                String x$161 = c.copy$default$6();
                boolean x$162 = c.copy$default$7();
                Option<String> x$163 = c.copy$default$8();
                boolean x$164 = c.copy$default$9();
                boolean x$165 = c.copy$default$10();
                boolean x$166 = c.copy$default$11();
                boolean x$167 = c.copy$default$12();
                String x$168 = c.copy$default$14();
                return c.copy(x$156, x$157, x$158, x$159, x$160, x$161, x$162, x$163, x$164, x$165, x$166, x$167, x$155, x$168);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"vertical partitioner", "0.1"}));
                this.opt('i', "input", Read$.MODULE$.uriRead()).required().action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((URI)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13(), c.copy$default$14())).text("path to input data");
                this.opt('o', "output", Read$.MODULE$.uriRead()).required().action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    URI x$1 = x;
                    URI x$2 = c.copy$default$1();
                    URI x$3 = c.copy$default$3();
                    Enumeration.Value x$4 = c.copy$default$4();
                    boolean x$5 = c.copy$default$5();
                    String x$6 = c.copy$default$6();
                    boolean x$7 = c.copy$default$7();
                    Option<String> x$8 = c.copy$default$8();
                    boolean x$9 = c.copy$default$9();
                    boolean x$10 = c.copy$default$10();
                    boolean x$11 = c.copy$default$11();
                    boolean x$12 = c.copy$default$12();
                    int x$13 = c.copy$default$13();
                    String x$14 = c.copy$default$14();
                    return c.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14);
                }).text("path to output directory");
                this.opt('s', "schema", Read$.MODULE$.uriRead()).optional().action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    URI x$15 = x;
                    URI x$16 = c.copy$default$1();
                    URI x$17 = c.copy$default$2();
                    Enumeration.Value x$18 = c.copy$default$4();
                    boolean x$19 = c.copy$default$5();
                    String x$20 = c.copy$default$6();
                    boolean x$21 = c.copy$default$7();
                    Option<String> x$22 = c.copy$default$8();
                    boolean x$23 = c.copy$default$9();
                    boolean x$24 = c.copy$default$10();
                    boolean x$25 = c.copy$default$11();
                    boolean x$26 = c.copy$default$12();
                    int x$27 = c.copy$default$13();
                    String x$28 = c.copy$default$14();
                    return c.copy(x$16, x$17, x$15, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28);
                }).text("an optional file containing the OWL schema to process only object and data properties");
                this.opt('b', "blanknode-strategy", VerticalPartitioner$.MODULE$.bNodeRead()).optional().action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    Enumeration.Value x$29 = x;
                    URI x$30 = c.copy$default$1();
                    URI x$31 = c.copy$default$2();
                    URI x$32 = c.copy$default$3();
                    boolean x$33 = c.copy$default$5();
                    String x$34 = c.copy$default$6();
                    boolean x$35 = c.copy$default$7();
                    Option<String> x$36 = c.copy$default$8();
                    boolean x$37 = c.copy$default$9();
                    boolean x$38 = c.copy$default$10();
                    boolean x$39 = c.copy$default$11();
                    boolean x$40 = c.copy$default$12();
                    int x$41 = c.copy$default$13();
                    String x$42 = c.copy$default$14();
                    return c.copy(x$30, x$31, x$32, x$29, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42);
                }).text("how blank nodes are handled during partitioning (TABLE, COLUMN)");
                this.opt('s', "stats", Read$.MODULE$.booleanRead()).optional().action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$5(BoxesRunTime.unboxToBoolean((Object)x), c)).text("compute statistics for the Parquet tables");
                this.opt("database", Read$.MODULE$.stringRead()).optional().abbr("db").action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$57 = x;
                    URI x$58 = c.copy$default$1();
                    URI x$59 = c.copy$default$2();
                    URI x$60 = c.copy$default$3();
                    Enumeration.Value x$61 = c.copy$default$4();
                    boolean x$62 = c.copy$default$5();
                    boolean x$63 = c.copy$default$7();
                    Option<String> x$64 = c.copy$default$8();
                    boolean x$65 = c.copy$default$9();
                    boolean x$66 = c.copy$default$10();
                    boolean x$67 = c.copy$default$11();
                    boolean x$68 = c.copy$default$12();
                    int x$69 = c.copy$default$13();
                    String x$70 = c.copy$default$14();
                    return c.copy(x$58, x$59, x$60, x$61, x$62, x$57, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$70);
                }).text("the database name registered in Spark metadata. Default: 'Default'");
                this.opt("drop-db", Read$.MODULE$.unitRead()).optional().action((Function2 & Serializable & scala.Serializable)(x$1, c) -> {
                    boolean x$71 = true;
                    URI x$72 = c.copy$default$1();
                    URI x$73 = c.copy$default$2();
                    URI x$74 = c.copy$default$3();
                    Enumeration.Value x$75 = c.copy$default$4();
                    boolean x$76 = c.copy$default$5();
                    String x$77 = c.copy$default$6();
                    Option<String> x$78 = c.copy$default$8();
                    boolean x$79 = c.copy$default$9();
                    boolean x$80 = c.copy$default$10();
                    boolean x$81 = c.copy$default$11();
                    boolean x$82 = c.copy$default$12();
                    int x$83 = c.copy$default$13();
                    String x$84 = c.copy$default$14();
                    return c.copy(x$72, x$73, x$74, x$75, x$76, x$77, x$71, x$78, x$79, x$80, x$81, x$82, x$83, x$84);
                }).text("if to drop an existing database");
                this.opt("mappings-file", Read$.MODULE$.stringRead()).optional().action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    Option x$85 = Option$.MODULE$.apply(x);
                    URI x$86 = c.copy$default$1();
                    URI x$87 = c.copy$default$2();
                    URI x$88 = c.copy$default$3();
                    Enumeration.Value x$89 = c.copy$default$4();
                    boolean x$90 = c.copy$default$5();
                    String x$91 = c.copy$default$6();
                    boolean x$92 = c.copy$default$7();
                    boolean x$93 = c.copy$default$9();
                    boolean x$94 = c.copy$default$10();
                    boolean x$95 = c.copy$default$11();
                    boolean x$96 = c.copy$default$12();
                    int x$97 = c.copy$default$13();
                    String x$98 = c.copy$default$14();
                    return c.copy(x$86, x$87, x$88, x$89, x$90, x$91, x$92, (Option<String>)x$85, x$93, x$94, x$95, x$96, x$97, x$98);
                }).text("path to the generated R2RML mappings file");
                this.opt("save-ignore", Read$.MODULE$.unitRead()).optional().action((Function2 & Serializable & scala.Serializable)(x$2, c) -> {
                    boolean x$99 = true;
                    URI x$100 = c.copy$default$1();
                    URI x$101 = c.copy$default$2();
                    URI x$102 = c.copy$default$3();
                    Enumeration.Value x$103 = c.copy$default$4();
                    boolean x$104 = c.copy$default$5();
                    String x$105 = c.copy$default$6();
                    boolean x$106 = c.copy$default$7();
                    Option<String> x$107 = c.copy$default$8();
                    boolean x$108 = c.copy$default$10();
                    boolean x$109 = c.copy$default$11();
                    boolean x$110 = c.copy$default$12();
                    int x$111 = c.copy$default$13();
                    String x$112 = c.copy$default$14();
                    return c.copy(x$100, x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$99, x$108, x$109, x$110, x$111, x$112);
                }).text("if data/table already exists, the save operation is expected to not save the contents of the DataFrame and to not change the existing data");
                this.opt("save-overwrite", Read$.MODULE$.unitRead()).optional().action((Function2 & Serializable & scala.Serializable)(x$3, c) -> {
                    boolean x$113 = true;
                    URI x$114 = c.copy$default$1();
                    URI x$115 = c.copy$default$2();
                    URI x$116 = c.copy$default$3();
                    Enumeration.Value x$117 = c.copy$default$4();
                    boolean x$118 = c.copy$default$5();
                    String x$119 = c.copy$default$6();
                    boolean x$120 = c.copy$default$7();
                    Option<String> x$121 = c.copy$default$8();
                    boolean x$122 = c.copy$default$9();
                    boolean x$123 = c.copy$default$11();
                    boolean x$124 = c.copy$default$12();
                    int x$125 = c.copy$default$13();
                    String x$126 = c.copy$default$14();
                    return c.copy(x$114, x$115, x$116, x$117, x$118, x$119, x$120, x$121, x$122, x$113, x$123, x$124, x$125, x$126);
                }).text("if data/table already exists, existing data is expected to be overwritten");
                this.opt("save-append", Read$.MODULE$.unitRead()).optional().action((Function2 & Serializable & scala.Serializable)(x$4, c) -> {
                    boolean x$127 = true;
                    URI x$128 = c.copy$default$1();
                    URI x$129 = c.copy$default$2();
                    URI x$130 = c.copy$default$3();
                    Enumeration.Value x$131 = c.copy$default$4();
                    boolean x$132 = c.copy$default$5();
                    String x$133 = c.copy$default$6();
                    boolean x$134 = c.copy$default$7();
                    Option<String> x$135 = c.copy$default$8();
                    boolean x$136 = c.copy$default$9();
                    boolean x$137 = c.copy$default$10();
                    boolean x$138 = c.copy$default$12();
                    int x$139 = c.copy$default$13();
                    String x$140 = c.copy$default$14();
                    return c.copy(x$128, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$127, x$138, x$139, x$140);
                }).text("if data/table already exists, contents of the DataFrame are expected to be appended to existing data");
                this.opt("partitioning", Read$.MODULE$.unitRead()).optional().action((Function2 & Serializable & scala.Serializable)(x$5, c) -> {
                    boolean x$141 = true;
                    URI x$142 = c.copy$default$1();
                    URI x$143 = c.copy$default$2();
                    URI x$144 = c.copy$default$3();
                    Enumeration.Value x$145 = c.copy$default$4();
                    boolean x$146 = c.copy$default$5();
                    String x$147 = c.copy$default$6();
                    boolean x$148 = c.copy$default$7();
                    Option<String> x$149 = c.copy$default$8();
                    boolean x$150 = c.copy$default$9();
                    boolean x$151 = c.copy$default$10();
                    boolean x$152 = c.copy$default$11();
                    int x$153 = c.copy$default$13();
                    String x$154 = c.copy$default$14();
                    return c.copy(x$142, x$143, x$144, x$145, x$146, x$147, x$148, x$149, x$150, x$151, x$152, x$141, x$153, x$154);
                }).text("if partitioning of subject/object columns should be computed");
                this.opt("partitioning-threshold", Read$.MODULE$.intRead()).optional().action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$13(BoxesRunTime.unboxToInt((Object)x), c)).text("the max. number of values of subject/object values for which partitioning of the table is considered");
                this.cmd("show").action((Function2 & Serializable & scala.Serializable)(x$6, c) -> {
                    String x$169 = "show-tables";
                    URI x$170 = c.copy$default$1();
                    URI x$171 = c.copy$default$2();
                    URI x$172 = c.copy$default$3();
                    Enumeration.Value x$173 = c.copy$default$4();
                    boolean x$174 = c.copy$default$5();
                    String x$175 = c.copy$default$6();
                    boolean x$176 = c.copy$default$7();
                    Option<String> x$177 = c.copy$default$8();
                    boolean x$178 = c.copy$default$9();
                    boolean x$179 = c.copy$default$10();
                    boolean x$180 = c.copy$default$11();
                    boolean x$181 = c.copy$default$12();
                    int x$182 = c.copy$default$13();
                    return c.copy(x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177, x$178, x$179, x$180, x$181, x$182, x$169);
                }).text("update is a command.");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.net.URI net.sansa_stack.query.spark.ontop.VerticalPartitioner$Config ), $anonfun$new$2(java.net.URI net.sansa_stack.query.spark.ontop.VerticalPartitioner$Config ), $anonfun$new$3(java.net.URI net.sansa_stack.query.spark.ontop.VerticalPartitioner$Config ), $anonfun$new$4(scala.Enumeration$Value net.sansa_stack.query.spark.ontop.VerticalPartitioner$Config ), $anonfun$new$5$adapted(java.lang.Object net.sansa_stack.query.spark.ontop.VerticalPartitioner$Config ), $anonfun$new$6(java.lang.String net.sansa_stack.query.spark.ontop.VerticalPartitioner$Config ), $anonfun$new$7(scala.runtime.BoxedUnit net.sansa_stack.query.spark.ontop.VerticalPartitioner$Config ), $anonfun$new$8(java.lang.String net.sansa_stack.query.spark.ontop.VerticalPartitioner$Config ), $anonfun$new$9(scala.runtime.BoxedUnit net.sansa_stack.query.spark.ontop.VerticalPartitioner$Config ), $anonfun$new$10(scala.runtime.BoxedUnit net.sansa_stack.query.spark.ontop.VerticalPartitioner$Config ), $anonfun$new$11(scala.runtime.BoxedUnit net.sansa_stack.query.spark.ontop.VerticalPartitioner$Config ), $anonfun$new$12(scala.runtime.BoxedUnit net.sansa_stack.query.spark.ontop.VerticalPartitioner$Config ), $anonfun$new$13$adapted(java.lang.Object net.sansa_stack.query.spark.ontop.VerticalPartitioner$Config ), $anonfun$new$14(scala.runtime.BoxedUnit net.sansa_stack.query.spark.ontop.VerticalPartitioner$Config )}, serializedLambda);
            }
        };
        this.sqlCodec = SqlCodecUtils.createSqlCodecForApacheSpark();
    }
}

