/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.rdd.op;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.sansa_stack.query.spark.api.domain.ResultSetSpark;
import net.sansa_stack.query.spark.package$;
import net.sansa_stack.query.spark.rdd.op.NodeToSparkMapper;
import net.sansa_stack.query.spark.rdd.op.NodeToSparkMapperImpl;
import net.sansa_stack.query.spark.rdd.op.TypeMapperRdfSpark;
import net.sansa_stack.rdf.spark.utils.DataTypeUtils$;
import net.sansa_stack.rdf.spark.utils.SparkSessionUtils$;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapper;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapperFromRdfDatatype;
import org.aksw.jenax.arq.analytics.BindingAnalytics;
import org.aksw.jenax.arq.decisiontree.api.DecisionTreeSparqlExpr;
import org.aksw.jenax.arq.schema_mapping.FieldMapping;
import org.aksw.jenax.arq.schema_mapping.SchemaMapperImpl;
import org.aksw.jenax.arq.schema_mapping.SchemaMapping;
import org.aksw.jenax.arq.schema_mapping.TypePromoterImpl;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.vocabulary.XSD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class RddOfBindingsToDataFrameMapper$
implements LazyLogging {
    public static RddOfBindingsToDataFrameMapper$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new RddOfBindingsToDataFrameMapper$();
    }

    private Logger logger$lzycompute() {
        RddOfBindingsToDataFrameMapper$ rddOfBindingsToDataFrameMapper$ = this;
        synchronized (rddOfBindingsToDataFrameMapper$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public SchemaMapperImpl configureSchemaMapper(ResultSetSpark resultSet) {
        LinkedHashSet javaResultVars = new LinkedHashSet((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(resultSet.getResultVars()).asJava());
        Map usedDatatypesAndNulls = (Map)package$.MODULE$.RddOpsImplicits(resultSet.getBindings(), ClassTag$.MODULE$.apply(Binding.class)).javaCollect(BindingAnalytics.usedDatatypesAndNullCounts(javaResultVars).asCollector(), ClassTag$.MODULE$.apply(Object.class), ClassTag$.MODULE$.apply(Map.class));
        TypeMapper typeMapper = TypeMapper.getInstance();
        SchemaMapperImpl schemaMapper = SchemaMapperImpl.newInstance().setSourceVars(javaResultVars).setSourceVarToDatatypes(v -> (Set)((Map.Entry)usedDatatypesAndNulls.get(v)).getKey()).setSourceVarToNulls(v -> (Long)((Map.Entry)usedDatatypesAndNulls.get(v)).getValue()).setTypePromotionStrategy(TypePromoterImpl.create()).setVarToFallbackDatatypeToString().setTypeRemap(x$1 -> MODULE$.considerDatatypeRemap((String)x$1, typeMapper));
        return schemaMapper;
    }

    public String considerDatatypeRemap(String tgtType, TypeMapper typeMapper) {
        NodeToSparkMapper nodeToSparkMapper;
        String result = tgtType;
        try {
            nodeToSparkMapper = this.getNodeToSparkMapper(tgtType, typeMapper);
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            String fallbackType = XSD.xstring.getURI();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringOps(Predef$.MODULE$.augmentString("No mapping for %s - falling back to ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tgtType, fallbackType})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            result = fallbackType;
            nodeToSparkMapper = BoxedUnit.UNIT;
        }
        return result;
    }

    public NodeToSparkMapper getNodeToSparkMapper(String datatypeIri, TypeMapper typeMapper) {
        NodeToSparkMapper result;
        block1: {
            String effectiveDatatypeIri = this.getEffectiveDatatype(datatypeIri);
            Map<String, NodeToSparkMapper> registry = TypeMapperRdfSpark.getNodeToSparkMapperRegistry();
            result = registry.get(effectiveDatatypeIri);
            if (result != null) break block1;
            RDFDatatype rdfDatatype = typeMapper.getSafeTypeByName(effectiveDatatypeIri);
            Class javaClass = rdfDatatype.getJavaClass();
            if (javaClass == null) {
                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("SchemaMapper: Don't know how to handle: %s. Maybe consider registering a fallback to xsd:string?")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{effectiveDatatypeIri})));
            }
            DataType dataType = DataTypeUtils$.MODULE$.getSparkType(javaClass);
            NodeMapperFromRdfDatatype nodeMapper = new NodeMapperFromRdfDatatype(rdfDatatype);
            result = new NodeToSparkMapperImpl(dataType, (NodeMapper<?>)nodeMapper);
        }
        return result;
    }

    public Dataset<Row> applySchemaMapping(RDD<Binding> bindings, SchemaMapping schemaMapping) {
        BoxedUnit boxedUnit;
        SparkSession sparkSession = SparkSessionUtils$.MODULE$.getSessionFromRdd(bindings);
        TypeMapper typeMapper = TypeMapper.getInstance();
        Seq structFields = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(schemaMapping.getDefinedVars().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)v -> {
            FieldMapping fieldMapping = (FieldMapping)schemaMapping.getFieldMapping().get(v);
            String datatypeIri = fieldMapping.getDatatypeIri();
            String name = v.getVarName();
            NodeToSparkMapper nodeToSparkMapper = MODULE$.getNodeToSparkMapper(datatypeIri, typeMapper);
            DataType dataType = nodeToSparkMapper.getSparkDatatype();
            boolean isNullable = fieldMapping.isNullable();
            return new StructField(name, dataType, isNullable, StructField$.MODULE$.apply$default$4());
        }).toSeq();
        StructType targetSchema = StructType$.MODULE$.apply(structFields);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(23).append("Created target schema: ").append(targetSchema).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RDD rows = bindings.mapPartitions((Function1 & Serializable & scala.Serializable)it -> {
            Seq nodeToSparkMappers = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(schemaMapping.getDefinedVars().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)v -> {
                FieldMapping fieldMapping = (FieldMapping)schemaMapping.getFieldMapping().get(v);
                String datatypeIri = fieldMapping.getDatatypeIri();
                return MODULE$.getNodeToSparkMapper(datatypeIri, TypeMapper.getInstance());
            }).toSeq();
            Function1 & Serializable & scala.Serializable rowMapper = (Function1 & Serializable & scala.Serializable)row -> MODULE$.mapToRow((Binding)row, schemaMapping, (Seq<NodeToSparkMapper>)nodeToSparkMappers);
            return it.map((Function1)rowMapper);
        }, bindings.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
        return sparkSession.createDataFrame(rows, targetSchema);
    }

    public String getEffectiveDatatype(String datatypeIri) {
        String string = datatypeIri;
        if ("http://www.w3.org/ns/r2rml#IRI".equals(string)) {
            return XSD.xstring.getURI();
        }
        if ("http://www.w3.org/ns/r2rml#BlankNode".equals(string)) {
            return XSD.xstring.getURI();
        }
        return string;
    }

    public Row mapToRow(Binding binding, SchemaMapping schemaMapping, Seq<NodeToSparkMapper> nodeToSparkMappers) {
        Seq seq = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(schemaMapping.getDefinedVars().iterator()).asScala()).zipWithIndex().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Var v = (Var)tuple2._1();
                int i = tuple2._2$mcI$sp();
                NodeToSparkMapper nodeToSparkMapper = (NodeToSparkMapper)nodeToSparkMappers.apply(i);
                FieldMapping fieldMapping = (FieldMapping)schemaMapping.getFieldMapping().get(v);
                DecisionTreeSparqlExpr decisionTreeExpr = fieldMapping.getDefinition();
                Node node = decisionTreeExpr.eval(binding);
                String rawJavaValue = node == null ? null : (node.isURI() ? node.getURI() : (node.isBlank() ? node.getBlankNodeLabel() : nodeToSparkMapper.getNodeMapper().toJava((Object)node)));
                Object effectiveJavaValue = DataTypeUtils$.MODULE$.enforceSparkCompatibility((Object)rawJavaValue);
                return effectiveJavaValue;
            }
            throw new MatchError((Object)tuple2);
        }).toSeq();
        return Row$.MODULE$.fromSeq(seq);
    }

    private RddOfBindingsToDataFrameMapper$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

