/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.rdd.op;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.sansa_stack.query.spark.rdd.op.NodeToSparkMapper;
import net.sansa_stack.query.spark.rdd.op.NodeToSparkMapperImpl;
import org.aksw.commons.lambda.serializable.SerializableFunction;
import org.aksw.commons.lambda.serializable.SerializablePredicate;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapper;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapperDelegating;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.vocabulary.XSD;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;

public class TypeMapperRdfSpark {
    public static Map<String, NodeToSparkMapper> getNodeToSparkMapperRegistry() {
        HashMap<String, NodeToSparkMapper> registry = new HashMap<String, NodeToSparkMapper>();
        TypeMapper typeMapper = TypeMapper.getInstance();
        String datatypeIri = XSD.date.getURI();
        DataType dataType = DataTypes.DateType;
        RDFDatatype rdfDatatype = typeMapper.getSafeTypeByName(datatypeIri);
        NodeMapperDelegating nodeMapper = NodeMapperDelegating.create(Date.class, (SerializablePredicate & Serializable)x -> x.isLiteral() && x.getLiteralDatatype() != null && XSDDateTime.class.equals((Object)x.getLiteralDatatype().getJavaClass()), (SerializableFunction & Serializable)x -> NodeFactory.createLiteralByValue((Object)TypeMapperRdfSpark.sqlDateToCalendar((Date)x), (RDFDatatype)rdfDatatype), (SerializableFunction & Serializable)x -> new Date(((XSDDateTime)x.getLiteralValue()).asCalendar().getTimeInMillis()));
        NodeToSparkMapperImpl nodeToSparkMapper = new NodeToSparkMapperImpl(dataType, (NodeMapper<?>)nodeMapper);
        registry.put(datatypeIri, nodeToSparkMapper);
        return registry;
    }

    public static Calendar sqlTimestampToCalendar(Timestamp timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp.getTime());
        return calendar;
    }

    public static Calendar sqlDateToCalendar(Date timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp.getTime());
        return calendar;
    }
}

