/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.query.spark.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.spark.util.AccumulatorV2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i3A\u0001D\u0007\u00011!)!\b\u0001C\u0001w!9a\b\u0001b\u0001\n\u0013y\u0004B\u0002!\u0001A\u0003%1\u0007C\u0003B\u0001\u0011\u0005#\tC\u0003G\u0001\u0011\u00053\bC\u0003H\u0001\u0011\u00053\bC\u0003I\u0001\u0011\u0005\u0013\nC\u0003N\u0001\u0011\u0005c\nC\u0003R\u0001\u0011\u0005#\u000bC\u0003V\u0001\u0011\u0005s\b\u0003\u0004W\u0001\u0011\u0005qb\u0016\u0002\u000f'\u0016$\u0018iY2v[Vd\u0017\r^8s\u0015\tqq\"A\u0003vi&d7O\u0003\u0002\u0011#\u0005)1\u000f]1sW*\u0011!cE\u0001\u0006cV,'/\u001f\u0006\u0003)U\t1b]1og\u0006|6\u000f^1dW*\ta#A\u0002oKR\u001c\u0001!\u0006\u0002\u001aOM\u0011\u0001A\u0007\t\u00057\r*3'D\u0001\u001d\u0015\tib$\u0001\u0003vi&d'B\u0001\t \u0015\t\u0001\u0013%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0005\u0019qN]4\n\u0005\u0011b\"!D!dGVlW\u000f\\1u_J4&\u0007\u0005\u0002'O1\u0001A!\u0002\u0015\u0001\u0005\u0004I#!\u0001+\u0012\u0005)\u0002\u0004CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#a\u0002(pi\"Lgn\u001a\t\u0003WEJ!A\r\u0017\u0003\u0007\u0005s\u0017\u0010E\u00025q\u0015j\u0011!\u000e\u0006\u0003;YR\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:k\t\u00191+\u001a;\u0002\rqJg.\u001b;?)\u0005a\u0004cA\u001f\u0001K5\tQ\"\u0001\u0003`g\u0016$X#A\u001a\u0002\u000b}\u001bX\r\u001e\u0011\u0002\r%\u001c(,\u001a:p+\u0005\u0019\u0005CA\u0016E\u0013\t)EFA\u0004C_>dW-\u00198\u0002\u0019\r|\u0007/_!oIJ+7/\u001a;\u0002\t\r|\u0007/_\u0001\u0006e\u0016\u001cX\r\u001e\u000b\u0002\u0015B\u00111fS\u0005\u0003\u00192\u0012A!\u00168ji\u0006\u0019\u0011\r\u001a3\u0015\u0005){\u0005\"\u0002)\t\u0001\u0004)\u0013!\u0001<\u0002\u000b5,'oZ3\u0015\u0005)\u001b\u0006\"\u0002+\n\u0001\u0004Q\u0012!B8uQ\u0016\u0014\u0018!\u0002<bYV,\u0017\u0001C:fiZ\u000bG.^3\u0015\u0005)C\u0006\"B-\f\u0001\u0004\u0019\u0014\u0001\u00038foZ\u000bG.^3")
public class SetAccumulator<T>
extends AccumulatorV2<T, Set<T>> {
    private final Set<T> _set = Collections.synchronizedSet(new HashSet());

    private Set<T> _set() {
        return this._set;
    }

    public boolean isZero() {
        return this._set().isEmpty();
    }

    public SetAccumulator<T> copyAndReset() {
        return new SetAccumulator<T>();
    }

    public SetAccumulator<T> copy() {
        SetAccumulator<T> newAcc = new SetAccumulator<T>();
        Set<T> set = this._set();
        synchronized (set) {
            super._set().addAll(this._set());
        }
        return newAcc;
    }

    public void reset() {
        this._set().clear();
    }

    public void add(T v) {
        this._set().add(v);
    }

    public void merge(AccumulatorV2<T, Set<T>> other) {
        AccumulatorV2<T, Set<T>> accumulatorV2 = other;
        if (accumulatorV2 instanceof SetAccumulator) {
            SetAccumulator setAccumulator = (SetAccumulator)accumulatorV2;
            this._set().addAll((Collection<T>)setAccumulator.value());
            return;
        }
        throw new UnsupportedOperationException(new StringBuilder(19).append("Cannot merge ").append(this.getClass().getName()).append(" with ").append(other.getClass().getName()).toString());
    }

    public Set<T> value() {
        Set<T> set;
        Set<T> set2 = this._set();
        synchronized (set2) {
            set = Collections.unmodifiableSet(new HashSet<T>(this._set()));
        }
        return set;
    }

    public void setValue(Set<T> newValue) {
        this._set().clear();
        this._set().addAll(newValue);
    }
}

