/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.io.benchmark;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import net.sansa_stack.rdf.benchmark.io.ReadableByteChannelFromIterator;
import org.apache.jena.ext.com.google.common.base.Stopwatch;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class SansaBenchRdfParse$ {
    public static final SansaBenchRdfParse$ MODULE$;

    static {
        new SansaBenchRdfParse$();
    }

    public void main(String[] args) {
        String tempDirStr = System.getProperty("java.io.tmpdir");
        if (tempDirStr == null) {
            throw new RuntimeException("Could not obtain temporary directory");
        }
        File sparkEventsDir = new File(new StringBuilder().append((Object)tempDirStr).append((Object)"/spark-events").toString());
        Object object = sparkEventsDir.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)sparkEventsDir.mkdirs());
        SparkSession sparkSession = SparkSession$.MODULE$.builder().master("local").appName("spark session example").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.eventLog.enabled", "true").config("spark.default.parallelism", "4").config("spark.sql.shuffle.partitions", "4").getOrCreate();
        sparkSession.conf().set("spark.sql.crossJoin.enabled", "true");
        String triplesString = new StringOps(Predef$.MODULE$.augmentString("<http://dbpedia.org/resource/Guy_de_Maupassant> <http://xmlns.com/foaf/0.1/givenName> \"Guy De\" .\n        |<http://dbpedia.org/resource/Guy_de_Maupassant> <http://example.org/ontology/age> \"30\"^^<http://www.w3.org/2001/XMLSchema#integer> .\n        |<http://dbpedia.org/resource/Guy_de_Maupassant> <http://dbpedia.org/ontology/influenced> <http://dbpedia.org/resource/Tobias_Wolff> .\n        |<http://dbpedia.org/resource/Guy_de_Maupassant> <http://dbpedia.org/ontology/influenced> <http://dbpedia.org/resource/Henry_James> .\n        |<http://dbpedia.org/resource/Guy_de_Maupassant> <http://dbpedia.org/ontology/deathPlace> <http://dbpedia.org/resource/Passy> .\n        |<http://dbpedia.org/resource/Charles_Dickens> <http://xmlns.com/foaf/0.1/givenName> \"Charles\"@en .\n        |<http://dbpedia.org/resource/Charles_Dickens> <http://dbpedia.org/ontology/deathPlace> <http://dbpedia.org/resource/Gads_Hill_Place> .\n        |<http://someOnt/1> <http://someOnt/184298> <http://someOnt/272277> .\n        |<http://someOnt/184298> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2002/07/owl#AnnotationProperty> .\n        |<http://snomedct-20170731T150000Z> <http://www.w3.org/2002/07/owl#versionInfo> \"20170731T150000Z\"@en .\n        |")).stripMargin();
        if (args.length != 1) {
            throw package$.MODULE$.error("please provide path to RDF file(s) a argument");
        }
        RDD textRdd = sparkSession.sparkContext().textFile(args[0], 20);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Raw count: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)textRdd.count())})));
        this.measureLoadingTime((RDD<Triple>)textRdd.mapPartitions((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<Triple> apply(Iterator<String> p) {
                return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(RDFDataMgr.createIteratorTriples((InputStream)SansaBenchRdfParse$.MODULE$.toInputStream(p), (Lang)Lang.NTRIPLES, null)).asScala();
            }
        }, textRdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Triple.class)));
        this.measureLoadingTime((RDD<Triple>)textRdd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Triple apply(String line) {
                return (Triple)RDFDataMgr.createIteratorTriples((InputStream)new ByteArrayInputStream(line.getBytes()), (Lang)Lang.NTRIPLES, null).next();
            }
        }, ClassTag$.MODULE$.apply(Triple.class)));
        sparkSession.stop();
    }

    public void measureLoadingTime(RDD<Triple> rdd) {
        Stopwatch sw = Stopwatch.createStarted();
        long c = rdd.count();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time: ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)sw.stop().elapsed(TimeUnit.MILLISECONDS))})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Count: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)c)})));
    }

    public InputStream toInputStream(Iterator<String> it) {
        return ReadableByteChannelFromIterator.toInputStream((java.util.Iterator)((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(it).asJava()));
    }

    private SansaBenchRdfParse$() {
        MODULE$ = this;
    }
}

