/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.io.turtle;

import java.io.InputStream;
import net.sansa_stack.rdf.common.annotation.Experimental;
import net.sansa_stack.rdf.spark.io.turtle.SkipLineReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CompressedSplitLineReader;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.SplitLineReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\t-a\u0001B\u0001\u0003\u0001=\u0011!\u0003V;si2,'+Z2pe\u0012\u0014V-\u00193fe*\u00111\u0001B\u0001\u0007iV\u0014H\u000f\\3\u000b\u0005\u00151\u0011AA5p\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u0005\u0019!\u000f\u001a4\u000b\u0005-a\u0011aC:b]N\fwl\u001d;bG.T\u0011!D\u0001\u0004]\u0016$8\u0001A\n\u0003\u0001A\u0001B!\u0005\u000e\u001dC5\t!C\u0003\u0002\u0014)\u0005IQ.\u00199sK\u0012,8-\u001a\u0006\u0003+Y\ta\u0001[1e_>\u0004(BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001eL!a\u0007\n\u0003\u0019I+7m\u001c:e%\u0016\fG-\u001a:\u0011\u0005uyR\"\u0001\u0010\u000b\u0005\u0015!\u0012B\u0001\u0011\u001f\u00051auN\\4Xe&$\u0018M\u00197f!\ti\"%\u0003\u0002$=\t!A+\u001a=u\u0011!)\u0003A!b\u0001\n\u00031\u0013\u0001\u0006:fG>\u0014H\rR3mS6LG/\u001a:CsR,7/F\u0001(!\rA3&L\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t)\u0011I\u001d:bsB\u0011\u0001FL\u0005\u0003_%\u0012AAQ=uK\"A\u0011\u0007\u0001B\u0001B\u0003%q%A\u000bsK\u000e|'\u000f\u001a#fY&l\u0017\u000e^3s\u0005f$Xm\u001d\u0011\t\u000bM\u0002A\u0011\u0001\u001b\u0002\rqJg.\u001b;?)\t)t\u0007\u0005\u00027\u00015\t!\u0001C\u0003&e\u0001\u0007q\u0005C\u0004:\u0001\t\u0007I\u0011\u0001\u001e\u0002\u00071{u)F\u0001<!\tat(D\u0001>\u0015\tq\u0004$A\u0003tY\u001a$$.\u0003\u0002A{\t1Aj\\4hKJDaA\u0011\u0001!\u0002\u0013Y\u0014\u0001\u0002'P\u000f\u0002Bq\u0001\u0012\u0001C\u0002\u0013\u0005Q)A\bN\u0003b{F*\u0013(F?2+ej\u0012+I+\u00051\u0005CA$M\u001b\u0005A%BA%K\u0003\u0011a\u0017M\\4\u000b\u0003-\u000bAA[1wC&\u0011Q\n\u0013\u0002\u0007'R\u0014\u0018N\\4\t\r=\u0003\u0001\u0015!\u0003G\u0003Ai\u0015\tW0M\u0013:+u\fT#O\u000fRC\u0005\u0005C\u0004R\u0001\u0001\u0007I\u0011\u0001*\u0002\u000bM$\u0018M\u001d;\u0016\u0003M\u0003\"\u0001\u000b+\n\u0005UK#\u0001\u0002'p]\u001eDqa\u0016\u0001A\u0002\u0013\u0005\u0001,A\u0005ti\u0006\u0014Ho\u0018\u0013fcR\u0011\u0011\f\u0018\t\u0003QiK!aW\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b;Z\u000b\t\u00111\u0001T\u0003\rAH%\r\u0005\u0007?\u0002\u0001\u000b\u0015B*\u0002\rM$\u0018M\u001d;!\u0011\u001d\t\u0007\u00011A\u0005\u0002I\u000b1!\u001a8e\u0011\u001d\u0019\u0007\u00011A\u0005\u0002\u0011\fq!\u001a8e?\u0012*\u0017\u000f\u0006\u0002ZK\"9QLYA\u0001\u0002\u0004\u0019\u0006BB4\u0001A\u0003&1+\u0001\u0003f]\u0012\u0004\u0003bB5\u0001\u0001\u0004%\tAU\u0001\u0004a>\u001c\bbB6\u0001\u0001\u0004%\t\u0001\\\u0001\ba>\u001cx\fJ3r)\tIV\u000eC\u0004^U\u0006\u0005\t\u0019A*\t\r=\u0004\u0001\u0015)\u0003T\u0003\u0011\u0001xn\u001d\u0011\t\u000fE\u0004\u0001\u0019!C\u0001e\u00061!/Z1eKJ,\u0012a\u001d\t\u0003ifl\u0011!\u001e\u0006\u0003m^\fQ!\u001b8qkRT!\u0001\u001f\n\u0002\u00071L'-\u0003\u0002{k\ny1\u000b\u001d7ji2Kg.\u001a*fC\u0012,'\u000fC\u0004}\u0001\u0001\u0007I\u0011A?\u0002\u0015I,\u0017\rZ3s?\u0012*\u0017\u000f\u0006\u0002Z}\"9Ql_A\u0001\u0002\u0004\u0019\bbBA\u0001\u0001\u0001\u0006Ka]\u0001\be\u0016\fG-\u001a:!\u0011%\t)\u0001\u0001a\u0001\n\u0003\t9!A\u0002lKf,\u0012\u0001\b\u0005\n\u0003\u0017\u0001\u0001\u0019!C\u0001\u0003\u001b\tqa[3z?\u0012*\u0017\u000fF\u0002Z\u0003\u001fA\u0001\"XA\u0005\u0003\u0003\u0005\r\u0001\b\u0005\b\u0003'\u0001\u0001\u0015)\u0003\u001d\u0003\u0011YW-\u001f\u0011\t\u0013\u0005]\u0001\u00011A\u0005\u0002\u0005e\u0011!\u0002<bYV,W#A\u0011\t\u0013\u0005u\u0001\u00011A\u0005\u0002\u0005}\u0011!\u0003<bYV,w\fJ3r)\rI\u0016\u0011\u0005\u0005\t;\u0006m\u0011\u0011!a\u0001C!9\u0011Q\u0005\u0001!B\u0013\t\u0013A\u0002<bYV,\u0007\u0005C\u0005\u0002*\u0001\u0001\r\u0011\"\u0003\u0002,\u00051a-\u001b7f\u0013:,\"!!\f\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\r\u0015\u0003\t17/\u0003\u0003\u00028\u0005E\"!\u0005$T\t\u0006$\u0018-\u00138qkR\u001cFO]3b[\"I\u00111\b\u0001A\u0002\u0013%\u0011QH\u0001\u000bM&dW-\u00138`I\u0015\fHcA-\u0002@!IQ,!\u000f\u0002\u0002\u0003\u0007\u0011Q\u0006\u0005\t\u0003\u0007\u0002\u0001\u0015)\u0003\u0002.\u00059a-\u001b7f\u0013:\u0004\u0003\"CA$\u0001\u0001\u0007I\u0011BA%\u000311\u0017\u000e\\3Q_NLG/[8o+\t\tY\u0005\u0005\u0003\u00020\u00055\u0013\u0002BA(\u0003c\u0011\u0001bU3fW\u0006\u0014G.\u001a\u0005\n\u0003'\u0002\u0001\u0019!C\u0005\u0003+\n\u0001CZ5mKB{7/\u001b;j_:|F%Z9\u0015\u0007e\u000b9\u0006C\u0005^\u0003#\n\t\u00111\u0001\u0002L!A\u00111\f\u0001!B\u0013\tY%A\u0007gS2,\u0007k\\:ji&|g\u000e\t\u0005\n\u0003?\u0002\u0001\u0019!C\u0005\u0003C\nQ\"\\1y\u0019&tW\rT3oORDWCAA2!\rA\u0013QM\u0005\u0004\u0003OJ#aA%oi\"I\u00111\u000e\u0001A\u0002\u0013%\u0011QN\u0001\u0012[\u0006DH*\u001b8f\u0019\u0016tw\r\u001e5`I\u0015\fHcA-\u0002p!IQ,!\u001b\u0002\u0002\u0003\u0007\u00111\r\u0005\t\u0003g\u0002\u0001\u0015)\u0003\u0002d\u0005qQ.\u0019=MS:,G*\u001a8hi\"\u0004\u0003\"CA<\u0001\u0001\u0007I\u0011BA=\u0003EI7oQ8naJ,7o]3e\u0013:\u0004X\u000f^\u000b\u0003\u0003w\u00022\u0001KA?\u0013\r\ty(\u000b\u0002\b\u0005>|G.Z1o\u0011%\t\u0019\t\u0001a\u0001\n\u0013\t))A\u000bjg\u000e{W\u000e\u001d:fgN,G-\u00138qkR|F%Z9\u0015\u0007e\u000b9\tC\u0005^\u0003\u0003\u000b\t\u00111\u0001\u0002|!A\u00111\u0012\u0001!B\u0013\tY(\u0001\njg\u000e{W\u000e\u001d:fgN,G-\u00138qkR\u0004\u0003\"CAH\u0001\u0001\u0007I\u0011BAI\u00031!WmY8naJ,7o]8s+\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tIJH\u0001\tG>l\u0007O]3tg&!\u0011QTAL\u00051!UmY8naJ,7o]8s\u0011%\t\t\u000b\u0001a\u0001\n\u0013\t\u0019+\u0001\teK\u000e|W\u000e\u001d:fgN|'o\u0018\u0013fcR\u0019\u0011,!*\t\u0013u\u000by*!AA\u0002\u0005M\u0005\u0002CAU\u0001\u0001\u0006K!a%\u0002\u001b\u0011,7m\\7qe\u0016\u001c8o\u001c:!\u0011\u001d\ti\u000b\u0001C!\u0003_\u000b!\"\u001b8ji&\fG.\u001b>f)\u0015I\u0016\u0011WA^\u0011!\t\u0019,a+A\u0002\u0005U\u0016AC5oaV$8\u000b\u001d7jiB\u0019\u0011#a.\n\u0007\u0005e&C\u0001\u0006J]B,Ho\u00159mSRD\u0001\"!0\u0002,\u0002\u0007\u0011qX\u0001\bG>tG/\u001a=u!\r\t\u0012\u0011Y\u0005\u0004\u0003\u0007\u0014\"A\u0005+bg.\fE\u000f^3naR\u001cuN\u001c;fqRDq!a2\u0001\t\u0013\tI-A\tnCb\u0014\u0015\u0010^3t)>\u001cuN\\:v[\u0016$B!a\u0019\u0002L\"1\u0011.!2A\u0002MCa!a4\u0001\t\u0013\u0011\u0016aD4fi\u001aKG.\u001a)pg&$\u0018n\u001c8\t\u000f\u0005M\u0007\u0001\"\u0011\u0002V\u0006aa.\u001a=u\u0017\u0016Lh+\u00197vKR\u0011\u00111\u0010\u0005\b\u00033\u0004A\u0011IAn\u000359W\r^\"veJ,g\u000e^&fsR\tA\u0004C\u0004\u0002`\u0002!\t%!9\u0002\u0017\u001d,G\u000f\u0015:pOJ,7o\u001d\u000b\u0003\u0003G\u00042\u0001KAs\u0013\r\t9/\u000b\u0002\u0006\r2|\u0017\r\u001e\u0005\b\u0003W\u0004A\u0011IAw\u0003=9W\r^\"veJ,g\u000e\u001e,bYV,G#A\u0011\t\u000f\u0005E\b\u0001\"\u0011\u0002t\u0006)1\r\\8tKR\t\u0011\fC\u0004\u0002x\u0002!I!!\u0019\u0002)M\\\u0017\u000e]+uM\nKH/Z(sI\u0016\u0014X*\u0019:lQ\r\u0001\u00111 \t\u0005\u0003{\u00149!\u0004\u0002\u0002\u0000*!!\u0011\u0001B\u0002\u0003)\tgN\\8uCRLwN\u001c\u0006\u0004\u0005\u000bA\u0011AB2p[6|g.\u0003\u0003\u0003\n\u0005}(\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006d\u0007")
public class TurtleRecordReader
extends RecordReader<LongWritable, Text> {
    private final byte[] recordDelimiterBytes;
    private final Logger LOG;
    private final String MAX_LINE_LENGTH;
    private long start;
    private long end;
    private long pos;
    private SplitLineReader reader;
    private LongWritable key;
    private Text value;
    private FSDataInputStream fileIn;
    private Seekable filePosition;
    private int maxLineLength;
    private boolean isCompressedInput;
    private Decompressor decompressor;

    public byte[] recordDelimiterBytes() {
        return this.recordDelimiterBytes;
    }

    public Logger LOG() {
        return this.LOG;
    }

    public String MAX_LINE_LENGTH() {
        return this.MAX_LINE_LENGTH;
    }

    public long start() {
        return this.start;
    }

    public void start_$eq(long x$1) {
        this.start = x$1;
    }

    public long end() {
        return this.end;
    }

    public void end_$eq(long x$1) {
        this.end = x$1;
    }

    public long pos() {
        return this.pos;
    }

    public void pos_$eq(long x$1) {
        this.pos = x$1;
    }

    public SplitLineReader reader() {
        return this.reader;
    }

    public void reader_$eq(SplitLineReader x$1) {
        this.reader = x$1;
    }

    public LongWritable key() {
        return this.key;
    }

    public void key_$eq(LongWritable x$1) {
        this.key = x$1;
    }

    public Text value() {
        return this.value;
    }

    public void value_$eq(Text x$1) {
        this.value = x$1;
    }

    private FSDataInputStream fileIn() {
        return this.fileIn;
    }

    private void fileIn_$eq(FSDataInputStream x$1) {
        this.fileIn = x$1;
    }

    private Seekable filePosition() {
        return this.filePosition;
    }

    private void filePosition_$eq(Seekable x$1) {
        this.filePosition = x$1;
    }

    private int maxLineLength() {
        return this.maxLineLength;
    }

    private void maxLineLength_$eq(int x$1) {
        this.maxLineLength = x$1;
    }

    private boolean isCompressedInput() {
        return this.isCompressedInput;
    }

    private void isCompressedInput_$eq(boolean x$1) {
        this.isCompressedInput = x$1;
    }

    private Decompressor decompressor() {
        return this.decompressor;
    }

    private void decompressor_$eq(Decompressor x$1) {
        this.decompressor = x$1;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) {
        FileSplit split = (FileSplit)inputSplit;
        Configuration job = context.getConfiguration();
        this.maxLineLength_$eq(job.getInt(this.MAX_LINE_LENGTH(), Integer.MAX_VALUE));
        this.start_$eq(split.getStart());
        this.end_$eq(this.start() + split.getLength());
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(job);
        this.fileIn_$eq(fs.open(file));
        CompressionCodec codec = new CompressionCodecFactory(job).getCodec(file);
        if (codec == null) {
            this.fileIn().seek(this.start());
            this.reader_$eq(new SkipLineReader(this.fileIn(), job, this.recordDelimiterBytes(), split.getLength()));
            this.filePosition_$eq((Seekable)this.fileIn());
        } else {
            this.isCompressedInput_$eq(true);
            this.decompressor_$eq(CodecPool.getDecompressor((CompressionCodec)codec));
            if (codec instanceof SplittableCompressionCodec) {
                SplitCompressionInputStream cIn = ((SplittableCompressionCodec)codec).createInputStream((InputStream)this.fileIn(), this.decompressor(), this.start(), this.end(), SplittableCompressionCodec.READ_MODE.BYBLOCK);
                this.reader_$eq((SplitLineReader)new CompressedSplitLineReader(cIn, job, this.recordDelimiterBytes()));
                this.start_$eq(cIn.getAdjustedStart());
                this.end_$eq(cIn.getAdjustedEnd());
                this.filePosition_$eq((Seekable)cIn);
            } else {
                this.reader_$eq(new SplitLineReader((InputStream)codec.createInputStream((InputStream)this.fileIn(), this.decompressor()), job, this.recordDelimiterBytes()));
                this.filePosition_$eq((Seekable)this.fileIn());
            }
        }
        if (this.start() != 0L) {
            this.start_$eq(this.start() + (long)this.reader().readLine(new Text(), 0, this.maxBytesToConsume(this.start())));
        }
        this.pos_$eq(this.start());
    }

    private int maxBytesToConsume(long pos) {
        return this.isCompressedInput() ? Integer.MAX_VALUE : (int)Math.max(Math.min(Integer.MAX_VALUE, this.end() - pos), (long)this.maxLineLength());
    }

    private long getFilePosition() {
        return this.isCompressedInput() && this.filePosition() != null ? this.filePosition().getPos() : this.pos();
    }

    /*
     * WARNING - void declaration
     */
    public boolean nextKeyValue() {
        void var3_3;
        boolean bl;
        if (this.key() == null) {
            this.key_$eq(new LongWritable());
        }
        this.key().set(this.pos());
        if (this.value() == null) {
            this.value_$eq(new Text());
        }
        int newSize = 0;
        boolean bl2 = false;
        while (!bl2 && (this.getFilePosition() <= this.end() || this.reader().needAdditionalRecordAfterSplit())) {
            if (this.pos() == 0L) {
                newSize = this.skipUtfByteOrderMark();
            } else {
                newSize = this.reader().readLine(this.value(), this.maxLineLength(), this.maxBytesToConsume(this.pos()));
                this.pos_$eq(this.pos() + (long)newSize);
            }
            if (newSize != 0 && newSize >= this.maxLineLength()) continue;
            bl2 = true;
        }
        if (newSize == 0) {
            this.key_$eq(null);
            this.value_$eq(null);
            bl = false;
        } else {
            bl = true;
        }
        boolean ret = bl;
        return (boolean)var3_3;
    }

    public LongWritable getCurrentKey() {
        return this.key();
    }

    public float getProgress() {
        return this.start() == this.end() ? 0.0f : Math.min(1.0f, (float)((double)(this.pos() - this.start()) / (double)(this.end() - this.start())));
    }

    public Text getCurrentValue() {
        return this.value();
    }

    public void close() {
        this.reader().close();
    }

    /*
     * WARNING - void declaration
     */
    private int skipUtfByteOrderMark() {
        void var2_2;
        int newMaxLineLength = (int)Math.min(3L + (long)this.maxLineLength(), Integer.MAX_VALUE);
        int newSize = this.reader().readLine(this.value(), newMaxLineLength, this.maxBytesToConsume(this.pos()));
        this.pos_$eq(this.pos() + (long)newSize);
        int textLength = this.value().getLength();
        byte[] textBytes = this.value().getBytes();
        if (textLength >= 3 && textBytes[0] == (byte)239 && textBytes[1] == (byte)187 && textBytes[2] == (byte)191) {
            this.LOG().info("Found UTF-8 BOM and skipped it");
            newSize -= 3;
            if ((textLength -= 3) > 0) {
                textBytes = this.value().copyBytes();
                this.value().set(textBytes, 3, textLength);
            } else {
                this.value().clear();
            }
        }
        return (int)var2_2;
    }

    public TurtleRecordReader(byte[] recordDelimiterBytes) {
        this.recordDelimiterBytes = recordDelimiterBytes;
        this.LOG = LoggerFactory.getLogger(TurtleRecordReader.class);
        this.MAX_LINE_LENGTH = "mapreduce.input.linerecordreader.line.maxlength";
        this.start = 0L;
        this.end = 0L;
        this.pos = 0L;
        this.reader = null;
        this.key = new LongWritable();
        this.value = new Text();
        this.fileIn = null;
        this.filePosition = null;
        this.maxLineLength = 0;
        this.isCompressedInput = false;
        this.decompressor = null;
    }
}

