/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.model.ds;

import net.sansa_stack.rdf.common.io.ntriples.JenaTripleToNTripleString;
import net.sansa_stack.rdf.spark.model.package$;
import net.sansa_stack.rdf.spark.utils.NodeUtils$;
import net.sansa_stack.rdf.spark.utils.SchemaUtils$;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;

public final class TripleOps$ {
    public static final TripleOps$ MODULE$;
    private transient SparkSession spark;

    static {
        new TripleOps$();
    }

    public RDD<Triple> toRDD(Dataset<Triple> triples) {
        return triples.rdd();
    }

    public Dataset<Row> toDF(Dataset<Triple> triples) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        StructType schema = SchemaUtils$.MODULE$.SQLSchemaDefault();
        RDD rowRDD = triples.rdd().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Row apply(Triple t) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{NodeUtils$.MODULE$.getNodeValue(t.getSubject()), NodeUtils$.MODULE$.getNodeValue(t.getPredicate()), NodeUtils$.MODULE$.getNodeValue(t.getObject())}));
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        Dataset df = spark.createDataFrame(rowRDD, schema);
        df.createOrReplaceTempView("TRIPLES");
        return df;
    }

    public Dataset<Triple> getTriples(Dataset<Triple> triples) {
        return triples;
    }

    public Dataset<Triple> find(Dataset<Triple> triples, Option<Node> subject, Option<Node> predicate, Option<Node> object) {
        return triples.filter((Function1)new Serializable(subject, predicate, object){
            public static final long serialVersionUID = 0L;
            private final Option subject$1;
            private final Option predicate$1;
            private final Option object$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Triple t) {
                Option option = this.subject$1;
                None$ none$ = None$.MODULE$;
                if (option == null ? none$ != null : !option.equals(none$)) {
                    if (!t.getSubject().matches((Node)this.subject$1.get())) return false;
                }
                Option option2 = this.predicate$1;
                None$ none$2 = None$.MODULE$;
                if (option2 == null ? none$2 != null : !option2.equals(none$2)) {
                    if (!t.getPredicate().matches((Node)this.predicate$1.get())) return false;
                }
                Option option3 = this.object$1;
                None$ none$3 = None$.MODULE$;
                if (option3 == null) {
                    if (none$3 == null) return true;
                } else if (option3.equals(none$3)) return true;
                if (!t.getObject().matches((Node)this.object$1.get())) return false;
                return true;
            }
            {
                this.subject$1 = subject$1;
                this.predicate$1 = predicate$1;
                this.object$1 = object$1;
            }
        });
    }

    public Dataset<Triple> find(Dataset<Triple> triples, Triple triple) {
        return this.find(triples, (Option<Node>)(triple.getSubject().isVariable() ? None$.MODULE$ : Option$.MODULE$.apply((Object)triple.getSubject())), (Option<Node>)(triple.getPredicate().isVariable() ? None$.MODULE$ : Option$.MODULE$.apply((Object)triple.getPredicate())), (Option<Node>)(triple.getObject().isVariable() ? None$.MODULE$ : Option$.MODULE$.apply((Object)triple.getObject())));
    }

    public Option<Node> find$default$2() {
        return None$.MODULE$;
    }

    public Option<Node> find$default$3() {
        return None$.MODULE$;
    }

    public Option<Node> find$default$4() {
        return None$.MODULE$;
    }

    public long size(Dataset<Triple> triples) {
        return triples.count();
    }

    public Dataset<Triple> union(Dataset<Triple> triples, Dataset<Triple> other) {
        return triples.union(other);
    }

    public Dataset<Triple> unionAll(Dataset<Triple> triples, Seq<Dataset<Triple>> others) {
        return (Dataset)others.reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Dataset<Triple> apply(Dataset<Triple> x$1, Dataset<Triple> x$2) {
                return x$1.union(x$2);
            }
        });
    }

    public Dataset<Triple> intersection(Dataset<Triple> triples, Dataset<Triple> other) {
        return triples.intersect(other);
    }

    public Dataset<Triple> difference(Dataset<Triple> triples, Dataset<Triple> other) {
        return triples.except(other);
    }

    public boolean contains(Dataset<Triple> triples, Option<Node> subject, Option<Node> predicate, Option<Node> object) {
        return this.find(triples, subject, predicate, object).count() > 0L;
    }

    public boolean contains(Dataset<Triple> triples, Triple triple) {
        return this.find(triples, triple).count() > 0L;
    }

    public Option<Node> contains$default$2() {
        return None$.MODULE$;
    }

    public Option<Node> contains$default$3() {
        return None$.MODULE$;
    }

    public Option<Node> contains$default$4() {
        return None$.MODULE$;
    }

    public boolean containsAny(Dataset<Triple> triples, Dataset<Triple> other) {
        return this.difference(triples, other).count() > 0L;
    }

    public boolean containsAll(Dataset<Triple> triples, Dataset<Triple> other) {
        return this.difference(triples, other).count() == 0L;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public Dataset<Triple> add(Dataset<Triple> triples, Triple triple) {
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Triple[]{triple}));
        int x$4 = qual$1.parallelize$default$2();
        RDD statement = qual$1.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(Triple.class));
        return this.union(triples, package$.MODULE$.TripleOperations((RDD<Triple>)statement).toDS());
    }

    public Dataset<Triple> addAll(Dataset<Triple> triples, Seq<Triple> triple) {
        SparkContext qual$2 = this.spark().sparkContext();
        Seq<Triple> x$5 = triple;
        int x$6 = qual$2.parallelize$default$2();
        RDD statements = qual$2.parallelize(x$5, x$6, ClassTag$.MODULE$.apply(Triple.class));
        return this.union(triples, package$.MODULE$.TripleOperations((RDD<Triple>)statements).toDS());
    }

    public Dataset<Triple> remove(Dataset<Triple> triples, Triple triple) {
        SparkContext qual$3 = this.spark().sparkContext();
        Seq x$7 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Triple[]{triple}));
        int x$8 = qual$3.parallelize$default$2();
        RDD statement = qual$3.parallelize(x$7, x$8, ClassTag$.MODULE$.apply(Triple.class));
        return this.difference(triples, package$.MODULE$.TripleOperations((RDD<Triple>)statement).toDS());
    }

    public Dataset<Triple> removeAll(Dataset<Triple> triples, Seq<Triple> triple) {
        SparkContext qual$4 = this.spark().sparkContext();
        Seq<Triple> x$9 = triple;
        int x$10 = qual$4.parallelize$default$2();
        RDD statements = qual$4.parallelize(x$9, x$10, ClassTag$.MODULE$.apply(Triple.class));
        return this.difference(triples, package$.MODULE$.TripleOperations((RDD<Triple>)statements).toDS());
    }

    public void saveAsNTriplesFile(Dataset<Triple> triples, String path) {
        triples.rdd().map((Function1)new JenaTripleToNTripleString(), ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(path);
    }

    private TripleOps$() {
        MODULE$ = this;
        this.spark = SparkSession$.MODULE$.builder().getOrCreate();
    }
}

