/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.ntriples.parser;

import net.sansa_stack.rdf.spark.ntriples.parser.SilentErrorTokenizerText;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.lang.LangNTuple;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LangNTriplesNoError
extends LangNTuple<Triple> {
    private static Logger messageLog = LoggerFactory.getLogger((String)"N-Triples");

    public LangNTriplesNoError(SilentErrorTokenizerText tokens, ParserProfile profile, StreamRDF dest) {
        super((Tokenizer)tokens, profile, dest);
    }

    public Lang getLang() {
        return RDFLanguages.NTRIPLES;
    }

    protected final void runParser() {
        while (this.hasNext()) {
            Triple x = this.parseOne();
            if (x == null) continue;
            this.dest.triple(x);
        }
    }

    protected final Triple parseOne() {
        try {
            System.out.println("subject");
            Token sToken = this.nextToken();
            if (sToken.isEOF()) {
                this.exception(sToken, "Premature end of file: %s", new Object[]{sToken});
            }
            System.out.println("predicate");
            Token pToken = this.nextToken();
            if (pToken.isEOF()) {
                this.exception(pToken, "Premature end of file: %s", new Object[]{pToken});
            }
            System.out.println("object");
            Token oToken = this.nextToken();
            if (oToken.isEOF()) {
                this.exception(oToken, "Premature end of file: %s", new Object[]{oToken});
            }
            this.checkIRIOrBNode(sToken);
            this.checkIRI(pToken);
            this.checkRDFTerm(oToken);
            Token x = this.nextToken();
            if (x.getType() != TokenType.DOT) {
                this.exception(x, "Triple not terminated by DOT: %s", new Object[]{x});
            }
            Node s = this.tokenAsNode(sToken);
            Node p = this.tokenAsNode(pToken);
            Node o = this.tokenAsNode(oToken);
            return this.profile.createTriple(s, p, o, sToken.getLine(), sToken.getColumn());
        }
        catch (RiotException e) {
            return null;
        }
    }

    protected final Node tokenAsNode(Token token) {
        return this.profile.create(null, token);
    }
}

