/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.utils.kryo.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.function.Function;
import net.sansa_stack.rdf.spark.utils.kryo.io.JavaKryoSerializer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public class JavaKryoSerializationWrapper<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient T value;
    protected ClassTag<T> classTag;
    protected byte[] valueSerialized;

    public JavaKryoSerializationWrapper(T value) {
        this.value = value;
        Class<?> clazz = value.getClass();
        this.classTag = ClassTag$.MODULE$.apply(clazz);
    }

    public byte[] getValueSerialized() {
        this.valueSerialized = JavaKryoSerializer.serialize(this.classTag, this.value);
        return this.valueSerialized;
    }

    public void setValueSerialized(byte[] bytes) {
        this.valueSerialized = bytes;
        this.value = JavaKryoSerializer.deserialize(this.classTag, this.valueSerialized);
    }

    public T getValue() {
        return this.value;
    }

    public static <I, O> Function<I, O> wrap(Function<I, O> fn) {
        JavaKryoSerializationWrapper wrapper = new JavaKryoSerializationWrapper(fn);
        Function<Object, Object> result = i -> ((Function)wrapper.getValue()).apply(i);
        return result;
    }

    public static <I, O> org.apache.spark.api.java.function.Function<I, O> wrap(org.apache.spark.api.java.function.Function<I, O> fn) {
        JavaKryoSerializationWrapper wrapper = new JavaKryoSerializationWrapper(fn);
        org.apache.spark.api.java.function.Function & Serializable result = (org.apache.spark.api.java.function.Function & Serializable)i -> ((org.apache.spark.api.java.function.Function)wrapper.getValue()).call(i);
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getValueSerialized();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.setValueSerialized(this.valueSerialized);
    }
}

