/*
 * Decompiled with CFR 0.152.
 */
package net.sargue.mailgun;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import net.sargue.mailgun.Mail;
import net.sargue.mailgun.MailBuilder;
import net.sargue.mailgun.MailRequestCallbackFactory;
import net.sargue.mailgun.MailSendFilter;
import net.sargue.mailgun.content.ContentConverter;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

public class Configuration {
    private String apiUrl = "https://api.mailgun.net/v3";
    private String domain;
    private String apiKey;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private MultivaluedMap<String, String> defaultParameters = new MultivaluedHashMap();
    private final Client client = JerseyClientBuilder.newClient();
    private MailRequestCallbackFactory mailRequestCallbackFactory = null;
    private MailSendFilter mailSendFilter = defaultFilter;
    private final List<Converter<?>> converters = Collections.synchronizedList(new ArrayList());
    private static final ContentConverter<Object> defaultConverter = new ContentConverter<Object>(){

        @Override
        public String toString(Object value) {
            return value.toString();
        }
    };
    private static final MailSendFilter defaultFilter = new MailSendFilter(){

        @Override
        public boolean filter(Mail mail) {
            return true;
        }
    };

    public Configuration() {
    }

    public Configuration(String domain, String apiKey, String from) {
        this.domain = domain;
        this.apiKey = apiKey;
        this.from(from);
    }

    @Deprecated
    public Configuration copy() {
        Configuration copy = new Configuration();
        copy.apiUrl = this.apiUrl;
        copy.domain = this.domain;
        copy.apiKey = this.apiKey;
        copy.mailRequestCallbackFactory = this.mailRequestCallbackFactory;
        copy.mailSendFilter = this.mailSendFilter;
        copy.defaultParameters = new MultivaluedHashMap(this.defaultParameters);
        copy.converters.addAll(this.converters);
        return copy;
    }

    public Configuration domain(String domain) {
        this.domain = domain;
        return this;
    }

    public Configuration apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public Configuration from(String from) {
        this.defaultParameters.putSingle((Object)"from", (Object)from);
        return this;
    }

    public Configuration from(String name, String email) {
        return this.from(MailBuilder.email(name, email));
    }

    public Configuration apiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        return this;
    }

    public Configuration connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        this.client.property("jersey.config.client.connectTimeout", (Object)(connectTimeout == 0 ? null : Integer.valueOf(connectTimeout)));
        return this;
    }

    public Configuration readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        this.client.property("jersey.config.client.readTimeout", (Object)(readTimeout == 0 ? null : Integer.valueOf(readTimeout)));
        return this;
    }

    public Configuration addDefaultParameter(String name, String value) {
        this.defaultParameters.add((Object)name, (Object)value);
        return this;
    }

    public Configuration clearDefaultParameter(String name) {
        this.defaultParameters.remove((Object)name);
        return this;
    }

    public Configuration registerMailRequestCallbackFactory(MailRequestCallbackFactory factory) {
        this.mailRequestCallbackFactory = factory;
        return this;
    }

    public Configuration unregisterMailRequestCallbackFactory() {
        this.mailRequestCallbackFactory = null;
        return this;
    }

    public Configuration registerMailSendFilter(MailSendFilter mailSendFilter) {
        this.mailSendFilter = mailSendFilter;
        return this;
    }

    public String domain() {
        return this.domain;
    }

    public String apiKey() {
        return this.apiKey;
    }

    public String from() {
        return (String)this.defaultParameters.getFirst((Object)"from");
    }

    public String apiUrl() {
        return this.apiUrl;
    }

    public int connectTimeout() {
        return this.connectTimeout;
    }

    public int readTimeout() {
        return this.readTimeout;
    }

    public Map<String, List<String>> defaultParameters() {
        return this.defaultParameters;
    }

    public MailRequestCallbackFactory mailRequestCallbackFactory() {
        return this.mailRequestCallbackFactory;
    }

    public MailSendFilter mailSendFilter() {
        return this.mailSendFilter;
    }

    public <T> Configuration registerConverter(ContentConverter<? super T> converter, Class<T> classToConvert) {
        this.converters.add(new Converter<T>(classToConvert, converter));
        return this;
    }

    public <T> ContentConverter<T> converter(Class<T> classToConvert) {
        for (Converter<?> converter : this.converters) {
            if (!((Converter)converter).classOfConverter.isAssignableFrom(classToConvert)) continue;
            return ((Converter)converter).contentConverter;
        }
        return defaultConverter;
    }

    public void close() {
        this.client.close();
    }

    private HttpAuthenticationFeature httpAuthenticationFeature() {
        return HttpAuthenticationFeature.basicBuilder().credentials("api", this.apiKey()).build();
    }

    WebTarget getTarget() {
        return (WebTarget)this.client.target(this.apiUrl).register((Object)this.httpAuthenticationFeature());
    }

    private static final class Converter<T> {
        private final Class<T> classOfConverter;
        private final ContentConverter<? super T> contentConverter;

        Converter(Class<T> classOfConverter, ContentConverter<? super T> contentConverter) {
            this.classOfConverter = classOfConverter;
            this.contentConverter = contentConverter;
        }
    }
}

