/*
 * Decompiled with CFR 0.152.
 */
package net.sargue.mailgun;

import java.util.Objects;
import javax.ws.rs.core.Form;
import net.sargue.mailgun.Configuration;
import net.sargue.mailgun.Mail;
import net.sargue.mailgun.MailForm;
import net.sargue.mailgun.MultipartBuilder;
import net.sargue.mailgun.content.Body;
import net.sargue.mailgun.content.Builder;
import net.sargue.mailgun.content.MailContent;

public class MailBuilder {
    private final Configuration configuration;
    private Form form = new Form();

    public MailBuilder(Configuration configuration) {
        this.configuration = configuration;
    }

    public static MailBuilder using(Configuration configuration) {
        return new MailBuilder(configuration);
    }

    public Configuration configuration() {
        return this.configuration;
    }

    Form form() {
        return this.form;
    }

    public MailBuilder from(String from) {
        return this.from(null, from);
    }

    public MailBuilder from(String name, String email) {
        return this.param("from", MailBuilder.email(name, email));
    }

    public MailBuilder to(String to) {
        return this.to(null, to);
    }

    public MailBuilder to(String name, String email) {
        return this.param("to", MailBuilder.email(name, email));
    }

    public MailBuilder cc(String cc) {
        return this.cc(null, cc);
    }

    public MailBuilder cc(String name, String email) {
        return this.param("cc", MailBuilder.email(name, email));
    }

    public MailBuilder bcc(String bcc) {
        return this.bcc(null, bcc);
    }

    public MailBuilder bcc(String name, String email) {
        return this.param("bcc", MailBuilder.email(name, email));
    }

    public MailBuilder replyTo(String email) {
        return this.param("h:Reply-To", email);
    }

    public MailBuilder subject(String subject) {
        return this.param("subject", subject);
    }

    public MailBuilder text(String text) {
        return this.param("text", text);
    }

    public MailBuilder html(String html) {
        return this.param("html", html);
    }

    @Deprecated
    public MailBuilder content(MailContent content) {
        return this.text(content.text()).html(content.html());
    }

    public MailBuilder content(Body body) {
        return this.text(body.text()).html(body.html());
    }

    public MailBuilder template(String templateName) {
        return this.param("template", templateName);
    }

    public MailBuilder variables(String variables) {
        return this.param("h:X-Mailgun-Variables", variables);
    }

    public Builder body() {
        return new Builder(this);
    }

    public MailBuilder parameter(String name, String value) {
        return this.param(name, value);
    }

    public MultipartBuilder multipart() {
        return new MultipartBuilder(this);
    }

    public Mail build() {
        return new MailForm(this.configuration, this.form);
    }

    static String email(String name, String email) {
        return name == null ? email : name + " <" + email + ">";
    }

    private MailBuilder param(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        this.form.param(name, value);
        return this;
    }
}

