/*
 * Decompiled with CFR 0.152.
 */
package net.sargue.mailgun.content;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import net.sargue.mailgun.Configuration;
import net.sargue.mailgun.MailBuilder;
import net.sargue.mailgun.content.Body;
import net.sargue.mailgun.content.ContentConverter;
import net.sargue.mailgun.content.MessageBuilder;
import net.sargue.mailgun.content.Util;

public class Builder {
    private static final String PRE_HTML = "<!DOCTYPE html><html><head>\r\n<meta name='viewport' content='width=device-width' /><meta http-equiv='Content-Type' content='text/html; charset=UTF-8' /></head><body>\r\n";
    private static final String POST_HTML = "\r\n<br></body></html>";
    private static final List<String> newLineAfterTheseTags = Arrays.asList("</h1>", "</h2>", "</h3>", "</h4>", "</h5>", "</h6>", "</p>", "</pre>", "</table>", "</thead>", "</tbody>", "</tfoot>", "</tr>");
    private MessageBuilder html = new MessageBuilder().a("<!DOCTYPE html><html><head>\r\n<meta name='viewport' content='width=device-width' /><meta http-equiv='Content-Type' content='text/html; charset=UTF-8' /></head><body>\r\n");
    private MessageBuilder text = new MessageBuilder();
    private Deque<String> ends = new ArrayDeque<String>();
    private Configuration configuration;
    private MailBuilder mailBuilder;

    public Builder(Configuration configuration) {
        this.configuration = configuration;
    }

    public Builder(MailBuilder mailBuilder) {
        this.mailBuilder = mailBuilder;
        this.configuration = mailBuilder.configuration();
    }

    public Body build() {
        if (!this.ends.isEmpty()) {
            throw new IllegalStateException("Pending some closing. Some end() missing. ends=" + this.ends);
        }
        this.html.a(POST_HTML);
        return new Body(this.html, this.text);
    }

    public MailBuilder mail() {
        if (this.mailBuilder != null) {
            return this.mailBuilder.content(this.build());
        }
        return MailBuilder.using(this.configuration).content(this.build());
    }

    public Builder end() {
        if (this.ends.isEmpty()) {
            throw new IllegalStateException("No pending tag/section to close.");
        }
        String tag = this.ends.pop();
        this.html.a(tag);
        if (newLineAfterTheseTags.contains(tag.toLowerCase())) {
            this.html.nl();
            this.text.nl();
        }
        return this;
    }

    public Builder text(String s) {
        if (s == null) {
            return this;
        }
        this.html.a(Util.escapeXml(s));
        this.text.a(s);
        return this;
    }

    public <T> Builder text(T value) {
        if (value == null) {
            return this;
        }
        return this.text(value, this.configuration.converter(value.getClass()));
    }

    public <T> Builder text(T value, ContentConverter<T> converter) {
        return this.text(converter.toString(value));
    }

    public Builder h1(String content) {
        return this.tag("h1").text(content).end();
    }

    public Builder h1() {
        return this.tag("h1");
    }

    public Builder h2() {
        return this.tag("h2");
    }

    public Builder h2(String content) {
        return this.tag("h2").text(content).end();
    }

    public Builder h3() {
        return this.tag("h3");
    }

    public Builder h3(String content) {
        return this.tag("h3").text(content).end();
    }

    public Builder h4() {
        return this.tag("h4");
    }

    public Builder h4(String content) {
        return this.tag("h4").text(content).end();
    }

    public Builder h5() {
        return this.tag("h5");
    }

    public Builder h5(String content) {
        return this.tag("h5").text(content).end();
    }

    public Builder h6() {
        return this.tag("h6");
    }

    public Builder h6(String content) {
        return this.tag("h6").text(content).end();
    }

    public Builder br() {
        this.html.a("<br>");
        this.text.nl(2);
        return this;
    }

    public Builder p() {
        return this.tag("p");
    }

    public Builder p(String content) {
        return this.tag("p").text(content).end();
    }

    public Builder pre() {
        return this.tag("pre");
    }

    public Builder pre(String content) {
        return this.tag("pre").text(content).end();
    }

    public Builder em() {
        return this.tag("em");
    }

    public Builder em(String content) {
        return this.tag("em").text(content).end();
    }

    public Builder strong() {
        return this.tag("strong");
    }

    public Builder strong(String content) {
        return this.tag("strong").text(content).end();
    }

    public Builder table() {
        return this.tag("table", "border='1' cellpadding='0' cellspacing='0'");
    }

    public Builder row() {
        return this.tag("tr");
    }

    public <T> Builder row(T firstCell) {
        return this.tag("tr").cell(firstCell).end();
    }

    public <T> Builder row(T firstCell, T secondCell) {
        return this.tag("tr").cell(firstCell, false).cell(secondCell).end();
    }

    public <T> Builder rowh(String label, T data) {
        return this.tag("tr").cellHeader(label, false).cell(data).end();
    }

    public <T> Builder row(T firstCell, T secondCell, T thirdCell) {
        return this.tag("tr").cell(firstCell, false).cell(secondCell, false).cell(thirdCell).end();
    }

    public <T> Builder row(T firstCell, T secondCell, T thirdCell, T fourthCell) {
        return this.tag("tr").cell(firstCell, false).cell(secondCell, false).cell(thirdCell, false).cell(fourthCell).end();
    }

    public Builder cell() {
        return this.tag("td");
    }

    public Builder cellHeader() {
        return this.tag("th");
    }

    public <T> Builder cell(T content) {
        return this.cell(content, true);
    }

    public <T> Builder cellHeader(T content) {
        return this.cellHeader().text(content).end();
    }

    private <T> Builder cell(T content, boolean lastCell) {
        this.cell().text(content).end();
        if (!lastCell) {
            this.text.a(',');
        }
        return this;
    }

    private Builder cellHeader(String label, boolean lastCell) {
        this.cellHeader().text(label).end();
        if (!lastCell) {
            this.text.a(',');
        }
        return this;
    }

    public Builder link(String href) {
        return this.link(href, href);
    }

    public Builder link(String href, String textContent) {
        this.text.a(textContent).a(" : ").a(href);
        this.tag("a", "href='" + href + "' target='_blank'");
        this.html.a(textContent);
        return this.end();
    }

    public Builder tag(String tag) {
        this.ends.push("</" + tag + ">");
        this.html.a('<').a(tag).a('>');
        return this;
    }

    public Builder tag(String tag, String attributes) {
        this.ends.push("</" + tag + ">");
        this.html.a('<').a(tag).sp().a(attributes).a('>');
        return this;
    }
}

