/*
 * Decompiled with CFR 0.152.
 */
package net.sargue.mailgun;

import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import net.sargue.mailgun.Configuration;
import net.sargue.mailgun.MailBuilder;
import net.sargue.mailgun.MailRequestCallback;
import net.sargue.mailgun.MailRequestCallbackFactory;
import net.sargue.mailgun.Response;

public abstract class Mail {
    private final Configuration configuration;

    Mail(Configuration configuration) {
        this.configuration = configuration;
    }

    public static MailBuilder using(Configuration configuration) {
        return new MailBuilder(configuration);
    }

    public abstract String getFirstValue(String var1);

    public abstract List<String> getValues(String var1);

    public Response send() {
        if (!this.configuration.mailSendFilter().filter(this)) {
            return null;
        }
        this.prepareSend();
        return new Response(this.request().post(this.entity()));
    }

    public void sendAsync(final MailRequestCallback callback) {
        if (!this.configuration.mailSendFilter().filter(this)) {
            return;
        }
        this.prepareSend();
        this.request().async().post(this.entity(), (InvocationCallback)new InvocationCallback<javax.ws.rs.core.Response>(){

            public void completed(javax.ws.rs.core.Response o) {
                callback.completed(new Response(o));
            }

            public void failed(Throwable throwable) {
                callback.failed(throwable);
            }
        });
    }

    public void sendAsync() {
        if (!this.configuration.mailSendFilter().filter(this)) {
            return;
        }
        MailRequestCallbackFactory factory = this.configuration.mailRequestCallbackFactory();
        if (factory == null) {
            this.prepareSend();
            this.request().async().post(this.entity());
        } else {
            this.sendAsync(factory.create(this));
        }
    }

    public Configuration configuration() {
        return this.configuration;
    }

    abstract Entity<?> entity();

    abstract void prepareSend();

    void configureTarget(WebTarget target) {
    }

    private Invocation.Builder request() {
        WebTarget target = this.configuration.getTarget();
        this.configureTarget(target);
        return target.path(this.configuration.domain()).path("messages").request();
    }
}

