/*
 * Decompiled with CFR 0.152.
 */
package net.sargue.mailgun;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sargue.mailgun.Configuration;
import net.sargue.mailgun.Mail;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

class MailMultipart
extends Mail {
    private final FormDataMultiPart form;

    MailMultipart(Configuration configuration, FormDataMultiPart form) {
        super(configuration);
        this.form = form;
    }

    @Override
    public String getFirstValue(String param) {
        FormDataBodyPart bodyPart = this.form.getField(param);
        return bodyPart == null ? null : bodyPart.getValue();
    }

    @Override
    public List<String> getValues(String param) {
        List bodyParts = this.form.getFields(param);
        if (bodyParts == null) {
            return Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>(bodyParts.size());
        for (FormDataBodyPart bodyPart : bodyParts) {
            values.add(bodyPart.getValue());
        }
        return values;
    }

    @Override
    Entity<?> entity() {
        return Entity.entity((Object)this.form, (MediaType)this.form.getMediaType());
    }

    @Override
    void prepareSend() {
        Map<String, List<String>> def = this.configuration().defaultParameters();
        for (Map.Entry<String, List<String>> entry : def.entrySet()) {
            if (this.form.getField(entry.getKey()) != null) continue;
            for (String value : entry.getValue()) {
                this.form.field(entry.getKey(), value);
            }
        }
    }

    @Override
    void configureTarget(WebTarget target) {
        target.register(MultiPartFeature.class);
    }
}

