/*
 * Decompiled with CFR 0.152.
 */
package net.sargue.mailgun;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import net.sargue.mailgun.Configuration;
import net.sargue.mailgun.Mail;
import net.sargue.mailgun.MailBuilder;
import net.sargue.mailgun.MailMultipart;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;

public class MultipartBuilder {
    private static final String ATTACHMENT_NAME = "attachment";
    private final Configuration configuration;
    private final FormDataMultiPart form = new FormDataMultiPart();

    MultipartBuilder(MailBuilder mailBuilder) {
        this.configuration = mailBuilder.configuration();
        MultivaluedMap map = mailBuilder.form().asMap();
        for (Map.Entry entry : map.entrySet()) {
            for (String value : (List)entry.getValue()) {
                this.form.field((String)entry.getKey(), value);
            }
        }
    }

    public MultipartBuilder attachment(File file) {
        return this.bodyPart((BodyPart)new FileDataBodyPart(ATTACHMENT_NAME, file));
    }

    public MultipartBuilder attachment(InputStream is) {
        return this.bodyPart((BodyPart)new StreamDataBodyPart(ATTACHMENT_NAME, is));
    }

    public MultipartBuilder attachment(InputStream is, String filename) {
        return this.bodyPart((BodyPart)new StreamDataBodyPart(ATTACHMENT_NAME, is, filename));
    }

    public MultipartBuilder attachment(InputStream is, String filename, MediaType mediaType) {
        return this.bodyPart((BodyPart)new StreamDataBodyPart(ATTACHMENT_NAME, is, filename, mediaType));
    }

    public MultipartBuilder attachment(String content, String filename) {
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
        return this.bodyPart((BodyPart)new StreamDataBodyPart(ATTACHMENT_NAME, (InputStream)is, filename));
    }

    public MultipartBuilder inline(InputStream is, String cidName) {
        return this.bodyPart((BodyPart)new StreamDataBodyPart("inline", is, cidName));
    }

    public Mail build() {
        return new MailMultipart(this.configuration, this.form);
    }

    private MultipartBuilder bodyPart(BodyPart bodyPart) {
        this.form.bodyPart(bodyPart);
        return this;
    }
}

