/*
 * Decompiled with CFR 0.152.
 */
package net.sargue.mailgun;

public class Response {
    private final ResponseType responseType;
    private final int responseCode;
    private final String responseMessage;

    Response(jakarta.ws.rs.core.Response response) {
        this.responseCode = response.getStatus();
        this.responseMessage = (String)response.readEntity(String.class);
        switch (this.responseCode) {
            case 200: {
                this.responseType = ResponseType.OK;
                break;
            }
            case 400: {
                this.responseType = ResponseType.BAD_REQUEST;
                break;
            }
            case 401: {
                this.responseType = ResponseType.UNAUTHORIZED;
                break;
            }
            case 402: {
                this.responseType = ResponseType.REQUEST_FAILED;
                break;
            }
            case 404: {
                this.responseType = ResponseType.NOT_FOUND;
                break;
            }
            default: {
                this.responseType = ResponseType.SERVER_ERROR;
            }
        }
    }

    public ResponseType responseType() {
        return this.responseType;
    }

    public int responseCode() {
        return this.responseCode;
    }

    public boolean isOk() {
        return this.responseType == ResponseType.OK;
    }

    public String responseMessage() {
        return this.responseMessage;
    }

    public static enum ResponseType {
        OK,
        BAD_REQUEST,
        UNAUTHORIZED,
        REQUEST_FAILED,
        NOT_FOUND,
        SERVER_ERROR;

    }
}

