/*
 * Decompiled with CFR 0.152.
 */
package net.savantly.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.gen.RSAKeyGenerator;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.core.io.Resource;

public class JwtService {
    private final RSAKey rsaJWK;
    private final RSAKey rsaPublicJWK;
    private final JWSSigner signer;

    public JwtService(String keyId) {
        try {
            this.rsaJWK = (RSAKey)new RSAKeyGenerator(2048).keyID(keyId).generate();
            this.rsaPublicJWK = this.rsaJWK.toPublicJWK();
            this.signer = new RSASSASigner(this.rsaJWK);
        }
        catch (JOSEException ex) {
            throw new RuntimeException(ex);
        }
    }

    public JwtService(Resource privateKeyResource) throws IOException, JOSEException, ParseException {
        JWK jwk = JWK.parseFromPEMEncodedObjects((String)new String(this.readAllBytes(privateKeyResource.getInputStream())));
        String jwkString = jwk.toJSONObject().toString();
        this.rsaJWK = RSAKey.parse((String)jwkString);
        this.rsaPublicJWK = this.rsaJWK.toPublicJWK();
        this.signer = new RSASSASigner(this.rsaJWK);
    }

    public String createJWT(String username) {
        return this.createJWT(username, new ArrayList<String>());
    }

    public String createJWT(String username, List<String> groups) {
        return this.createJWT(username, groups, new ArrayList<String>());
    }

    public String createJWT(String username, List<String> groups, List<String> scopes) {
        return this.createJWT(username, groups, scopes, 60L);
    }

    public String createJWT(String username, List<String> groups, List<String> scopes, long minToExpiration) {
        Date expirationDate = new Date(Instant.now().plus(minToExpiration, ChronoUnit.MINUTES).toEpochMilli());
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject(username).issuer("https://savantly").issueTime(new Date()).expirationTime(expirationDate).claim("groups", groups).claim("scp", scopes).claim("preferred_username", (Object)username).build();
        SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(this.rsaJWK.getKeyID()).build(), claimsSet);
        try {
            signedJWT.sign(this.signer);
        }
        catch (JOSEException e) {
            throw new RuntimeException("Failed while creating the RSA signature for the JWT");
        }
        String s = signedJWT.serialize();
        return s;
    }

    public RSAKey getRsaPublicJWK() {
        return this.rsaPublicJWK;
    }

    byte[] readAllBytes(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int read = 0;
        while (read != -1) {
            baos.write(buf, 0, read);
            read = in.read(buf);
        }
        return baos.toByteArray();
    }
}

