/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.minidev.json.JSONObject;
import org.springframework.security.oauth2.jwt.ReactiveJWKSource;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class ReactiveMultiJwkSource
implements ReactiveJWKSource {
    private final AtomicReference<Mono<JWKSet>> cachedJWKSet = new AtomicReference<Mono>(Mono.empty());
    private ObjectMapper mapper = new ObjectMapper();
    private WebClient webClient = WebClient.create();
    private final String jwkSetURL;
    private final List<RSAKey> publicKeys = new ArrayList<RSAKey>();

    ReactiveMultiJwkSource(String jwkSetURL) {
        this.jwkSetURL = jwkSetURL;
    }

    public void addExtraKeys(RSAKey publicKey) {
        this.publicKeys.add(publicKey);
    }

    public Mono<List<JWK>> get() {
        return this.getJWKSet().flatMap(jwkSet -> Mono.just((Object)jwkSet.getKeys()));
    }

    public Mono<List<JWK>> get(JWKSelector jwkSelector) {
        return this.cachedJWKSet.get().switchIfEmpty(this.getJWKSet()).flatMap(jwkSet -> this.get(jwkSelector, (JWKSet)jwkSet)).switchIfEmpty(this.getJWKSet().map(jwkSet -> jwkSelector.select(jwkSet)));
    }

    private Mono<List<JWK>> get(JWKSelector jwkSelector, JWKSet jwkSet) {
        return Mono.defer(() -> {
            List matches = jwkSelector.select(jwkSet);
            if (!matches.isEmpty()) {
                return Mono.just((Object)matches);
            }
            String soughtKeyID = ReactiveMultiJwkSource.getFirstSpecifiedKeyID(jwkSelector.getMatcher());
            if (soughtKeyID == null) {
                return Mono.just(Collections.emptyList());
            }
            if (jwkSet.getKeyByKeyId(soughtKeyID) != null) {
                return Mono.just(Collections.emptyList());
            }
            return Mono.empty();
        });
    }

    private Mono<JWKSet> getJWKSet() {
        return this.webClient.get().uri(this.jwkSetURL, new Object[0]).retrieve().bodyToMono(String.class).map(this::addExtraKeys).map(this::parse).doOnNext(jwkSet -> this.cachedJWKSet.set((Mono<JWKSet>)Mono.just((Object)jwkSet))).cache();
    }

    private String addExtraKeys(String jwkJson) {
        try {
            JSONObject jsonObj = (JSONObject)this.mapper.readValue(jwkJson, JSONObject.class);
            Object keys = jsonObj.get((Object)"keys");
            if (Collection.class.isAssignableFrom(keys.getClass())) {
                for (RSAKey rsaKey : this.publicKeys) {
                    JWKSet jwkSet = new JWKSet((JWK)rsaKey);
                    ((Collection)keys).addAll((Collection)jwkSet.toJSONObject().get((Object)"keys"));
                }
            }
            return jsonObj.toJSONString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JWKSet parse(String body) {
        try {
            return JWKSet.parse((String)body);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String getFirstSpecifiedKeyID(JWKMatcher jwkMatcher) {
        Set keyIDs = jwkMatcher.getKeyIDs();
        if (keyIDs == null || keyIDs.isEmpty()) {
            return null;
        }
        for (String id : keyIDs) {
            if (id == null) continue;
            return id;
        }
        return null;
    }
}

