/*
 * Decompiled with CFR 0.152.
 */
package net.savantly.authorization.service;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.savantly.authorization.jdbc.RolePermissions;
import net.savantly.authorization.jdbc.RolePermissionsRepository;
import net.savantly.authorization.service.PermissionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcPermissionProvider
implements PermissionProvider {
    private static final Logger log = LoggerFactory.getLogger(JdbcPermissionProvider.class);
    private RolePermissionsRepository rolePermissionsRepository;

    public JdbcPermissionProvider(RolePermissionsRepository rolePermissionsRepository) {
        this.rolePermissionsRepository = rolePermissionsRepository;
    }

    @Override
    public List<String> getEffectivePermissions(String role) {
        Optional roleMap = this.rolePermissionsRepository.findById(role);
        if (roleMap.isPresent()) {
            if (log.isDebugEnabled()) {
                log.debug("role: {} effective permissions: {}", (Object)role, ((RolePermissions)roleMap.get()).getPermissions());
            }
            return ((RolePermissions)roleMap.get()).getPermissions();
        }
        return Collections.emptyList();
    }
}

