/*
 * Decompiled with CFR 0.152.
 */
package net.savantly.authorization.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.savantly.authorization.service.PermissionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;

public class PermissionAwareJwtAuthenticationConverter
extends JwtAuthenticationConverter {
    private static final Logger log = LoggerFactory.getLogger(PermissionAwareJwtAuthenticationConverter.class);
    private final PermissionProvider permissionProvider;
    private final String groupsClaim;

    public PermissionAwareJwtAuthenticationConverter(PermissionProvider permissionProvider) {
        this(permissionProvider, "groups");
    }

    public PermissionAwareJwtAuthenticationConverter(PermissionProvider permissionProvider, String groupsClaim) {
        this.permissionProvider = permissionProvider;
        this.groupsClaim = groupsClaim;
    }

    protected Collection<GrantedAuthority> extractAuthorities(Jwt jwt) {
        Collection<String> usersGroups = this.getRolesFromClaims(jwt.getClaims());
        Collection allAuthorities = usersGroups.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
        List roleAuthorities = this.getPermissionsFromRoles(usersGroups).stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
        allAuthorities.addAll(roleAuthorities);
        return allAuthorities;
    }

    private List<String> getPermissionsFromRoles(Collection<String> usersRoles) {
        ArrayList<String> effectiveAuthorities = new ArrayList<String>();
        usersRoles.forEach(r -> effectiveAuthorities.addAll(this.permissionProvider.getEffectivePermissions((String)r)));
        if (log.isDebugEnabled()) {
            log.debug("role: {} effective permissions: {}", effectiveAuthorities);
        }
        return effectiveAuthorities;
    }

    private Collection<String> getRolesFromClaims(Map<String, Object> claims) {
        if (this.groupsClaim.contains(".")) {
            String[] pathParts = this.groupsClaim.split("\\.");
            try {
                return (Collection)PermissionAwareJwtAuthenticationConverter.getNestedValue(claims, pathParts);
            }
            catch (Exception e) {
                throw new RuntimeException("failed to extract roles using groupsClaim value: " + this.groupsClaim, e);
            }
        }
        return claims.getOrDefault(this.groupsClaim, new ArrayList());
    }

    private static <T> T getNestedValue(Map map, String ... keys) {
        Map value = map;
        for (String key : keys) {
            value = value.get(key);
        }
        return (T)value;
    }
}

