/*
 * Decompiled with CFR 0.152.
 */
package net.savantly.spring.fixture;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.savantly.spring.fixture.Fixture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.repository.CrudRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBaseFixture<T, R extends CrudRepository<T, ?>>
implements Fixture<T>,
InitializingBean {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean installed = false;
    private Object lock = new Object();
    private List<T> entityList = new ArrayList<T>();
    private List<Fixture<?>> dependencies = new ArrayList();
    private Random random = new Random();
    private R repository;

    public abstract void addEntities(List<T> var1);

    public abstract void addDependencies(List<Fixture<?>> var1);

    public AbstractBaseFixture(R repository) {
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install() {
        if (this.installed) {
            this.log.warn("Fixture already installed");
            return;
        }
        this.log.info("Beginning Fixture Install");
        Object object = this.lock;
        synchronized (object) {
            this.ensureDependenciesAreInstalled();
            this.addEntities(this.entityList);
            this.repository.saveAll(this.entityList);
            this.installed = true;
        }
        this.log.info("Finished Fixture Install");
    }

    public void afterPropertiesSet() throws Exception {
        this.addDependencies(this.dependencies);
    }

    private void ensureDependenciesAreInstalled() {
        this.log.info("Beginning Fixture Dependencies Install");
        for (Fixture<?> fixture : this.dependencies) {
            if (fixture.isInstalled()) continue;
            fixture.install();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstall() {
        if (!this.installed) {
            this.log.warn("Fixture not installed");
            return;
        }
        this.log.info("Beginning Fixture Uninstall");
        Object object = this.lock;
        synchronized (object) {
            this.repository.deleteAll(this.entityList);
            this.entityList.clear();
            this.installed = false;
        }
        this.log.info("Finished Fixture Uninstall");
    }

    @Override
    public boolean isInstalled() {
        return this.installed;
    }

    @Override
    public List<T> getEntityList() {
        return this.entityList;
    }

    @Override
    public T getRandomEntity() {
        if (this.entityList.size() == 0) {
            this.log.warn(String.format("entityList is empty", this.entityList));
            return null;
        }
        int position = this.random.nextInt(this.entityList.size());
        return this.entityList.get(position);
    }
}

