/*
 * Decompiled with CFR 0.152.
 */
package net.savantly.spring.fixture.util;

import java.math.BigDecimal;
import java.util.Random;
import org.joda.time.DateTime;

public class RandomGenerator {
    static final Random random = new Random();
    static final String alphaString = "abcdefghijklmnopqrstuvwxyz";
    static final String digitString = "0123456789";
    static final String alphaNumerics = String.format("%s%s", "abcdefghijklmnopqrstuvwxyz", "0123456789");

    public static String getRandomAlphaNumericString(int length) {
        return RandomGenerator.getRandomString(alphaNumerics, length);
    }

    public static String getRandomAlphaString(int length) {
        return RandomGenerator.getRandomString(alphaString, length);
    }

    public static String getRandomAlphaWordString(int wordCount, int maxWordLength) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < wordCount) {
            buffer.append(RandomGenerator.getRandomAlphaString(maxWordLength));
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    public static String getRandomNumericString(int length) {
        return RandomGenerator.getRandomString(digitString, length);
    }

    public static String getRandomString(String characters, int length) {
        char[] text = new char[length];
        int i = 0;
        while (i < length) {
            text[i] = characters.charAt(random.nextInt(characters.length()));
            ++i;
        }
        return new String(text);
    }

    public static String getRandomString(String ... stringsToPickFrom) {
        return stringsToPickFrom[random.nextInt(stringsToPickFrom.length)];
    }

    public static String getRandomAddress() {
        String roadType = RandomGenerator.getRandomString("Rd.", "Ln.", "Blvd.", "St.");
        String numericPart = RandomGenerator.getRandomNumericString(4);
        String roadName = RandomGenerator.getRandomAlphaString(8);
        return String.format("%s %s %s", numericPart, roadName, roadType);
    }

    public static DateTime getRandomDateTime(boolean futureDateTime) {
        DateTime dateTime = new DateTime();
        int operand = random.nextInt(20000);
        if (futureDateTime) {
            operand *= -1;
        }
        dateTime.minusDays(operand);
        return dateTime;
    }

    public static BigDecimal getRandomMoneyValue(int maxAmount, int decimalPlaces, boolean negative) {
        int dollars = random.nextInt(maxAmount);
        String cents = RandomGenerator.getRandomNumericString(decimalPlaces);
        String total = String.format("%s.%s", dollars, cents);
        BigDecimal returnValue = new BigDecimal(total);
        return returnValue;
    }
}

