/*
 * Decompiled with CFR 0.152.
 */
package net.scarlettsystems.java.jstick;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JStick
extends JPanel {
    private static final float DEFAULT_STICK_SIZE = 0.33f;
    private static final float DEFAULT_ARROW_SIZE = 0.06f;
    private static final float DEFAULT_DEAD_ZONE = 0.0f;
    private static final long CLICK_INTERVAL_MS = 100L;
    private int padDiameter;
    private int padRadius;
    private int stickRadius;
    private float stickSize;
    private float arrowSize;
    private float deadZone;
    private int zeroPointX;
    private int zeroPointY;
    private int outlineWidth = 1;
    private Color outlineColour = Color.BLACK;
    private Color padColour = this.getBackground().brighter();
    private Color stickColour = this.getBackground().brighter().brighter();
    private Color arrowColour = this.getBackground();
    private boolean drawOutline = false;
    private boolean invertY = false;
    private final Point stickPosition = new Point();
    private final Point clickBeginPoint = new Point(-1, -1);
    private final ArrayList<JoystickListener> mJoystickListeners = new ArrayList();
    private boolean dragFlag = false;

    public JStick() {
        this.setStickSize(0.33f);
        this.setArrowSize(0.06f);
        this.setDeadZone(0.0f);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            private void repaintAndTriggerListeners() {
                SwingUtilities.getRoot(JStick.this).repaint();
                for (JoystickListener l : JStick.this.mJoystickListeners) {
                    l.onJoystickMoved(JStick.this);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && JStick.this.isPointOnStick(e.getX(), e.getY())) {
                    ((JStick)JStick.this).clickBeginPoint.x = e.getX();
                    ((JStick)JStick.this).clickBeginPoint.y = e.getY();
                    JStick.this.dragFlag = false;
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && ((JStick)JStick.this).clickBeginPoint.x >= 0 && ((JStick)JStick.this).clickBeginPoint.y >= 0) {
                    JStick.this.updateThumbPos(e.getX() - ((JStick)JStick.this).clickBeginPoint.x, e.getY() - ((JStick)JStick.this).clickBeginPoint.y);
                    this.repaintAndTriggerListeners();
                    JStick.this.dragFlag = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (JStick.this.dragFlag) {
                        JStick.this.centerThumbPad();
                        ((JStick)JStick.this).clickBeginPoint.x = -1;
                        ((JStick)JStick.this).clickBeginPoint.y = -1;
                        this.repaintAndTriggerListeners();
                    } else {
                        for (JoystickListener l : JStick.this.mJoystickListeners) {
                            l.onJoystickClicked(JStick.this);
                        }
                    }
                }
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
        this.setOpaque(false);
        this.centerThumbPad();
    }

    private void centerThumbPad() {
        this.stickPosition.x = 0;
        this.stickPosition.y = 0;
    }

    private boolean isPointOnStick(int x, int y) {
        return Math.sqrt(Math.pow((float)this.getWidth() / 2.0f - (float)x - (float)this.stickPosition.x, 2.0) + Math.pow((float)this.getHeight() / 2.0f - (float)y - (float)this.stickPosition.y, 2.0)) <= (double)this.stickRadius;
    }

    private void updateThumbPos(int mouseX, int mouseY) {
        this.stickPosition.x = mouseX;
        this.stickPosition.y = -mouseY;
        double magnitude = Math.sqrt(Math.pow(this.stickPosition.x, 2.0) + Math.pow(this.stickPosition.y, 2.0));
        double divider = Math.max(magnitude / (double)this.padRadius, 1.0);
        this.stickPosition.x = (int)Math.round((double)this.stickPosition.x / divider);
        this.stickPosition.y = (int)Math.round((double)this.stickPosition.y / divider);
    }

    public float getStickX() {
        if (this.getStickMagnitude() < this.deadZone) {
            return 0.0f;
        }
        return (float)this.stickPosition.x / (float)this.padRadius;
    }

    public float getStickY() {
        if (this.getStickMagnitude() < this.deadZone) {
            return 0.0f;
        }
        return this.invertY ? -((float)this.stickPosition.y) / (float)this.padRadius : (float)this.stickPosition.y / (float)this.padRadius;
    }

    public float getStickMagnitude() {
        return (float)Math.sqrt(Math.pow(this.stickPosition.x, 2.0) + Math.pow(this.stickPosition.y, 2.0));
    }

    public float getStickAngleRadians() {
        return (float)Math.atan2(this.stickPosition.y, this.stickPosition.x);
    }

    public float getStickAngleDegrees() {
        return this.getStickAngleRadians() * 180.0f / (float)Math.PI;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int workingArea = Math.min(this.getWidth(), this.getHeight());
        this.padDiameter = Math.round((float)workingArea / (1.0f + this.stickSize));
        this.padRadius = this.padDiameter / 2;
        int stickDiameter = Math.round((float)workingArea * this.stickSize / (1.0f + this.stickSize));
        this.stickRadius = stickDiameter / 2;
        int arrowRadius = Math.round((float)this.padDiameter * this.arrowSize);
        if (this.getWidth() < this.getHeight()) {
            this.zeroPointX = this.stickRadius;
            this.zeroPointY = this.getHeight() / 2 - this.padRadius;
        } else {
            this.zeroPointX = this.getWidth() / 2 - this.padRadius;
            this.zeroPointY = this.stickRadius;
        }
        if (this.drawOutline) {
            g.setColor(this.outlineColour);
            g.fillOval(this.zeroPointX, this.zeroPointY, this.padDiameter, this.padDiameter);
            g.setColor(this.padColour);
            g.fillOval(this.zeroPointX + this.outlineWidth, this.zeroPointY + this.outlineWidth, this.padDiameter - this.outlineWidth * 2, this.padDiameter - this.outlineWidth * 2);
        } else {
            g.setColor(this.padColour);
            g.fillOval(this.zeroPointX, this.zeroPointY, this.padDiameter, this.padDiameter);
        }
        g.setColor(this.arrowColour);
        int arrowInset = (this.stickRadius + this.padRadius) / 2;
        int xCentrePoint = this.getWidth() / 2;
        int yCentrePoint = this.getHeight() / 2;
        this.fillEquilateralTriangle(g, xCentrePoint, yCentrePoint - arrowInset, arrowRadius, -1.5707964f);
        this.fillEquilateralTriangle(g, xCentrePoint, yCentrePoint + arrowInset, arrowRadius, 1.5707964f);
        this.fillEquilateralTriangle(g, xCentrePoint - arrowInset, yCentrePoint, arrowRadius, (float)Math.PI);
        this.fillEquilateralTriangle(g, xCentrePoint + arrowInset, yCentrePoint, arrowRadius, 0.0f);
        int thumbStartX = xCentrePoint - this.stickRadius + this.stickPosition.x;
        int thumbStartY = yCentrePoint - this.stickRadius - this.stickPosition.y;
        if (this.drawOutline) {
            g.setColor(this.outlineColour);
            g.fillOval(thumbStartX, thumbStartY, stickDiameter, stickDiameter);
            g.setColor(this.stickColour);
            g.fillOval(thumbStartX + this.outlineWidth, thumbStartY + this.outlineWidth, stickDiameter - this.outlineWidth * 2, stickDiameter - this.outlineWidth * 2);
        } else {
            g.setColor(this.stickColour);
            g.fillOval(thumbStartX, thumbStartY, stickDiameter, stickDiameter);
        }
    }

    private void fillEquilateralTriangle(Graphics g, int x, int y, int a, float theta) {
        int centroid = (int)Math.round((double)a * Math.sqrt(3.0) / 6.0);
        int[] xa = new int[]{x + (int)Math.round((double)a * Math.sqrt(3.0) / 3.0), x - centroid, x - centroid};
        int[] ya = new int[]{y, y - a / 2, y + a / 2};
        this.rotatePoints(xa, ya, x, y, theta);
        g.fillPolygon(xa, ya, 3);
    }

    private void rotatePoints(int[] x, int[] y, int x0, int y0, float theta) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Array sizes must be equal");
        }
        Point origin = new Point(x0, y0);
        for (int i = 0; i < x.length; ++i) {
            Point p = new Point(x[i], y[i]);
            Point n = this.rotatePoint(p, origin, theta);
            x[i] = n.x;
            y[i] = n.y;
        }
    }

    private Point rotatePoint(Point p, Point o, float theta) {
        Point n = new Point();
        n.x = (int)Math.round(Math.cos(theta) * (double)(p.x - o.x) - Math.sin(theta) * (double)(p.y - o.y) + (double)o.x);
        n.y = (int)Math.round(Math.sin(theta) * (double)(p.x - o.x) + Math.cos(theta) * (double)(p.y - o.y) + (double)o.y);
        return n;
    }

    public Color getOutlineColour() {
        return this.outlineColour;
    }

    public void setOutlineColour(Color outlineColour) {
        this.outlineColour = outlineColour;
    }

    public Color getPadColour() {
        return this.padColour;
    }

    public void setPadColour(Color padColour) {
        this.padColour = padColour;
    }

    public Color getStickColour() {
        return this.stickColour;
    }

    public void setStickColour(Color stickColour) {
        this.stickColour = stickColour;
    }

    public Color getArrowColour() {
        return this.arrowColour;
    }

    public void setArrowColour(Color arrowColour) {
        this.arrowColour = arrowColour;
    }

    public boolean isDrawOutline() {
        return this.drawOutline;
    }

    public void setDrawOutline(boolean drawOutline) {
        this.drawOutline = drawOutline;
    }

    public float getStickSize() {
        return this.stickSize;
    }

    public void setStickSize(float size) {
        if (size < 0.0f) {
            throw new IllegalArgumentException("Size must be greater than 0");
        }
        if (size > 1.0f) {
            throw new IllegalArgumentException("Size must be smaller than 1");
        }
        this.stickSize = size;
    }

    public float getArrowSize() {
        return this.arrowSize;
    }

    public void setArrowSize(float size) {
        if (size < 0.0f) {
            throw new IllegalArgumentException("Size must be greater than 0");
        }
        if (size > 1.0f) {
            throw new IllegalArgumentException("Size must be smaller than 1");
        }
        this.arrowSize = size;
    }

    public float getDeadZone() {
        return this.deadZone;
    }

    public void setDeadZone(float value) {
        if (value < 0.0f) {
            throw new IllegalArgumentException("Value must be greater than 0");
        }
        if (value > 1.0f) {
            throw new IllegalArgumentException("Value must be smaller than 1");
        }
        this.deadZone = value;
    }

    public void addJoystickListener(JoystickListener l) {
        this.mJoystickListeners.add(l);
    }

    public void removeJoystickListener(JoystickListener l) {
        this.mJoystickListeners.remove(l);
    }

    public void clearJoystickListeners() {
        this.mJoystickListeners.clear();
    }

    public void setInvertYAxis(boolean invert) {
        this.invertY = invert;
    }

    public boolean isYAxisInverted() {
        return this.invertY;
    }

    public static interface JoystickListener {
        public void onJoystickMoved(JStick var1);

        public void onJoystickClicked(JStick var1);
    }
}

