/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj;

import net.schmizz.sshj.Service;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractService
implements Service {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final String name;
    protected final Transport trans;
    protected int timeout;

    public AbstractService(String name, Transport trans) {
        this.name = name;
        this.trans = trans;
        this.timeout = trans.getTimeout();
    }

    public String getName() {
        return this.name;
    }

    public void handle(Message msg, SSHPacket buf) throws SSHException {
        this.trans.sendUnimplemented();
    }

    public void notifyError(SSHException error) {
        this.log.debug("Was notified of {}", (Object)error.toString());
    }

    public void notifyUnimplemented(long seqNum) throws SSHException {
        throw new SSHException(DisconnectReason.PROTOCOL_ERROR, "Unexpected: SSH_MSG_UNIMPLEMENTED");
    }

    public void notifyDisconnect() throws SSHException {
        this.log.debug("Was notified of disconnect");
    }

    public void request() throws TransportException {
        Service active = this.trans.getService();
        if (!this.equals(active)) {
            if (this.name.equals(active.getName())) {
                this.trans.setService(this);
            } else {
                this.trans.reqService(this);
            }
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

