/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Buffer<T extends Buffer<T>> {
    public static final int DEFAULT_SIZE = 256;
    protected byte[] data;
    protected int rpos;
    protected int wpos;

    protected static int getNextPowerOf2(int i) {
        int j;
        for (j = 1; j < i; j <<= 1) {
        }
        return j;
    }

    public Buffer() {
        this(256);
    }

    public Buffer(Buffer<?> from) {
        this.wpos = from.wpos - from.rpos;
        this.data = new byte[this.wpos];
        System.arraycopy(from.data, from.rpos, this.data, 0, this.wpos);
    }

    public Buffer(byte[] data) {
        this(data, true);
    }

    public Buffer(int size) {
        this(new byte[Buffer.getNextPowerOf2(size)], false);
    }

    private Buffer(byte[] data, boolean read) {
        this.data = data;
        this.rpos = 0;
        this.wpos = read ? data.length : 0;
    }

    public byte[] array() {
        return this.data;
    }

    public int available() {
        return this.wpos - this.rpos;
    }

    public void clear() {
        this.rpos = 0;
        this.wpos = 0;
    }

    public int rpos() {
        return this.rpos;
    }

    public void rpos(int rpos) {
        this.rpos = rpos;
    }

    public int wpos() {
        return this.wpos;
    }

    public void wpos(int wpos) {
        this.ensureCapacity(wpos - this.wpos);
        this.wpos = wpos;
    }

    protected void ensureAvailable(int a) {
        if (this.available() < a) {
            throw new BufferException("Underflow");
        }
    }

    public void ensureCapacity(int capacity) {
        if (this.data.length - this.wpos < capacity) {
            int cw = this.wpos + capacity;
            byte[] tmp = new byte[Buffer.getNextPowerOf2(cw)];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }
    }

    public void compact() {
        System.err.println("COMPACTING");
        if (this.available() > 0) {
            System.arraycopy(this.data, this.rpos, this.data, 0, this.wpos - this.rpos);
        }
        this.wpos -= this.rpos;
        this.rpos = 0;
    }

    public byte[] getCompactData() {
        int len = this.available();
        if (len > 0) {
            byte[] b = new byte[len];
            System.arraycopy(this.data, this.rpos, b, 0, len);
            return b;
        }
        return new byte[0];
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public T putBoolean(boolean b) {
        return this.putByte(b ? (byte)1 : 0);
    }

    public byte readByte() {
        this.ensureAvailable(1);
        return this.data[this.rpos++];
    }

    public T putByte(byte b) {
        this.ensureCapacity(1);
        this.data[this.wpos++] = b;
        return (T)this;
    }

    public byte[] readBytes() {
        int len = this.readInt();
        if (len < 0 || len > 32768) {
            throw new BufferException("Bad item length: " + len);
        }
        byte[] b = new byte[len];
        this.readRawBytes(b);
        return b;
    }

    public T putBytes(byte[] b) {
        return this.putBytes(b, 0, b.length);
    }

    public T putBytes(byte[] b, int off, int len) {
        return ((Buffer)this.putInt(len - off)).putRawBytes(b, off, len);
    }

    public void readRawBytes(byte[] buf) {
        this.readRawBytes(buf, 0, buf.length);
    }

    public void readRawBytes(byte[] buf, int off, int len) {
        this.ensureAvailable(len);
        System.arraycopy(this.data, this.rpos, buf, off, len);
        this.rpos += len;
    }

    public T putRawBytes(byte[] d) {
        return this.putRawBytes(d, 0, d.length);
    }

    public T putRawBytes(byte[] d, int off, int len) {
        this.ensureCapacity(len);
        System.arraycopy(d, off, this.data, this.wpos, len);
        this.wpos += len;
        return (T)this;
    }

    public T putBuffer(Buffer<? extends Buffer<?>> buffer) {
        if (buffer != null) {
            int r = buffer.available();
            this.ensureCapacity(r);
            System.arraycopy(buffer.data, buffer.rpos, this.data, this.wpos, r);
            this.wpos += r;
        }
        return (T)this;
    }

    public int readInt() {
        return (int)this.readLong();
    }

    public long readLong() {
        this.ensureAvailable(4);
        return (long)(this.data[this.rpos++] << 24) & 0xFF000000L | (long)(this.data[this.rpos++] << 16) & 0xFF0000L | (long)(this.data[this.rpos++] << 8) & 0xFF00L | (long)this.data[this.rpos++] & 0xFFL;
    }

    public T putInt(long uint32) {
        this.ensureCapacity(4);
        if (uint32 < 0L || uint32 > 0xFFFFFFFFL) {
            throw new BufferException("Invalid value: " + uint32);
        }
        this.data[this.wpos++] = (byte)(uint32 >> 24);
        this.data[this.wpos++] = (byte)(uint32 >> 16);
        this.data[this.wpos++] = (byte)(uint32 >> 8);
        this.data[this.wpos++] = (byte)uint32;
        return (T)this;
    }

    public BigInteger readMPInt() {
        return new BigInteger(this.readMPIntAsBytes());
    }

    public T putMPInt(BigInteger bi) {
        return this.putMPInt(bi.toByteArray());
    }

    public T putMPInt(byte[] foo) {
        int i = foo.length;
        if ((foo[0] & 0x80) != 0) {
            this.putInt(++i);
            this.putByte((byte)0);
        } else {
            this.putInt(i);
        }
        return this.putRawBytes(foo);
    }

    public byte[] readMPIntAsBytes() {
        return this.readBytes();
    }

    public long readUINT64() {
        long uint64 = (this.readLong() << 32) + (this.readLong() & 0xFFFFFFFFL);
        if (uint64 < 0L) {
            throw new BufferException("Cannot handle values > Long.MAX_VALUE");
        }
        return uint64;
    }

    public T putUINT64(long uint64) {
        if (uint64 < 0L) {
            throw new BufferException("Invalid value: " + uint64);
        }
        this.data[this.wpos++] = (byte)(uint64 >> 56);
        this.data[this.wpos++] = (byte)(uint64 >> 48);
        this.data[this.wpos++] = (byte)(uint64 >> 40);
        this.data[this.wpos++] = (byte)(uint64 >> 32);
        this.data[this.wpos++] = (byte)(uint64 >> 24);
        this.data[this.wpos++] = (byte)(uint64 >> 16);
        this.data[this.wpos++] = (byte)(uint64 >> 8);
        this.data[this.wpos++] = (byte)uint64;
        return (T)this;
    }

    public String readString() {
        String s;
        int len = this.readInt();
        if (len < 0 || len > 32768) {
            throw new BufferException("Bad item length: " + len);
        }
        this.ensureAvailable(len);
        try {
            s = new String(this.data, this.rpos, len, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SSHRuntimeException(e);
        }
        this.rpos += len;
        return s;
    }

    public byte[] readStringAsBytes() {
        return this.readBytes();
    }

    public T putString(byte[] str) {
        return this.putBytes(str);
    }

    public T putString(byte[] str, int offset, int len) {
        return this.putBytes(str, offset, len);
    }

    public T putString(String string) {
        try {
            return this.putString(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SSHRuntimeException(e);
        }
    }

    public T putPassword(char[] passwd) {
        if (passwd == null) {
            return this.putString("");
        }
        this.putInt(passwd.length);
        this.ensureCapacity(passwd.length);
        for (char c : passwd) {
            this.data[this.wpos++] = (byte)c;
        }
        Arrays.fill(passwd, ' ');
        return (T)this;
    }

    public PublicKey readPublicKey() {
        try {
            switch (KeyType.fromString(this.readString())) {
                case RSA: {
                    BigInteger e = this.readMPInt();
                    BigInteger n = this.readMPInt();
                    KeyFactory keyFactory = SecurityUtils.getKeyFactory("RSA");
                    return keyFactory.generatePublic(new RSAPublicKeySpec(n, e));
                }
                case DSA: {
                    BigInteger p = this.readMPInt();
                    BigInteger q = this.readMPInt();
                    BigInteger g = this.readMPInt();
                    BigInteger y = this.readMPInt();
                    KeyFactory keyFactory = SecurityUtils.getKeyFactory("DSA");
                    return keyFactory.generatePublic(new DSAPublicKeySpec(y, p, q, g));
                }
            }
            assert (false);
        }
        catch (GeneralSecurityException e) {
            throw new SSHRuntimeException(e);
        }
        return null;
    }

    public T putPublicKey(PublicKey key) {
        KeyType type = KeyType.fromKey(key);
        switch (type) {
            case RSA: {
                RSAPublicKey rsaKey = (RSAPublicKey)key;
                ((Buffer)((Buffer)this.putString(type.toString())).putMPInt(rsaKey.getPublicExponent())).putMPInt(rsaKey.getModulus());
                break;
            }
            case DSA: {
                DSAPublicKey dsaKey = (DSAPublicKey)key;
                ((Buffer)((Buffer)((Buffer)((Buffer)this.putString(type.toString())).putMPInt(dsaKey.getParams().getP())).putMPInt(dsaKey.getParams().getQ())).putMPInt(dsaKey.getParams().getG())).putMPInt(dsaKey.getY());
                break;
            }
            default: {
                throw new SSHRuntimeException("Don't know how to encode key: " + key);
            }
        }
        return (T)this;
    }

    public T putSignature(String sigFormat, byte[] sigData) {
        byte[] sig = ((PlainBuffer)((PlainBuffer)new PlainBuffer().putString(sigFormat)).putBytes(sigData)).getCompactData();
        return this.putString(sig);
    }

    public String printHex() {
        return ByteArrayUtils.printHex(this.array(), this.rpos(), this.available());
    }

    public String toString() {
        return "Buffer [rpos=" + this.rpos + ", wpos=" + this.wpos + ", size=" + this.data.length + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PlainBuffer
    extends Buffer<PlainBuffer> {
        public PlainBuffer() {
        }

        public PlainBuffer(Buffer<?> from) {
            super(from);
        }

        public PlainBuffer(byte[] b) {
            super(b);
        }

        public PlainBuffer(int size) {
            super(size);
        }
    }

    public static class BufferException
    extends SSHRuntimeException {
        public BufferException(String message) {
            super(message);
        }
    }
}

