/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import java.security.Key;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum KeyType {
    RSA("ssh-rsa", new KeyChecker(){

        public boolean isMyType(Key key) {
            return key instanceof RSAPublicKey || key instanceof RSAPrivateKey;
        }
    }),
    DSA("ssh-dss", new KeyChecker(){

        public boolean isMyType(Key key) {
            return key instanceof DSAPublicKey || key instanceof DSAPrivateKey;
        }
    }),
    UNKNOWN("unknown", null);

    private final String sType;
    private final KeyChecker checker;

    private KeyType(String type, KeyChecker checker) {
        this.sType = type;
        this.checker = checker;
    }

    public static KeyType fromKey(Key key) {
        for (KeyType kt : KeyType.values()) {
            if (kt.checker == null || !kt.checker.isMyType(key)) continue;
            return kt;
        }
        return UNKNOWN;
    }

    public static KeyType fromString(String sType) {
        for (KeyType kt : KeyType.values()) {
            if (!kt.sType.equals(sType)) continue;
            return kt;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.sType;
    }

    private static interface KeyChecker {
        public boolean isMyType(Key var1);
    }
}

