/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Message {
    DISCONNECT(1),
    IGNORE(2),
    UNIMPLEMENTED(3),
    DEBUG(4),
    SERVICE_REQUEST(5),
    SERVICE_ACCEPT(6),
    KEXINIT(20),
    NEWKEYS(21),
    KEXDH_INIT(30),
    KEXDH_31(31),
    KEX_DH_GEX_INIT(32),
    KEX_DH_GEX_REPLY(33),
    KEX_DH_GEX_REQUEST(34),
    USERAUTH_REQUEST(50),
    USERAUTH_FAILURE(51),
    USERAUTH_SUCCESS(52),
    USERAUTH_BANNER(53),
    USERAUTH_60(60),
    USERAUTH_INFO_RESPONSE(61),
    GLOBAL_REQUEST(80),
    REQUEST_SUCCESS(81),
    REQUEST_FAILURE(82),
    CHANNEL_OPEN(90),
    CHANNEL_OPEN_CONFIRMATION(91),
    CHANNEL_OPEN_FAILURE(92),
    CHANNEL_WINDOW_ADJUST(93),
    CHANNEL_DATA(94),
    CHANNEL_EXTENDED_DATA(95),
    CHANNEL_EOF(96),
    CHANNEL_CLOSE(97),
    CHANNEL_REQUEST(98),
    CHANNEL_SUCCESS(99),
    CHANNEL_FAILURE(100);

    private final byte b;
    private static final Message[] cache;

    public static Message fromByte(byte b) {
        return cache[b];
    }

    private Message(int b) {
        this.b = (byte)b;
    }

    public boolean geq(int num) {
        return this.b >= num;
    }

    public boolean gt(int num) {
        return this.b > num;
    }

    public boolean in(int x, int y) {
        return this.b >= x && this.b <= y;
    }

    public boolean leq(int num) {
        return this.b <= num;
    }

    public boolean lt(int num) {
        return this.b < num;
    }

    public byte toByte() {
        return this.b;
    }

    static {
        cache = new Message[256];
        for (Message c : Message.values()) {
            if (cache[c.toByte()] != null) continue;
            Message.cache[c.toByte()] = c;
        }
    }
}

