/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel;

import net.schmizz.sshj.connection.ConnectionException;

public class OpenFailException
extends ConnectionException {
    private final String channelType;
    private final Reason reason;
    private final String message;

    public OpenFailException(String channelType, int reasonCode, String message) {
        super(message);
        this.channelType = channelType;
        this.reason = Reason.fromInt(reasonCode);
        this.message = message;
    }

    public OpenFailException(String channelType, Reason reason, String message) {
        super(message);
        this.channelType = channelType;
        this.reason = reason;
        this.message = message;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public String getMessage() {
        return this.message;
    }

    public Reason getReason() {
        return this.reason;
    }

    public String toString() {
        return "Opening `" + this.channelType + "` channel failed: " + this.getMessage();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reason {
        UNKNOWN(0),
        ADMINISTRATIVELY_PROHIBITED(1),
        CONNECT_FAILED(2),
        UNKNOWN_CHANNEL_TYPE(3),
        RESOURCE_SHORTAGE(4);

        private final int code;

        public static Reason fromInt(int code) {
            for (Reason rc : Reason.values()) {
                if (rc.code != code) continue;
                return rc;
            }
            return UNKNOWN;
        }

        private Reason(int rc) {
            this.code = rc;
        }

        public int getCode() {
            return this.code;
        }
    }
}

