/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel;

import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Window {
    protected final Logger log;
    protected final Object lock = new Object();
    protected final int maxPacketSize;
    protected int size;

    public Window(int chanID, String kindOfWindow, int initialWinSize, int maxPacketSize) {
        this.log = LoggerFactory.getLogger((String)("<< chan#" + chanID + " / " + kindOfWindow + " >>"));
        this.size = initialWinSize;
        this.maxPacketSize = maxPacketSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(int inc) {
        Object object = this.lock;
        synchronized (object) {
            this.log.debug("Increasing by {} up to {}", (Object)inc, (Object)this.size);
            this.size += inc;
            this.lock.notifyAll();
        }
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public int getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(int dec) {
        Object object = this.lock;
        synchronized (object) {
            this.log.debug("Consuming by " + dec + " down to " + this.size);
            this.size -= dec;
            if (this.size < 0) {
                throw new SSHRuntimeException("Window consumed to below 0");
            }
        }
    }

    public String toString() {
        return "[winSize=" + this.size + "]";
    }

    public static final class Local
    extends Window {
        private final int initialSize;
        private final int threshold;

        public Local(int chanID, int initialWinSize, int maxPacketSize) {
            super(chanID, "local win", initialWinSize, maxPacketSize);
            this.initialSize = initialWinSize;
            this.threshold = Math.min(maxPacketSize * 20, this.initialSize / 4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int neededAdjustment() throws TransportException {
            Object object = this.lock;
            synchronized (object) {
                return this.size - this.threshold <= 0 ? this.initialSize - this.size : 0;
            }
        }
    }

    public static final class Remote
    extends Window {
        public Remote(int chanID, int initialWinSize, int maxPacketSize) {
            super(chanID, "remote win", initialWinSize, maxPacketSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitAndConsume(int howMuch) throws ConnectionException {
            Object object = this.lock;
            synchronized (object) {
                while (this.size < howMuch) {
                    this.log.debug("Waiting, need window space for {} bytes", (Object)howMuch);
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException ie) {
                        throw new ConnectionException(ie);
                    }
                }
                this.consume(howMuch);
            }
        }
    }
}

