/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel.direct;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.ChannelInputStream;
import net.schmizz.sshj.connection.channel.direct.AbstractDirectChannel;
import net.schmizz.sshj.connection.channel.direct.PTYMode;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.Signal;
import net.schmizz.sshj.transport.TransportException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionChannel
extends AbstractDirectChannel
implements Session,
Session.Command,
Session.Shell,
Session.Subsystem {
    private Integer exitStatus;
    private Signal exitSignal;
    private Boolean wasCoreDumped;
    private String exitErrMsg;
    private Boolean canDoFlowControl;
    private ChannelInputStream err;

    public SessionChannel(Connection conn) {
        super(conn, "session");
        this.err = new ChannelInputStream(this, this.trans, this.lwin);
    }

    @Override
    public void allocateDefaultPTY() throws ConnectionException, TransportException {
        HashMap<PTYMode, Integer> modes = new HashMap<PTYMode, Integer>();
        modes.put(PTYMode.ISIG, 1);
        modes.put(PTYMode.ICANON, 1);
        modes.put(PTYMode.ECHO, 0);
        modes.put(PTYMode.ECHOE, 0);
        modes.put(PTYMode.ECHOK, 0);
        modes.put(PTYMode.ECHONL, 0);
        modes.put(PTYMode.NOFLSH, 0);
        this.allocatePTY("vt100", 0, 0, 0, 0, modes);
    }

    @Override
    public void allocatePTY(String term, int cols, int rows, int width, int height, Map<PTYMode, Integer> modes) throws ConnectionException, TransportException {
        this.sendChannelRequest("pty-req", true, (Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(term)).putInt(cols)).putInt(rows)).putInt(width)).putInt(height)).putBytes(PTYMode.encode(modes))).await(this.conn.getTimeout(), TimeUnit.SECONDS);
    }

    @Override
    public Boolean canDoFlowControl() {
        return this.canDoFlowControl;
    }

    @Override
    public void changeWindowDimensions(int cols, int rows, int width, int height) throws TransportException {
        this.sendChannelRequest("pty-req", false, (Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putInt(cols)).putInt(rows)).putInt(width)).putInt(height));
    }

    @Override
    public Session.Command exec(String command) throws ConnectionException, TransportException {
        this.log.info("Will request to exec `{}`", (Object)command);
        this.sendChannelRequest("exec", true, (Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(command)).await(this.conn.getTimeout(), TimeUnit.SECONDS);
        return this;
    }

    @Override
    public String getErrorAsString() throws IOException {
        return StreamCopier.copyStreamToString(this.err);
    }

    @Override
    public InputStream getErrorStream() {
        return this.err;
    }

    @Override
    public String getExitErrorMessage() {
        return this.exitErrMsg;
    }

    @Override
    public Signal getExitSignal() {
        return this.exitSignal;
    }

    @Override
    public Integer getExitStatus() {
        return this.exitStatus;
    }

    @Override
    public String getOutputAsString() throws IOException {
        return StreamCopier.copyStreamToString(this.getInputStream());
    }

    @Override
    public void handleRequest(String req, SSHPacket buf) throws ConnectionException, TransportException {
        if ("xon-xoff".equals(req)) {
            this.canDoFlowControl = buf.readBoolean();
        } else if ("exit-status".equals(req)) {
            this.exitStatus = buf.readInt();
        } else if ("exit-signal".equals(req)) {
            this.exitSignal = Signal.fromString(buf.readString());
            this.wasCoreDumped = buf.readBoolean();
            this.exitErrMsg = buf.readString();
            this.sendClose();
        } else {
            super.handleRequest(req, buf);
        }
    }

    @Override
    public void reqX11Forwarding(String authProto, String authCookie, int screen) throws ConnectionException, TransportException {
        this.sendChannelRequest("x11-req", true, (Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putBoolean(false)).putString(authProto)).putString(authCookie)).putInt(screen)).await(this.conn.getTimeout(), TimeUnit.SECONDS);
    }

    @Override
    public void setEnvVar(String name, String value) throws ConnectionException, TransportException {
        this.sendChannelRequest("env", true, (Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(name)).putString(value)).await(this.conn.getTimeout(), TimeUnit.SECONDS);
    }

    @Override
    public void signal(Signal sig) throws TransportException {
        this.sendChannelRequest("signal", false, (Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(sig.toString()));
    }

    @Override
    public Session.Shell startShell() throws ConnectionException, TransportException {
        this.sendChannelRequest("shell", true, null).await(this.conn.getTimeout(), TimeUnit.SECONDS);
        return this;
    }

    @Override
    public Session.Subsystem startSubsystem(String name) throws ConnectionException, TransportException {
        this.log.info("Will request `{}` subsystem", (Object)name);
        this.sendChannelRequest("subsystem", true, (Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(name)).await(this.conn.getTimeout(), TimeUnit.SECONDS);
        return this;
    }

    @Override
    public Boolean getExitWasCoreDumped() {
        return this.wasCoreDumped;
    }

    @Override
    protected void closeAllStreams() {
        IOUtils.closeQuietly(this.err);
        super.closeAllStreams();
    }

    @Override
    protected void eofInputStreams() {
        this.err.eof();
        super.eofInputStreams();
    }

    @Override
    protected void gotExtendedData(int dataTypeCode, SSHPacket buf) throws ConnectionException, TransportException {
        if (dataTypeCode == 1) {
            this.receiveInto(this.err, buf);
        } else {
            super.gotExtendedData(dataTypeCode, buf);
        }
    }
}

